/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.advnavigator;

import com.github.gwtbootstrap.client.ui.Dropdown;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.client.advnavigator.Navigator;
import org.guvnor.structure.client.advnavigator.NavigatorBreadcrumbs;
import org.guvnor.structure.client.advnavigator.NavigatorOptions;
import org.guvnor.structure.client.resources.NavigatorResources;
import org.guvnor.structure.navigator.DataContent;
import org.guvnor.structure.navigator.FileNavigatorService;
import org.guvnor.structure.navigator.NavigatorContent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.type.DotResourceTypeDefinition;

@Dependent
@Named(value="FlatNav")
public class BreadcrumNavigator
extends Composite
implements Navigator {
    @Inject
    private Caller<FileNavigatorService> navigatorService;
    @Inject
    private DotResourceTypeDefinition hiddenTypeDef;
    private final FlowPanel container = new FlowPanel();
    private final FlexTable navigator = new FlexTable(){
        {
            this.setStyleName(NavigatorResources.INSTANCE.css().navigator());
        }
    };
    private NavigatorOptions options = NavigatorOptions.DEFAULT;
    private ParameterizedCommand<Path> fileActionCommand = null;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)this.container);
    }

    @Override
    public void loadContent(final Path path) {
        if (path != null) {
            ((FileNavigatorService)this.navigatorService.call((RemoteCallback)new RemoteCallback<NavigatorContent>(){

                public void callback(NavigatorContent response) {
                    BreadcrumNavigator.this.container.clear();
                    BreadcrumNavigator.this.navigator.removeAllRows();
                    BreadcrumNavigator.this.setupBreadcrumb(response, path);
                    BreadcrumNavigator.this.setupUpFolder(response);
                    BreadcrumNavigator.this.setupContent(response);
                    BreadcrumNavigator.this.container.add((Widget)BreadcrumNavigator.this.navigator);
                }
            })).listContent(path);
        }
    }

    private void setupBreadcrumb(final NavigatorContent response, final Path path) {
        this.container.add((Widget)new NavigatorBreadcrumbs(NavigatorBreadcrumbs.Mode.SECOND_LEVEL){
            {
                super(x0);
                this.build(response.getRoot(), response.getBreadcrumbs(), path, new ParameterizedCommand<Path>(){

                    public void execute(Path path) {
                        BreadcrumNavigator.this.loadContent(path);
                    }
                }, new Dropdown[0]);
            }
        });
    }

    private void setupContent(NavigatorContent content) {
        int base = this.navigator.getRowCount();
        for (int i = 0; i < content.getContent().size(); ++i) {
            DataContent dataContent = (DataContent)content.getContent().get(i);
            if (dataContent.isDirectory() && this.options.showDirectories()) {
                this.createDirectory(base + i, dataContent);
                continue;
            }
            if (!this.options.showFiles()) continue;
            if (!this.options.showHiddenFiles() && !this.hiddenTypeDef.accept(dataContent.getPath())) {
                this.createFile(base + i, dataContent);
                continue;
            }
            if (!this.options.showHiddenFiles()) continue;
            this.createFile(base + i, dataContent);
        }
    }

    private void setupUpFolder(NavigatorContent content) {
        if (this.options.allowUpLink() && content.getBreadcrumbs().size() > 0) {
            this.createUpFolder((Path)content.getBreadcrumbs().get(content.getBreadcrumbs().size() - 1));
        }
    }

    private void createFile(int row, final DataContent dataContent) {
        this.createElement(row, dataContent, IconType.FILE_ALT, NavigatorResources.INSTANCE.css().navigatoFileIcon(), new Command(){

            public void execute() {
                if (BreadcrumNavigator.this.fileActionCommand != null) {
                    BreadcrumNavigator.this.fileActionCommand.execute((Object)dataContent.getPath());
                }
            }
        });
    }

    private void createDirectory(int row, final DataContent dataContent) {
        this.createElement(row, dataContent, IconType.FOLDER_CLOSE, NavigatorResources.INSTANCE.css().navigatorFolderIcon(), new Command(){

            public void execute() {
                BreadcrumNavigator.this.loadContent(dataContent.getPath());
            }
        });
    }

    private void createUpFolder(final Path path) {
        int col = 0;
        this.navigator.setText(0, col, "");
        this.navigator.setWidget(0, ++col, (Widget)new Anchor(".."){
            {
                super(x0);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        BreadcrumNavigator.this.loadContent(path);
                    }
                });
            }
        });
        if (this.options.showItemAge()) {
            this.navigator.setText(0, ++col, "");
        }
        if (this.options.showItemMessage()) {
            this.navigator.setText(0, ++col, "");
        }
    }

    private void createElement(int row, DataContent dataContent, IconType iconType, final String style, final Command onClick) {
        int col = 0;
        this.navigator.setWidget(row, col, (Widget)new Icon(iconType){
            {
                super(x0);
                this.addStyleName(style);
            }
        });
        this.navigator.setWidget(row, ++col, (Widget)new Anchor(dataContent.getPath().getFileName()){
            {
                super(x0);
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        onClick.execute();
                    }
                });
            }
        });
        if (this.options.showItemAge()) {
            this.navigator.setText(row, ++col, dataContent.getAge());
        }
        if (this.options.showItemMessage()) {
            com.google.gwt.user.client.Element messageCol = DOM.createSpan();
            messageCol.addClassName(NavigatorResources.INSTANCE.css().navigatorMessage());
            com.google.gwt.user.client.Element message = DOM.createSpan();
            message.addClassName(NavigatorResources.INSTANCE.css().message());
            message.setInnerText(dataContent.getLastMessage());
            messageCol.appendChild((Node)message);
            if (this.options.showItemLastUpdater()) {
                com.google.gwt.user.client.Element colOpen = DOM.createSpan();
                colOpen.addClassName(NavigatorResources.INSTANCE.css().message());
                colOpen.setInnerText(" [");
                messageCol.appendChild((Node)colOpen);
                Anchor commiterRef = new Anchor(dataContent.getLastCommiter());
                DOM.sinkEvents((Element)commiterRef.getElement(), (int)1);
                DOM.setEventListener((Element)commiterRef.getElement(), (EventListener)new EventListener(){

                    public void onBrowserEvent(Event event) {
                    }
                });
                messageCol.appendChild((Node)commiterRef.getElement());
                com.google.gwt.user.client.Element colClose = DOM.createSpan();
                colClose.addClassName(NavigatorResources.INSTANCE.css().message());
                colClose.setInnerText("]");
                messageCol.appendChild((Node)colClose);
            }
            this.navigator.setWidget(row, ++col, new Widget((Element)messageCol){
                final /* synthetic */ Element val$messageCol;
                {
                    this.val$messageCol = element;
                    this.setElement(this.val$messageCol);
                }
            });
        }
    }
}

