/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.advnavigator;

import com.github.gwtbootstrap.client.ui.Dropdown;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.base.ListItem;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.guvnor.structure.client.resources.NavigatorResources;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.common.client.common.UberBreadcrumbs;
import org.uberfire.mvp.ParameterizedCommand;

public class NavigatorBreadcrumbs
extends Composite {
    private final UberBreadcrumbs breadcrumbs = new UberBreadcrumbs();

    public NavigatorBreadcrumbs() {
        this(Mode.REGULAR);
    }

    public NavigatorBreadcrumbs(Mode mode) {
        this.initWidget((Widget)this.breadcrumbs);
        if (mode != null) {
            switch (mode) {
                case HEADER: {
                    this.breadcrumbs.removeStyleName("breadcrumb");
                    this.breadcrumbs.setStyleName(NavigatorResources.INSTANCE.css().breadcrumb());
                    break;
                }
                case SECOND_LEVEL: {
                    this.breadcrumbs.addStyleName(NavigatorResources.INSTANCE.css().breadcrumb2ndLevel());
                }
            }
        }
    }

    public void build(Path root, List<Path> path, Path file, final ParameterizedCommand<Path> onPathClick, Dropdown ... headers) {
        this.build(headers);
        if (path != null && !path.isEmpty()) {
            for (final Path activePath : path) {
                this.breadcrumbs.add((Widget)new NavLink(activePath.getFileName()){
                    {
                        super(x0);
                        this.setStyleName(NavigatorResources.INSTANCE.css().directory());
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                onPathClick.execute((Object)activePath);
                            }
                        });
                    }
                });
            }
        }
        if (file != null && !file.equals(root)) {
            this.breadcrumbs.add((Widget)new ListItem(new Widget[]{new InlineLabel(file.getFileName())}){
                {
                    this.setStyleName(NavigatorResources.INSTANCE.css().directory());
                }
            });
        }
    }

    public void build(Dropdown ... headers) {
        this.breadcrumbs.clear();
        for (int i = 0; i < headers.length; ++i) {
            Dropdown header = headers[i];
            header.addStyleName(NavigatorResources.INSTANCE.css().breadcrumbHeader());
            if (i + 1 == headers.length) {
                header.setRightDropdown(true);
            }
            this.breadcrumbs.add((Widget)header);
        }
    }

    public static enum Mode {
        REGULAR,
        HEADER,
        SECOND_LEVEL;

    }
}

