/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.create;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.structure.client.editors.repository.RepositoryPreferences;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.ioc.client.container.IOCBeanDef;
import org.jboss.errai.ioc.client.container.IOCResolutionException;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class CreateRepositoryForm
extends Composite
implements HasCloseHandlers<CreateRepositoryForm> {
    private static CreateRepositoryFormBinder uiBinder = (CreateRepositoryFormBinder)GWT.create(CreateRepositoryFormBinder.class);
    @Inject
    private Caller<RepositoryService> repositoryService;
    @Inject
    private Caller<OrganizationalUnitService> organizationalUnitService;
    @Inject
    private PlaceManager placeManager;
    @UiField
    ControlGroup organizationalUnitGroup;
    @UiField
    HelpInline organizationalUnitHelpInline;
    @UiField
    ListBox organizationalUnitDropdown;
    @UiField
    ControlGroup nameGroup;
    @UiField
    TextBox nameTextBox;
    @UiField
    HelpInline nameHelpInline;
    @UiField
    InlineHTML isOUMandatory;
    @UiField
    BaseModal popup;
    private Map<String, OrganizationalUnit> availableOrganizationalUnits = new HashMap<String, OrganizationalUnit>();
    private boolean mandatoryOU = true;

    @PostConstruct
    public void init() {
        this.mandatoryOU = this.isOUMandatory();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        if (!this.mandatoryOU) {
            this.isOUMandatory.removeFromParent();
        }
        this.popup.setDynamicSafe(true);
        this.nameTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                CreateRepositoryForm.this.nameGroup.setType(ControlGroupType.NONE);
                CreateRepositoryForm.this.nameHelpInline.setText("");
            }
        });
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<Collection<OrganizationalUnit>>(){

            public void callback(Collection<OrganizationalUnit> organizationalUnits) {
                CreateRepositoryForm.this.organizationalUnitDropdown.addItem(CoreConstants.INSTANCE.SelectEntry());
                if (organizationalUnits != null && !organizationalUnits.isEmpty()) {
                    for (OrganizationalUnit organizationalUnit : organizationalUnits) {
                        CreateRepositoryForm.this.organizationalUnitDropdown.addItem(organizationalUnit.getName(), organizationalUnit.getName());
                        CreateRepositoryForm.this.availableOrganizationalUnits.put(organizationalUnit.getName(), organizationalUnit);
                    }
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                Window.alert((String)(CoreConstants.INSTANCE.CantLoadOrganizationalUnits() + " \n" + message.toString()));
                return false;
            }
        })).getOrganizationalUnits();
    }

    private boolean isOUMandatory() {
        try {
            IOCBeanDef beanDef = IOC.getBeanManager().lookupBean(RepositoryPreferences.class, new Annotation[0]);
            return beanDef == null || ((RepositoryPreferences)beanDef.getInstance()).isOUMandatory();
        }
        catch (IOCResolutionException iOCResolutionException) {
            return true;
        }
    }

    public HandlerRegistration addCloseHandler(CloseHandler<CreateRepositoryForm> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    @UiHandler(value={"create"})
    public void onCreateClick(ClickEvent e) {
        final String organizationalUnit = this.organizationalUnitDropdown.getValue(this.organizationalUnitDropdown.getSelectedIndex());
        if (this.mandatoryOU && !this.availableOrganizationalUnits.containsKey(organizationalUnit)) {
            this.organizationalUnitGroup.setType(ControlGroupType.ERROR);
            this.organizationalUnitHelpInline.setText(CoreConstants.INSTANCE.OrganizationalUnitMandatory());
            return;
        }
        this.organizationalUnitGroup.setType(ControlGroupType.NONE);
        if (this.nameTextBox.getText() == null || this.nameTextBox.getText().trim().isEmpty()) {
            this.nameGroup.setType(ControlGroupType.ERROR);
            this.nameHelpInline.setText(CoreConstants.INSTANCE.RepositoryNaneMandatory());
            return;
        }
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String normalizedName) {
                if (!CreateRepositoryForm.this.nameTextBox.getText().equals(normalizedName)) {
                    if (!Window.confirm((String)(CoreConstants.INSTANCE.RepositoryNameInvalid() + " \"" + normalizedName + "\". " + CoreConstants.INSTANCE.DoYouAgree()))) {
                        return;
                    }
                    CreateRepositoryForm.this.nameTextBox.setText(normalizedName);
                }
                String scheme = "git";
                String alias = CreateRepositoryForm.this.nameTextBox.getText().trim();
                HashMap env = new HashMap(3);
                ((RepositoryService)CreateRepositoryForm.this.repositoryService.call((RemoteCallback)new RemoteCallback<Repository>(){

                    public void callback(Repository o) {
                        Window.alert((String)CoreConstants.INSTANCE.RepoCreationSuccess());
                        CreateRepositoryForm.this.hide();
                        CreateRepositoryForm.this.placeManager.goTo(new DefaultPlaceRequest("RepositoryEditor").addParameter("alias", o.getAlias()));
                    }
                }, (ErrorCallback)new ErrorCallback<Message>(){

                    public boolean error(Message message, Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (RepositoryAlreadyExistsException ex) {
                            ErrorPopup.showMessage((String)CoreConstants.INSTANCE.RepoAlreadyExists());
                        }
                        catch (Throwable ex) {
                            ErrorPopup.showMessage((String)(CoreConstants.INSTANCE.RepoCreationFail() + " \n" + throwable.getMessage()));
                        }
                        return true;
                    }
                })).createRepository((OrganizationalUnit)CreateRepositoryForm.this.availableOrganizationalUnits.get(organizationalUnit), "git", alias, env);
            }
        })).normalizeRepositoryName(this.nameTextBox.getText());
    }

    @UiHandler(value={"cancel"})
    public void onCancelClick(ClickEvent e) {
        this.hide();
    }

    public void hide() {
        this.popup.hide();
        CloseEvent.fire((HasCloseHandlers)this, (Object)((Object)this));
    }

    public void show() {
        this.popup.show();
    }

    static interface CreateRepositoryFormBinder
    extends UiBinder<Widget, CreateRepositoryForm> {
    }
}

