/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.navigator;

import com.github.gwtbootstrap.client.ui.Breadcrumbs;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.base.ListItem;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.guvnor.structure.client.resources.NavigatorResources;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mvp.ParameterizedCommand;

public class Breadcrumb
extends Composite {
    private final ParameterizedCommand<Path> onPathClick;
    private final ParameterizedCommand<Path> onAddClick;
    private final Breadcrumbs breadcrumbs = new Breadcrumbs();

    public Breadcrumb() {
        this(null, null);
    }

    public Breadcrumb(ParameterizedCommand<Path> onPathClick, ParameterizedCommand<Path> onAddClick) {
        this.initWidget((Widget)this.breadcrumbs);
        this.onPathClick = onPathClick;
        this.onAddClick = onAddClick;
        this.breadcrumbs.removeStyleName("breadcrumb");
        this.breadcrumbs.setStyleName(NavigatorResources.INSTANCE.css().breadcrumb());
    }

    public void build(String repoName, final Path root, List<Path> path, Path file) {
        this.breadcrumbs.clear();
        if (repoName != null) {
            if (this.onPathClick == null) {
                this.breadcrumbs.add((Widget)new ListItem(new Widget[]{new InlineLabel(repoName)}){
                    {
                        this.setStyleName(NavigatorResources.INSTANCE.css().repoName());
                    }
                });
            } else {
                this.breadcrumbs.add((Widget)new NavLink(repoName){
                    {
                        super(x0);
                        this.setStyleName(NavigatorResources.INSTANCE.css().repoName());
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                Breadcrumb.this.onPathClick.execute((Object)root);
                            }
                        });
                    }
                });
            }
        } else if (root != null) {
            if (this.onPathClick == null) {
                this.breadcrumbs.add((Widget)new ListItem(new Widget[]{new InlineLabel(file.getFileName())}){
                    {
                        this.setStyleName(NavigatorResources.INSTANCE.css().repoName());
                    }
                });
            } else {
                this.breadcrumbs.add((Widget)new NavLink(root.getFileName()){
                    {
                        super(x0);
                        this.setStyleName(NavigatorResources.INSTANCE.css().repoName());
                        this.addClickHandler(new ClickHandler(){

                            public void onClick(ClickEvent event) {
                                Breadcrumb.this.onPathClick.execute((Object)root);
                            }
                        });
                    }
                });
            }
        }
        if (path != null && !path.isEmpty()) {
            if (this.onPathClick == null) {
                for (Path activePath : path) {
                    this.breadcrumbs.add((Widget)new ListItem(new Widget[]{new InlineLabel(activePath.getFileName()){
                        {
                            this.setStyleName(NavigatorResources.INSTANCE.css().directory());
                        }
                    }}));
                }
            } else {
                for (final Path activePath : path) {
                    this.breadcrumbs.add((Widget)new NavLink(activePath.getFileName()){
                        {
                            super(x0);
                            this.setStyleName(NavigatorResources.INSTANCE.css().directory());
                            this.addClickHandler(new ClickHandler(){

                                public void onClick(ClickEvent event) {
                                    Breadcrumb.this.onPathClick.execute((Object)activePath);
                                }
                            });
                        }
                    });
                }
            }
        }
        if (file != null && !file.equals(root)) {
            this.breadcrumbs.add((Widget)new ListItem(new Widget[]{new InlineLabel(file.getFileName())}){
                {
                    this.setStyleName(NavigatorResources.INSTANCE.css().directory());
                }
            });
        }
        if (this.onAddClick != null) {
            // empty if block
        }
    }
}

