/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.fileexplorer;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.client.editors.fileexplorer.PathSelectedEvent;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryUpdatedEvent;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.DirectoryStream;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceBatchChangesEvent;
import org.uberfire.workbench.events.ResourceCopiedEvent;
import org.uberfire.workbench.events.ResourceDeletedEvent;
import org.uberfire.workbench.events.ResourceRenamedEvent;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@Dependent
@WorkbenchScreen(identifier="FileExplorer")
public class FileExplorerPresenter {
    @Inject
    private View view;
    @Inject
    private Caller<VFSService> vfsService;
    @Inject
    private Caller<RepositoryService> repositoryService;
    @Inject
    private Event<PathSelectedEvent> pathSelectedEvent;
    @Inject
    private PlaceManager placeManager;
    private Set<Repository> repositories = new HashSet<Repository>();

    @OnStartup
    public void onStartup() {
        this.view.reset();
        this.repositories.clear();
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<Collection<Repository>>(){

            public void callback(Collection<Repository> response) {
                for (Repository root : response) {
                    if (FileExplorerPresenter.this.repositories.contains(root)) {
                        FileExplorerPresenter.this.view.removeRepository(root);
                    }
                    FileExplorerPresenter.this.view.addNewRepository(root);
                    FileExplorerPresenter.this.repositories.add(root);
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message o, Throwable throwable) {
                return false;
            }
        })).getRepositories();
    }

    public void loadDirectoryContent(final FileExplorerItem item, Path path) {
        ((VFSService)this.vfsService.call((RemoteCallback)new RemoteCallback<DirectoryStream<Path>>(){

            public void callback(DirectoryStream<Path> response) {
                for (final Path child : response) {
                    ((VFSService)FileExplorerPresenter.this.vfsService.call((RemoteCallback)new RemoteCallback<Map>(){

                        public void callback(Map response) {
                            if (FileExplorerPresenter.this.isDirectory(response)) {
                                item.addDirectory(child);
                            } else {
                                item.addFile(child);
                            }
                        }
                    })).readAttributes(child);
                }
            }
        })).newDirectoryStream(path);
    }

    private boolean isDirectory(Map response) {
        return response != null && response.containsKey("isDirectory") && (Boolean)response.get("isDirectory") != false;
    }

    private boolean isRegularFile(Map response) {
        return response != null && response.containsKey("isRegularFile") && (Boolean)response.get("isRegularFile") != false;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return CoreConstants.INSTANCE.FileExplorer();
    }

    @WorkbenchPartView
    public UberView<FileExplorerPresenter> getWidget() {
        return this.view;
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.WEST;
    }

    public void redirect(final Path path) {
        this.pathSelectedEvent.fire((Object)new PathSelectedEvent(path));
        ((VFSService)this.vfsService.call((RemoteCallback)new RemoteCallback<Map>(){

            public void callback(Map response) {
                if (FileExplorerPresenter.this.isRegularFile(response)) {
                    FileExplorerPresenter.this.placeManager.goTo(path);
                }
            }
        })).readAttributes(path);
    }

    public void redirectRepositoryList() {
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("RepositoriesEditor"));
    }

    public void redirect(Repository repo) {
        this.placeManager.goTo(new DefaultPlaceRequest("RepositoryEditor").addParameter("alias", repo.getAlias()));
    }

    public void newRootDirectory(@Observes NewRepositoryEvent event) {
        Repository repository = event.getNewRepository();
        if (repository == null) {
            return;
        }
        if (this.repositories.contains(repository)) {
            this.view.removeRepository(repository);
        }
        this.view.addNewRepository(repository);
        this.repositories.add(repository);
    }

    public void removeRootDirectory(@Observes RepositoryRemovedEvent event) {
        Repository repository = event.getRepository();
        if (repository == null) {
            return;
        }
        if (this.repositories.contains(repository)) {
            this.view.removeRepository(repository);
            this.repositories.remove(repository);
        }
    }

    public void updateRootDirectory(@Observes RepositoryUpdatedEvent event) {
        Repository repository = event.getRepository();
        Repository updatedRepository = event.getUpdatedRepository();
        if (repository == null) {
            return;
        }
        if (this.repositories.contains(repository)) {
            this.view.removeRepository(repository);
            this.repositories.remove(repository);
        }
        this.view.addNewRepository(updatedRepository);
        this.repositories.add(updatedRepository);
    }

    public void onResourceAdded(@Observes ResourceAddedEvent event) {
        this.refreshView(event.getPath());
    }

    public void onResourceDeleted(@Observes ResourceDeletedEvent event) {
        this.refreshView(event.getPath());
    }

    public void onResourceCopied(@Observes ResourceCopiedEvent event) {
        this.refreshView(event.getDestinationPath());
    }

    public void onResourceRenamed(@Observes ResourceRenamedEvent event) {
        this.refreshView(event.getDestinationPath());
    }

    public void onBatchResourceChange(@Observes ResourceBatchChangesEvent event) {
        this.onStartup();
    }

    public void onSystemRepositoryChanged(@Observes SystemRepositoryChangedEvent event) {
        this.onStartup();
    }

    private void refreshView(Path path) {
        String pathUri = path.toURI();
        for (Repository repository : this.repositories) {
            String repositoryUri = repository.getRoot().toURI();
            if (!pathUri.startsWith(repositoryUri)) continue;
            this.onStartup();
            break;
        }
    }

    public static interface FileExplorerItem {
        public void addDirectory(Path var1);

        public void addFile(Path var1);
    }

    public static interface View
    extends UberView<FileExplorerPresenter> {
        public void reset();

        public void removeRepository(Repository var1);

        public void addNewRepository(Repository var1);
    }
}

