/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.clone;

import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.structure.client.editors.repository.RepositoryPreferences;
import org.guvnor.structure.client.editors.repository.clone.CloneRepositoryView;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.client.api.messaging.Message;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.util.URIUtil;

@Dependent
public class CloneRepositoryPresenter
implements CloneRepositoryView.Presenter {
    private RepositoryPreferences repositoryPreferences;
    private CloneRepositoryView view;
    private Caller<RepositoryService> repositoryService;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private PlaceManager placeManager;
    private Map<String, OrganizationalUnit> availableOrganizationalUnits = new HashMap<String, OrganizationalUnit>();

    @Inject
    public CloneRepositoryPresenter(RepositoryPreferences repositoryPreferences, CloneRepositoryView view, Caller<RepositoryService> repositoryService, Caller<OrganizationalUnitService> organizationalUnitService, PlaceManager placeManager) {
        this.repositoryPreferences = repositoryPreferences;
        this.view = view;
        this.repositoryService = repositoryService;
        this.organizationalUnitService = organizationalUnitService;
        this.placeManager = placeManager;
    }

    @PostConstruct
    public void init() {
        this.view.init(this, this.isOuMandatory());
    }

    @AfterInitialization
    public void load() {
        this.populateOrganizationalUnits();
    }

    @Override
    public void handleCancelClick() {
        this.view.hide();
    }

    @Override
    public void handleCloneClick() {
        if (this.view.isGitUrlEmpty()) {
            this.view.setUrlGroupType(ControlGroupType.ERROR);
            this.view.showUrlHelpMandatoryMessage();
            return;
        }
        if (!URIUtil.isValid((String)this.view.getGitUrl())) {
            this.view.setUrlGroupType(ControlGroupType.ERROR);
            this.view.showUrlHelpInvalidFormatMessage();
            return;
        }
        this.view.setUrlGroupType(ControlGroupType.NONE);
        final String organizationalUnit = this.view.getOrganizationalUnit(this.view.getSelectedOrganizationalUnit());
        if (this.isOuMandatory() && !this.availableOrganizationalUnits.containsKey(organizationalUnit)) {
            this.view.setOrganizationalUnitGroupType(ControlGroupType.ERROR);
            this.view.showOrganizationalUnitHelpMandatoryMessage();
            return;
        }
        this.view.setOrganizationalUnitGroupType(ControlGroupType.NONE);
        if (this.view.isNameEmpty()) {
            this.view.setNameGroupType(ControlGroupType.ERROR);
            this.view.showNameHelpMandatoryMessage();
            return;
        }
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<String>(){

            public void callback(String normalizedName) {
                if (!CloneRepositoryPresenter.this.view.getName().equals(normalizedName)) {
                    if (!CloneRepositoryPresenter.this.view.showAgreeNormalizeNameWindow(normalizedName)) {
                        return;
                    }
                    CloneRepositoryPresenter.this.view.setName(normalizedName);
                }
                CloneRepositoryPresenter.this.lockScreen();
                String scheme = "git";
                String alias = CloneRepositoryPresenter.this.view.getName().trim();
                String origin = CloneRepositoryPresenter.this.view.getGitUrl();
                String username = CloneRepositoryPresenter.this.view.getUsername().trim();
                String password = CloneRepositoryPresenter.this.view.getPassword().trim();
                HashMap<String, String> env = new HashMap<String, String>(3);
                env.put("username", username);
                env.put("crypt:password", password);
                env.put("origin", origin);
                ((RepositoryService)CloneRepositoryPresenter.this.repositoryService.call((RemoteCallback)new RemoteCallback<Repository>(){

                    public void callback(Repository o) {
                        CloneRepositoryPresenter.this.view.alertRepositoryCloned();
                        CloneRepositoryPresenter.this.unlockScreen();
                        CloneRepositoryPresenter.this.view.hide();
                        CloneRepositoryPresenter.this.placeManager.goTo(new DefaultPlaceRequest("RepositoryEditor").addParameter("alias", o.getAlias()));
                    }
                }, (ErrorCallback)new ErrorCallback<Message>(){

                    public boolean error(Message message, Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (RepositoryAlreadyExistsException ex) {
                            CloneRepositoryPresenter.this.view.errorRepositoryAlreadyExist();
                        }
                        catch (Throwable ex) {
                            CloneRepositoryPresenter.this.view.errorCloneRepositoryFail(ex);
                        }
                        CloneRepositoryPresenter.this.unlockScreen();
                        return true;
                    }
                })).createRepository((OrganizationalUnit)CloneRepositoryPresenter.this.availableOrganizationalUnits.get(organizationalUnit), "git", alias, env);
            }
        })).normalizeRepositoryName(this.view.getName());
    }

    public void showForm() {
        this.view.show();
    }

    private void populateOrganizationalUnits() {
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<Collection<OrganizationalUnit>>(){

            public void callback(Collection<OrganizationalUnit> organizationalUnits) {
                CloneRepositoryPresenter.this.view.addOrganizationalUnitSelectEntry();
                if (organizationalUnits != null && !organizationalUnits.isEmpty()) {
                    for (OrganizationalUnit organizationalUnit : organizationalUnits) {
                        CloneRepositoryPresenter.this.view.addOrganizationalUnit(organizationalUnit.getName(), organizationalUnit.getName());
                        CloneRepositoryPresenter.this.availableOrganizationalUnits.put(organizationalUnit.getName(), organizationalUnit);
                    }
                }
            }
        }, (ErrorCallback)new ErrorCallback<Message>(){

            public boolean error(Message message, Throwable throwable) {
                CloneRepositoryPresenter.this.view.errorLoadOrganizationalUnitsFail(throwable);
                return false;
            }
        })).getOrganizationalUnits();
    }

    private void lockScreen() {
        this.view.showBusyPopupMessage();
        this.view.setPopupCloseVisible(false);
        this.view.setCloneEnabled(false);
        this.view.setCancelEnabled(false);
        this.view.setPasswordEnabled(false);
        this.view.setUsernameEnabled(false);
        this.view.setGitUrlEnabled(false);
        this.view.setOrganizationalUnitEnabled(false);
        this.view.setNameEnabled(false);
    }

    private void unlockScreen() {
        this.view.closeBusyPopup();
        this.view.setPopupCloseVisible(true);
        this.view.setCloneEnabled(true);
        this.view.setCancelEnabled(true);
        this.view.setPasswordEnabled(true);
        this.view.setUsernameEnabled(true);
        this.view.setGitUrlEnabled(true);
        this.view.setOrganizationalUnitEnabled(true);
        this.view.setNameEnabled(true);
    }

    private boolean isOuMandatory() {
        return this.repositoryPreferences == null || this.repositoryPreferences.isOUMandatory();
    }
}

