/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.clone;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.github.gwtbootstrap.client.ui.PasswordTextBox;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.guvnor.structure.client.editors.repository.clone.CloneRepositoryView;
import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;

@Dependent
public class CloneRepositoryViewImpl
extends BaseModal
implements CloneRepositoryView {
    private CloneRepositoryView.Presenter presenter;
    private static CloneRepositoryFormBinder uiBinder = (CloneRepositoryFormBinder)GWT.create(CloneRepositoryFormBinder.class);
    @UiField
    Button clone;
    @UiField
    Button cancel;
    @UiField
    ControlGroup organizationalUnitGroup;
    @UiField
    ListBox organizationalUnitDropdown;
    @UiField
    HelpInline organizationalUnitHelpInline;
    @UiField
    ControlGroup nameGroup;
    @UiField
    TextBox nameTextBox;
    @UiField
    HelpInline nameHelpInline;
    @UiField
    ControlGroup urlGroup;
    @UiField
    TextBox gitURLTextBox;
    @UiField
    HelpInline urlHelpInline;
    @UiField
    TextBox usernameTextBox;
    @UiField
    PasswordTextBox passwordTextBox;
    @UiField
    InlineHTML isOUMandatory;

    @UiHandler(value={"clone"})
    public void onCloneClick(ClickEvent e) {
        this.presenter.handleCloneClick();
    }

    @UiHandler(value={"cancel"})
    public void onCancelClick(ClickEvent e) {
        this.presenter.handleCancelClick();
    }

    @Override
    public void init(CloneRepositoryView.Presenter presenter, boolean isOuMandatory) {
        this.presenter = presenter;
        this.add((Widget)uiBinder.createAndBindUi(this));
        this.setTitle(CoreConstants.INSTANCE.CloneRepository());
        if (!isOuMandatory) {
            this.isOUMandatory.removeFromParent();
        }
        this.nameTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                CloneRepositoryViewImpl.this.nameGroup.setType(ControlGroupType.NONE);
                CloneRepositoryViewImpl.this.nameHelpInline.setText("");
            }
        });
        this.gitURLTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                CloneRepositoryViewImpl.this.urlGroup.setType(ControlGroupType.NONE);
                CloneRepositoryViewImpl.this.urlHelpInline.setText("");
            }
        });
    }

    @Override
    public void addOrganizationalUnitSelectEntry() {
        this.organizationalUnitDropdown.addItem(CoreConstants.INSTANCE.SelectEntry());
    }

    @Override
    public void addOrganizationalUnit(String item, String value) {
        this.organizationalUnitDropdown.addItem(item, value);
    }

    @Override
    public int getSelectedOrganizationalUnit() {
        return this.organizationalUnitDropdown.getSelectedIndex();
    }

    @Override
    public String getOrganizationalUnit(int index) {
        return this.organizationalUnitDropdown.getValue(index);
    }

    @Override
    public boolean isGitUrlEmpty() {
        return this.gitURLTextBox.getText() == null || this.gitURLTextBox.getText().trim().isEmpty();
    }

    @Override
    public boolean isNameEmpty() {
        return this.nameTextBox.getText() == null || this.nameTextBox.getText().trim().isEmpty();
    }

    @Override
    public String getGitUrl() {
        return this.gitURLTextBox.getText().trim();
    }

    @Override
    public String getUsername() {
        return this.usernameTextBox.getText();
    }

    @Override
    public String getPassword() {
        return this.passwordTextBox.getText();
    }

    @Override
    public String getName() {
        return this.nameTextBox.getText();
    }

    @Override
    public void setName(String name) {
        this.nameTextBox.setText(name);
    }

    @Override
    public void showUrlHelpMandatoryMessage() {
        this.urlHelpInline.setText(CoreConstants.INSTANCE.URLMandatory());
    }

    @Override
    public void showUrlHelpInvalidFormatMessage() {
        this.urlHelpInline.setText(CoreConstants.INSTANCE.InvalidUrlFormat());
    }

    @Override
    public void setUrlGroupType(ControlGroupType type) {
        this.urlGroup.setType(type);
    }

    @Override
    public void showNameHelpMandatoryMessage() {
        this.nameHelpInline.setText(CoreConstants.INSTANCE.RepositoryNaneMandatory());
    }

    @Override
    public void setNameGroupType(ControlGroupType type) {
        this.nameGroup.setType(type);
    }

    @Override
    public void showOrganizationalUnitHelpMandatoryMessage() {
        this.organizationalUnitHelpInline.setText(CoreConstants.INSTANCE.OrganizationalUnitMandatory());
    }

    @Override
    public void setOrganizationalUnitGroupType(ControlGroupType type) {
        this.organizationalUnitGroup.setType(type);
    }

    @Override
    public void setNameEnabled(boolean enabled) {
        this.nameTextBox.setEnabled(enabled);
    }

    @Override
    public void setOrganizationalUnitEnabled(boolean enabled) {
        this.organizationalUnitDropdown.setEnabled(enabled);
    }

    @Override
    public void setGitUrlEnabled(boolean enabled) {
        this.gitURLTextBox.setEnabled(enabled);
    }

    @Override
    public void setUsernameEnabled(boolean enabled) {
        this.usernameTextBox.setEnabled(enabled);
    }

    @Override
    public void setPasswordEnabled(boolean enabled) {
        this.passwordTextBox.setEnabled(enabled);
    }

    @Override
    public void setCloneEnabled(boolean enabled) {
        this.clone.setEnabled(enabled);
    }

    @Override
    public void setCancelEnabled(boolean enabled) {
        this.cancel.setEnabled(enabled);
    }

    @Override
    public void setPopupCloseVisible(boolean closeVisible) {
        this.setCloseVisible(closeVisible);
    }

    @Override
    public void showBusyPopupMessage() {
        BusyPopup.showMessage((String)CoreConstants.INSTANCE.Cloning());
    }

    @Override
    public void closeBusyPopup() {
        BusyPopup.close();
    }

    @Override
    public boolean showAgreeNormalizeNameWindow(String normalizedName) {
        return Window.confirm((String)(CoreConstants.INSTANCE.RepositoryNameInvalid() + " \"" + normalizedName + "\". " + CoreConstants.INSTANCE.DoYouAgree()));
    }

    @Override
    public void alertRepositoryCloned() {
        Window.alert((String)(CoreConstants.INSTANCE.RepoCloneSuccess() + "\n\n" + CommonConstants.INSTANCE.IndexClonedRepositoryWarning()));
    }

    @Override
    public void errorRepositoryAlreadyExist() {
        ErrorPopup.showMessage((String)CoreConstants.INSTANCE.RepoAlreadyExists());
    }

    @Override
    public void errorCloneRepositoryFail(Throwable cause) {
        ErrorPopup.showMessage((String)(CoreConstants.INSTANCE.RepoCloneFail() + " \n" + cause.getMessage()));
    }

    @Override
    public void errorLoadOrganizationalUnitsFail(Throwable cause) {
        ErrorPopup.showMessage((String)(CoreConstants.INSTANCE.CantLoadOrganizationalUnits() + " \n" + cause.getMessage()));
    }

    static interface CloneRepositoryFormBinder
    extends UiBinder<Widget, CloneRepositoryViewImpl> {
    }
}

