/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.list;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryUpdatedEvent;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.backend.vfs.VFSService;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.lifecycle.OnStartup;

@Dependent
@WorkbenchScreen(identifier="RepositoriesEditor")
public class RepositoriesPresenter {
    @Inject
    private Caller<VFSService> vfsService;
    @Inject
    private Caller<RepositoryService> repositoryService;
    @Inject
    private Event<RepositoryUpdatedEvent> repositoryUpdatedEvent;
    @Inject
    private SyncBeanManager iocManager;
    @Inject
    public View view;

    @OnStartup
    public void onStartup() {
        this.view.init(this);
        this.loadContent();
    }

    private void loadContent() {
        this.view.clear();
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<Collection<Repository>>(){

            public void callback(Collection<Repository> response) {
                RepositoriesPresenter.this.view.clear();
                for (Repository repo : response) {
                    RepositoriesPresenter.this.view.addRepository(repo);
                }
            }
        })).getRepositories();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return CoreConstants.INSTANCE.RepositoryEditor();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.view;
    }

    public void updateRepository(final Repository repository, Map<String, Object> config) {
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<Repository>(){

            public void callback(Repository updatedRepository) {
                RepositoriesPresenter.this.view.updateRepository(repository, updatedRepository);
                RepositoriesPresenter.this.repositoryUpdatedEvent.fire((Object)new RepositoryUpdatedEvent(repository, updatedRepository));
            }
        })).updateRepository(repository, config);
    }

    public void removeRepository(Repository repository) {
        if (this.view.confirmDeleteRepository(repository)) {
            ((RepositoryService)this.repositoryService.call()).removeRepository(repository.getAlias());
        }
    }

    public void newRepository(final @Observes NewRepositoryEvent event) {
        ((VFSService)this.vfsService.call((RemoteCallback)new RemoteCallback<Map>(){

            public void callback(Map response) {
                RepositoriesPresenter.this.view.addRepository(event.getNewRepository());
            }
        })).readAttributes(event.getNewRepository().getRoot());
    }

    public void removeRootDirectory(@Observes RepositoryRemovedEvent event) {
        this.view.removeIfExists(event.getRepository());
    }

    public void onSystemRepositoryChanged(@Observes SystemRepositoryChangedEvent event) {
        this.loadContent();
    }

    public static interface View
    extends UberView<RepositoriesPresenter> {
        public void addRepository(Repository var1);

        public boolean confirmDeleteRepository(Repository var1);

        public void removeIfExists(Repository var1);

        public void clear();

        public void updateRepository(Repository var1, Repository var2);
    }
}

