/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.list;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.ListBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import org.guvnor.structure.client.editors.repository.list.RemoveRepositoryCmd;
import org.guvnor.structure.client.editors.repository.list.RepositoriesPresenter;
import org.guvnor.structure.client.editors.repository.list.UpdateRepositoryCmd;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.Repository;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;

public class RepositoriesViewItem
extends Composite {
    private static RepositoriesViewItemBinder uiBinder = (RepositoriesViewItemBinder)GWT.create(RepositoriesViewItemBinder.class);
    @UiField
    public InlineHTML ownerReference;
    @UiField
    public InlineHTML repoName;
    @UiField
    public InlineHTML repoDesc;
    @UiField
    public InlineHTML gitDaemonURI;
    @UiField
    public Button myGitCopyButton;
    @UiField
    public FlowPanel linksPanel;
    @UiField
    public ListBox branchesDropdown;
    private RemoveRepositoryCmd cmdRemoveRepository;
    private UpdateRepositoryCmd cmdUpdateRepository;

    public RepositoriesViewItem(String repositoryName, String owner, List<PublicURI> publicURIs, String description, String currentBranch, Collection<String> branches, RemoveRepositoryCmd cmdRemoveRepository, UpdateRepositoryCmd cmdUpdateRepository) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.cmdRemoveRepository = cmdRemoveRepository;
        this.cmdUpdateRepository = cmdUpdateRepository;
        if (owner != null && !owner.isEmpty()) {
            this.ownerReference.setText(owner + " / ");
        }
        this.repoName.setText(repositoryName);
        this.repoDesc.setText(description);
        int count = 0;
        if (publicURIs.size() > 0) {
            this.linksPanel.add((Widget)new InlineHTML(){
                {
                    this.setText(CoreConstants.INSTANCE.AvailableProtocols());
                    this.getElement().getStyle().setPaddingLeft(10.0, Style.Unit.PX);
                }
            });
        }
        for (final PublicURI publicURI : publicURIs) {
            if (count == 0) {
                this.gitDaemonURI.setText(publicURI.getURI());
            }
            String protocol = publicURI.getProtocol() == null ? "default" : publicURI.getProtocol();
            Anchor anchor = new Anchor(protocol);
            anchor.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoriesViewItem.this.gitDaemonURI.setText(publicURI.getURI());
                }
            });
            if (count != 0) {
                anchor.getElement().getStyle().setPaddingLeft(5.0, Style.Unit.PX);
            }
            this.linksPanel.add((Widget)anchor);
            ++count;
        }
        String uriId = "view-uri-for-" + repositoryName;
        this.gitDaemonURI.getElement().setId(uriId);
        this.myGitCopyButton.getElement().setAttribute("data-clipboard-target", uriId);
        this.myGitCopyButton.getElement().setAttribute("data-clipboard-text", this.gitDaemonURI.getText());
        this.myGitCopyButton.getElement().setId("view-button-" + uriId);
        int index = 0;
        for (String branch : branches) {
            this.branchesDropdown.addItem(branch, branch);
            if (currentBranch.equals(branch)) {
                this.branchesDropdown.setSelectedIndex(index);
            }
            ++index;
        }
        RepositoriesViewItem.glueCopy(this.myGitCopyButton.getElement());
    }

    @UiHandler(value={"btnRemoveRepository"})
    public void onClickButtonRemoveRepository(ClickEvent event) {
        if (this.cmdRemoveRepository != null) {
            this.cmdRemoveRepository.execute();
        }
    }

    @UiHandler(value={"btnChangeBranch"})
    public void onClickButtonUpdateRepository(ClickEvent event) {
        if (this.cmdUpdateRepository != null) {
            String branch = this.branchesDropdown.getValue(this.branchesDropdown.getSelectedIndex());
            this.cmdUpdateRepository.add("branch", branch);
            this.cmdUpdateRepository.execute();
        }
    }

    public void update(Repository repository, RepositoriesPresenter presenter) {
        this.cmdRemoveRepository = new RemoveRepositoryCmd(repository, presenter);
        this.cmdUpdateRepository = new UpdateRepositoryCmd(repository, presenter);
    }

    public static native void glueCopy(Element var0);

    static interface RepositoriesViewItemBinder
    extends UiBinder<Widget, RepositoriesViewItem> {
    }
}

