/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.guvnor.structure.client.editors.repository.list.RemoveRepositoryCmd;
import org.guvnor.structure.client.editors.repository.list.RepositoriesPresenter;
import org.guvnor.structure.client.editors.repository.list.RepositoriesViewItem;
import org.guvnor.structure.client.editors.repository.list.UpdateRepositoryCmd;
import org.guvnor.structure.repositories.Repository;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;

@Dependent
public class RepositoriesView
extends Composite
implements RequiresResize,
RepositoriesPresenter.View {
    private static RepositoriesEditorViewBinder uiBinder = (RepositoriesEditorViewBinder)GWT.create(RepositoriesEditorViewBinder.class);
    private RepositoriesPresenter presenter;
    @UiField
    public FlowPanel panel;
    private Map<Repository, Widget> repositoryToWidgetMap = new HashMap<Repository, Widget>();

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(RepositoriesPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void addRepository(Repository repository) {
        RepositoriesViewItem item = new RepositoriesViewItem(repository.getAlias(), null, repository.getPublicURIs(), CoreConstants.INSTANCE.Empty(), repository.getCurrentBranch(), repository.getBranches(), new RemoveRepositoryCmd(repository, this.presenter), new UpdateRepositoryCmd(repository, this.presenter));
        this.repositoryToWidgetMap.put(repository, (Widget)item);
        this.panel.add((Widget)item);
    }

    @Override
    public boolean confirmDeleteRepository(Repository repository) {
        return Window.confirm((String)CoreConstants.INSTANCE.ConfirmDeleteRepository0(repository.getAlias()));
    }

    @Override
    public void removeIfExists(Repository repository) {
        Widget w = this.repositoryToWidgetMap.remove(repository);
        if (w == null) {
            return;
        }
        this.panel.remove(w);
    }

    @Override
    public void clear() {
        this.repositoryToWidgetMap.clear();
        this.panel.clear();
    }

    public void onResize() {
        int height = this.getParent().getOffsetHeight();
        int width = this.getParent().getOffsetWidth();
        this.panel.setPixelSize(width, height);
    }

    @Override
    public void updateRepository(Repository old, Repository updated) {
        RepositoriesViewItem item = (RepositoriesViewItem)this.repositoryToWidgetMap.remove(old);
        if (item != null) {
            item.update(updated, this.presenter);
            this.repositoryToWidgetMap.put(updated, (Widget)item);
        }
    }

    static interface RepositoriesEditorViewBinder
    extends UiBinder<Widget, RepositoriesView> {
    }
}

