/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.list;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.List;
import org.guvnor.structure.client.editors.repository.common.CopyRepositoryUrlBtn;
import org.guvnor.structure.client.editors.repository.list.RemoveRepositoryCmd;
import org.guvnor.structure.client.editors.repository.list.RepositoriesPresenter;
import org.guvnor.structure.client.editors.repository.list.UpdateRepositoryCmd;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.Repository;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;

public class RepositoriesViewItem
extends Composite {
    private static RepositoriesViewItemBinder uiBinder = (RepositoriesViewItemBinder)GWT.create(RepositoriesViewItemBinder.class);
    @UiField
    public Heading repoName;
    @UiField
    public Paragraph repoDesc;
    @UiField
    public TextBox gitDaemonURI;
    @UiField
    public CopyRepositoryUrlBtn myGitCopyButton;
    @UiField
    public Paragraph linksPanel;
    @UiField
    public Select branchesDropdown;
    private RemoveRepositoryCmd cmdRemoveRepository;
    private UpdateRepositoryCmd cmdUpdateRepository;

    public RepositoriesViewItem(String repositoryName, String owner, List<PublicURI> publicURIs, String description, String currentBranch, Collection<String> branches, RemoveRepositoryCmd cmdRemoveRepository, UpdateRepositoryCmd cmdUpdateRepository) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.cmdRemoveRepository = cmdRemoveRepository;
        this.cmdUpdateRepository = cmdUpdateRepository;
        if (owner != null && !owner.isEmpty()) {
            this.repoName.setText(owner + " / " + repositoryName);
        } else {
            this.repoName.setText(repositoryName);
        }
        this.repoDesc.setText(description);
        int count = 0;
        if (publicURIs.size() > 0) {
            this.linksPanel.setText(CoreConstants.INSTANCE.AvailableProtocols());
        }
        for (final PublicURI publicURI : publicURIs) {
            if (count == 0) {
                this.gitDaemonURI.setText(publicURI.getURI());
            }
            String protocol = publicURI.getProtocol() == null ? "default" : publicURI.getProtocol();
            Button anchor = new Button(protocol);
            anchor.getElement().getStyle().setMarginLeft(5.0, Style.Unit.PX);
            anchor.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoriesViewItem.this.gitDaemonURI.setText(publicURI.getURI());
                }
            });
            if (count != 0) {
                anchor.getElement().getStyle().setPaddingLeft(5.0, Style.Unit.PX);
            }
            this.linksPanel.add((Widget)anchor);
            ++count;
        }
        String uriId = "view-uri-for-" + repositoryName;
        this.gitDaemonURI.getElement().setId(uriId);
        this.myGitCopyButton.init(true, uriId, this.gitDaemonURI.getText());
        for (String branch : branches) {
            Option option = new Option();
            option.setText(branch);
            option.setValue(branch);
            this.branchesDropdown.add((Widget)option);
            if (!currentBranch.equals(branch)) continue;
            this.branchesDropdown.setValue(option);
        }
        this.branchesDropdown.refresh();
        RepositoriesViewItem.glueCopy(this.myGitCopyButton.getElement());
    }

    @UiHandler(value={"btnRemoveRepository"})
    public void onClickButtonRemoveRepository(ClickEvent event) {
        if (this.cmdRemoveRepository != null) {
            this.cmdRemoveRepository.execute();
        }
    }

    @UiHandler(value={"btnChangeBranch"})
    public void onClickButtonUpdateRepository(ClickEvent event) {
        if (this.cmdUpdateRepository != null) {
            String branch = this.branchesDropdown.getValue();
            this.cmdUpdateRepository.add("branch", branch);
            this.cmdUpdateRepository.execute();
        }
    }

    public void update(Repository repository, RepositoriesPresenter presenter) {
        this.cmdRemoveRepository = new RemoveRepositoryCmd(repository, presenter);
        this.cmdUpdateRepository = new UpdateRepositoryCmd(repository, presenter);
    }

    public static native void glueCopy(Element var0);

    static interface RepositoriesViewItemBinder
    extends UiBinder<Widget, RepositoriesViewItem> {
    }
}

