/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextBranchChangeHandler;
import org.guvnor.structure.client.editors.context.GuvnorStructureContextChangeHandler;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.callbacks.Callback;

@ApplicationScoped
public class GuvnorStructureContext {
    private final HashMap<GuvnorStructureContextChangeHandler.HandlerRegistration, GuvnorStructureContextChangeHandler> handlers = new HashMap();
    private final HashMap<GuvnorStructureContextBranchChangeHandler.HandlerRegistration, GuvnorStructureContextBranchChangeHandler> branchChangeHandlers = new HashMap();
    private final HashMap<String, String> aliasBranch = new HashMap();
    private Caller<RepositoryService> repositoryService;

    public GuvnorStructureContext() {
    }

    @Inject
    public GuvnorStructureContext(Caller<RepositoryService> repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void getRepositories(final Callback<Collection<Repository>> callback) {
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<Collection<Repository>>(){

            public void callback(Collection<Repository> response) {
                Collection foundAliases = GuvnorStructureContext.this.updateRepositories(response);
                GuvnorStructureContext.this.removeMissingAliases(foundAliases);
                callback.callback(response);
            }
        })).getRepositories();
    }

    private Collection<String> updateRepositories(Collection<Repository> response) {
        ArrayList<String> foundAliases = new ArrayList<String>();
        for (Repository repository : response) {
            foundAliases.add(repository.getAlias());
            this.updateRepository(repository);
        }
        return foundAliases;
    }

    private void updateRepository(Repository repository) {
        if (this.isNewRepository(repository)) {
            this.aliasBranch.put(repository.getAlias(), repository.getDefaultBranch());
        } else {
            this.updateBranch(repository);
        }
    }

    private void updateBranch(Repository repository) {
        String branch = this.aliasBranch.get(repository.getAlias());
        if (branch == null || this.hasBranchBeenRemoved(repository, branch)) {
            this.aliasBranch.put(repository.getAlias(), repository.getDefaultBranch());
        }
    }

    private boolean isNewRepository(Repository repository) {
        return !this.aliasBranch.containsKey(repository.getAlias());
    }

    private boolean hasBranchBeenRemoved(Repository repository, String branch) {
        return !repository.getBranches().contains(branch);
    }

    private void removeMissingAliases(Collection<String> foundAliases) {
        for (String missingAlias : this.getMissingAliases(foundAliases)) {
            this.aliasBranch.remove(missingAlias);
        }
    }

    private Collection<String> getMissingAliases(Collection<String> foundAliases) {
        ArrayList<String> missingAliases = new ArrayList<String>();
        for (String alias : this.aliasBranch.keySet()) {
            if (foundAliases.contains(alias)) continue;
            missingAliases.add(alias);
        }
        return missingAliases;
    }

    public GuvnorStructureContextChangeHandler.HandlerRegistration addGuvnorStructureContextChangeHandler(GuvnorStructureContextChangeHandler handler) {
        GuvnorStructureContextChangeHandler.HandlerRegistration handlerRegistration = new GuvnorStructureContextChangeHandler.HandlerRegistration();
        this.handlers.put(handlerRegistration, handler);
        return handlerRegistration;
    }

    public GuvnorStructureContextBranchChangeHandler.HandlerRegistration addGuvnorStructureContextBranchChangeHandler(GuvnorStructureContextBranchChangeHandler handler) {
        GuvnorStructureContextBranchChangeHandler.HandlerRegistration handlerRegistration = new GuvnorStructureContextBranchChangeHandler.HandlerRegistration();
        this.branchChangeHandlers.put(handlerRegistration, handler);
        return handlerRegistration;
    }

    public void changeBranch(String alias, String branch) {
        this.aliasBranch.put(alias, branch);
        for (GuvnorStructureContextBranchChangeHandler handler : this.branchChangeHandlers.values()) {
            handler.onBranchChange(alias, branch);
        }
    }

    public void onNewRepository(@Observes NewRepositoryEvent event) {
        Repository newRepository = event.getNewRepository();
        this.aliasBranch.put(newRepository.getAlias(), newRepository.getDefaultBranch());
        for (GuvnorStructureContextChangeHandler handler : this.handlers.values()) {
            handler.onNewRepositoryAdded(newRepository);
        }
    }

    public void onRepositoryRemoved(@Observes RepositoryRemovedEvent event) {
        this.aliasBranch.remove(event.getRepository().getAlias());
        for (GuvnorStructureContextChangeHandler handler : this.handlers.values()) {
            handler.onRepositoryDeleted(event.getRepository());
        }
    }

    public void removeHandler(GuvnorStructureContextChangeHandler.HandlerRegistration handlerRegistration) {
        this.handlers.remove(handlerRegistration);
    }

    public void removeHandler(GuvnorStructureContextBranchChangeHandler.HandlerRegistration handlerRegistration) {
        this.branchChangeHandlers.remove(handlerRegistration);
    }

    public String getCurrentBranch(String alias) {
        return this.aliasBranch.get(alias);
    }
}

