/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.fileexplorer;

import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerItem;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerPresenter;
import org.guvnor.structure.client.editors.fileexplorer.FileExplorerView;
import org.guvnor.structure.repositories.Repository;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.widgets.core.client.tree.Tree;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

public class FileExplorerViewImpl
extends Composite
implements FileExplorerView {
    TreeItem rootTreeItem = null;
    private final Tree tree = new Tree();
    private final Map<Repository, TreeItem> repositoryToTreeItemMap = new HashMap<Repository, TreeItem>();
    private static final String REPOSITORY_ID = "repositories";
    private static final String LAZY_LOAD = "Loading...";
    private FileExplorerPresenter presenter = null;

    @Override
    public void init(final FileExplorerPresenter presenter) {
        this.presenter = presenter;
        this.rootTreeItem = this.tree.addItem(TreeItem.Type.FOLDER, "Repositories");
        this.rootTreeItem.setState(TreeItem.State.OPEN);
        this.initWidget((Widget)this.tree);
        this.tree.addOpenHandler((OpenHandler)new OpenHandler<TreeItem>(){

            public void onOpen(OpenEvent<TreeItem> event) {
                if (FileExplorerViewImpl.this.needsLoading((TreeItem)event.getTarget()) && ((TreeItem)event.getTarget()).getUserObject() instanceof Path) {
                    presenter.loadDirectoryContent(new FileExplorerItem((TreeItem)event.getTarget()), (Path)((TreeItem)event.getTarget()).getUserObject());
                }
            }
        });
        this.tree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                Object userObject = ((TreeItem)event.getSelectedItem()).getUserObject();
                if (userObject != null && userObject instanceof Path) {
                    Path path = (Path)userObject;
                    presenter.redirect(path);
                } else if (userObject != null && userObject instanceof Repository) {
                    Repository root = (Repository)userObject;
                    presenter.redirect(root);
                } else if (((TreeItem)event.getSelectedItem()).getUserObject() instanceof String && ((TreeItem)event.getSelectedItem()).getUserObject().equals(FileExplorerViewImpl.REPOSITORY_ID)) {
                    presenter.redirectRepositoryList();
                }
            }
        });
    }

    @Override
    public void reset() {
        this.rootTreeItem.setUserObject((Object)REPOSITORY_ID);
        this.rootTreeItem.addItem(TreeItem.Type.LOADING, LAZY_LOAD);
        this.rootTreeItem.removeItems();
        this.repositoryToTreeItemMap.clear();
    }

    @Override
    public void removeRepository(Repository repo) {
        if (!this.repositoryToTreeItemMap.containsKey(repo)) {
            return;
        }
        TreeItem repositoryRootItem = this.repositoryToTreeItemMap.remove(repo);
        repositoryRootItem.remove();
    }

    @Override
    public void addNewRepository(Repository repository, String branch) {
        TreeItem repositoryRootItem = this.rootTreeItem.addItem(TreeItem.Type.FOLDER, repository.getAlias());
        repositoryRootItem.setUserObject((Object)repository);
        repositoryRootItem.setState(TreeItem.State.OPEN, false, false);
        this.repositoryToTreeItemMap.put(repository, repositoryRootItem);
        this.presenter.loadDirectoryContent(new FileExplorerItem(repositoryRootItem), repository.getBranchRoot(branch));
    }

    private boolean needsLoading(TreeItem item) {
        return item.getChildCount() == 1 && LAZY_LOAD.equals(item.getChild(0).getText());
    }
}

