/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.list;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.structure.client.editors.context.GuvnorStructureContext;
import org.guvnor.structure.client.editors.repository.list.HasRemoveRepositoryHandlers;
import org.guvnor.structure.client.editors.repository.list.RepositoryItemView;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.Repository;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;

@Dependent
public class RepositoryItemPresenter
implements IsWidget {
    private Repository repository;
    private RepositoryItemView view;
    private GuvnorStructureContext guvnorStructureContext;
    private HasRemoveRepositoryHandlers removeRepositoryHandler;

    public RepositoryItemPresenter() {
    }

    @Inject
    public RepositoryItemPresenter(RepositoryItemView repositoryItemView, GuvnorStructureContext guvnorStructureContext) {
        this.view = repositoryItemView;
        this.guvnorStructureContext = guvnorStructureContext;
    }

    public void setRepository(Repository repository, String branch) {
        this.repository = repository;
        this.view.setPresenter(this);
        this.view.setRepositoryName(repository.getAlias());
        this.view.setRepositoryDescription(CoreConstants.INSTANCE.Empty());
        if (repository.getPublicURIs().size() > 0) {
            this.view.showAvailableProtocols();
        }
        this.setPublicURIs();
        this.view.setUriId("view-uri-for-" + repository.getAlias());
        this.populateBranches(branch);
        this.view.refresh();
    }

    private void setPublicURIs() {
        int count = 0;
        for (PublicURI publicURI : this.repository.getPublicURIs()) {
            if (count == 0) {
                this.view.setDaemonURI(publicURI.getURI());
            }
            String protocol = this.getProtocol(publicURI);
            this.view.addProtocol(protocol);
            ++count;
        }
    }

    private void populateBranches(String currentBranch) {
        ArrayList branches = new ArrayList(this.repository.getBranches());
        Collections.reverse(branches);
        for (String branch : branches) {
            this.view.addBranch(branch);
        }
        this.view.setSelectedBranch(currentBranch);
    }

    public void onAnchorSelected(String protocol) {
        for (PublicURI publicURI : this.repository.getPublicURIs()) {
            if (!protocol.equals(this.getProtocol(publicURI))) continue;
            this.view.setDaemonURI(publicURI.getURI());
            break;
        }
    }

    private String getProtocol(PublicURI publicURI) {
        return publicURI.getProtocol() == null ? "default" : publicURI.getProtocol();
    }

    public void onClickButtonRemoveRepository() {
        if (this.removeRepositoryHandler != null) {
            this.removeRepositoryHandler.removeRepository(this.repository);
        }
    }

    public void onUpdateRepository(String branch) {
        this.guvnorStructureContext.changeBranch(this.repository.getAlias(), branch);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public void addRemoveRepositoryCommand(HasRemoveRepositoryHandlers removeRepositoryHandlers) {
        this.removeRepositoryHandler = removeRepositoryHandlers;
    }
}

