/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.clone;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.guvnor.structure.client.editors.repository.clone.CloneRepositoryView;
import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.extras.select.client.ui.Option;
import org.gwtbootstrap3.extras.select.client.ui.Select;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.errors.ErrorPopup;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;

@Dependent
public class CloneRepositoryViewImpl
extends BaseModal
implements CloneRepositoryView,
HasCloseHandlers<CloneRepositoryViewImpl> {
    private CloneRepositoryView.Presenter presenter;
    private static CloneRepositoryFormBinder uiBinder = (CloneRepositoryFormBinder)GWT.create(CloneRepositoryFormBinder.class);
    @UiField
    Button clone;
    @UiField
    Button cancel;
    @UiField
    FormGroup organizationalUnitGroup;
    @UiField
    Select organizationalUnitDropdown;
    @UiField
    HelpBlock organizationalUnitHelpInline;
    @UiField
    FormGroup nameGroup;
    @UiField
    TextBox nameTextBox;
    @UiField
    HelpBlock nameHelpInline;
    @UiField
    FormGroup urlGroup;
    @UiField
    TextBox gitURLTextBox;
    @UiField
    HelpBlock urlHelpInline;
    @UiField
    TextBox usernameTextBox;
    @UiField
    Input passwordTextBox;
    @UiField
    FormLabel ouLabel;
    @UiField
    BaseModal popup;
    @UiField
    FormGroup managedReposiotryGroup;
    @UiField
    CheckBox managedRepository;

    @UiHandler(value={"clone"})
    public void onCloneClick(ClickEvent e) {
        this.presenter.handleCloneClick();
    }

    @UiHandler(value={"cancel"})
    public void onCancelClick(ClickEvent e) {
        this.presenter.handleCancelClick();
    }

    @Override
    public void init(CloneRepositoryView.Presenter presenter, boolean isOuMandatory) {
        this.presenter = presenter;
        this.setBody((Widget)uiBinder.createAndBindUi(this));
        this.setTitle(CoreConstants.INSTANCE.CloneRepository());
        this.ouLabel.setShowRequiredIndicator(isOuMandatory);
        this.nameTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                CloneRepositoryViewImpl.this.nameGroup.setValidationState(ValidationState.NONE);
                CloneRepositoryViewImpl.this.nameHelpInline.setText("");
            }
        });
        this.organizationalUnitDropdown.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                CloneRepositoryViewImpl.this.organizationalUnitGroup.setValidationState(ValidationState.NONE);
                CloneRepositoryViewImpl.this.organizationalUnitHelpInline.setText("");
            }
        });
        this.gitURLTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                CloneRepositoryViewImpl.this.urlGroup.setValidationState(ValidationState.NONE);
                CloneRepositoryViewImpl.this.urlHelpInline.setText("");
            }
        });
    }

    @Override
    public void addOrganizationalUnitSelectEntry() {
        Option option = new Option();
        option.setText(CoreConstants.INSTANCE.SelectEntry());
        this.organizationalUnitDropdown.add((Widget)option);
        this.organizationalUnitDropdown.refresh();
    }

    @Override
    public void addOrganizationalUnit(OrganizationalUnit ou) {
        String text = ou.getName();
        String value = ou.getName();
        Option option = new Option();
        option.setText(text);
        option.setValue(value);
        this.organizationalUnitDropdown.add((Widget)option);
        this.organizationalUnitDropdown.refresh();
    }

    @Override
    public void deleteOrganizationalUnit(OrganizationalUnit ou) {
        Option optToDelete = null;
        for (int i = 0; i < this.organizationalUnitDropdown.getWidgetCount(); ++i) {
            Option o;
            Widget w = this.organizationalUnitDropdown.getWidget(i);
            if (!(w instanceof Option) || !(o = (Option)w).getText().equals(ou.getName())) continue;
            optToDelete = o;
            break;
        }
        if (optToDelete != null) {
            this.organizationalUnitDropdown.remove(optToDelete);
            this.organizationalUnitDropdown.refresh();
        }
    }

    @Override
    public String getSelectedOrganizationalUnit() {
        return this.organizationalUnitDropdown.getValue();
    }

    @Override
    public boolean isGitUrlEmpty() {
        return this.gitURLTextBox.getText() == null || this.gitURLTextBox.getText().trim().isEmpty();
    }

    @Override
    public boolean isNameEmpty() {
        return this.nameTextBox.getText() == null || this.nameTextBox.getText().trim().isEmpty();
    }

    @Override
    public String getGitUrl() {
        return this.gitURLTextBox.getText().trim();
    }

    @Override
    public String getUsername() {
        return this.usernameTextBox.getText();
    }

    @Override
    public String getPassword() {
        return this.passwordTextBox.getText();
    }

    @Override
    public String getName() {
        return this.nameTextBox.getText();
    }

    @Override
    public void setName(String name) {
        this.nameTextBox.setText(name);
    }

    @Override
    public void showUrlHelpMandatoryMessage() {
        this.urlHelpInline.setText(CoreConstants.INSTANCE.URLMandatory());
    }

    @Override
    public void showUrlHelpInvalidFormatMessage() {
        this.urlHelpInline.setText(CoreConstants.INSTANCE.InvalidUrlFormat());
    }

    @Override
    public void setUrlGroupType(ValidationState state) {
        this.urlGroup.setValidationState(state);
    }

    @Override
    public void showNameHelpMandatoryMessage() {
        this.nameHelpInline.setText(CoreConstants.INSTANCE.RepositoryNaneMandatory());
    }

    @Override
    public void setNameGroupType(ValidationState state) {
        this.nameGroup.setValidationState(state);
    }

    @Override
    public void showOrganizationalUnitHelpMandatoryMessage() {
        this.organizationalUnitHelpInline.setText(CoreConstants.INSTANCE.OrganizationalUnitMandatory());
    }

    @Override
    public void setOrganizationalUnitGroupType(ValidationState state) {
        this.organizationalUnitGroup.setValidationState(state);
    }

    @Override
    public void setNameEnabled(boolean enabled) {
        this.nameTextBox.setEnabled(enabled);
    }

    @Override
    public void setOrganizationalUnitEnabled(boolean enabled) {
        this.organizationalUnitDropdown.setEnabled(enabled);
        this.organizationalUnitDropdown.refresh();
    }

    @Override
    public void setGitUrlEnabled(boolean enabled) {
        this.gitURLTextBox.setEnabled(enabled);
    }

    @Override
    public void setUsernameEnabled(boolean enabled) {
        this.usernameTextBox.setEnabled(enabled);
    }

    @Override
    public void setPasswordEnabled(boolean enabled) {
        this.passwordTextBox.setEnabled(enabled);
    }

    @Override
    public void setCloneEnabled(boolean enabled) {
        this.clone.setEnabled(enabled);
    }

    @Override
    public void setCancelEnabled(boolean enabled) {
        this.cancel.setEnabled(enabled);
    }

    @Override
    public void setPopupCloseVisible(boolean closeVisible) {
        this.setClosable(closeVisible);
    }

    @Override
    public void showBusyPopupMessage() {
        BusyPopup.showMessage((String)CoreConstants.INSTANCE.Cloning());
    }

    @Override
    public void closeBusyPopup() {
        BusyPopup.close();
    }

    @Override
    public boolean showAgreeNormalizeNameWindow(String normalizedName) {
        return Window.confirm((String)(CoreConstants.INSTANCE.RepositoryNameInvalid() + " \"" + normalizedName + "\". " + CoreConstants.INSTANCE.DoYouAgree()));
    }

    @Override
    public void alertRepositoryCloned() {
        Window.alert((String)(CoreConstants.INSTANCE.RepoCloneSuccess() + "\n\n" + CommonConstants.INSTANCE.IndexClonedRepositoryWarning()));
    }

    @Override
    public void errorRepositoryAlreadyExist() {
        ErrorPopup.showMessage((String)CoreConstants.INSTANCE.RepoAlreadyExists());
    }

    @Override
    public void errorCloneRepositoryFail(Throwable cause) {
        ErrorPopup.showMessage((String)(CoreConstants.INSTANCE.RepoCloneFail() + " \n" + cause.getMessage()));
    }

    @Override
    public void errorLoadOrganizationalUnitsFail(Throwable cause) {
        ErrorPopup.showMessage((String)(CoreConstants.INSTANCE.CantLoadOrganizationalUnits() + " \n" + cause.getMessage()));
    }

    public HandlerRegistration addCloseHandler(CloseHandler<CloneRepositoryViewImpl> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    @Override
    public void reset() {
        this.nameTextBox.setText("");
        this.nameGroup.setValidationState(ValidationState.NONE);
        this.nameHelpInline.setText("");
        this.organizationalUnitDropdown.deselectAll();
        this.organizationalUnitDropdown.refresh();
        this.organizationalUnitGroup.setValidationState(ValidationState.NONE);
        this.organizationalUnitHelpInline.setText("");
        this.gitURLTextBox.setText("");
        this.urlGroup.setValidationState(ValidationState.NONE);
        this.urlHelpInline.setText("");
        this.usernameTextBox.setText("");
        this.passwordTextBox.setText("");
        this.managedRepository.setValue(Boolean.FALSE);
    }

    @Override
    public boolean isManagedRepository() {
        return this.managedRepository.getValue();
    }

    @Override
    public void enableManagedRepoCreation(boolean enabled) {
        this.managedReposiotryGroup.setVisible(enabled);
    }

    @Override
    public void show() {
        this.popup.show();
    }

    @Override
    public void hide() {
        this.popup.hide();
        CloseEvent.fire((HasCloseHandlers)this, (Object)this);
    }

    static interface CloneRepositoryFormBinder
    extends UiBinder<Widget, CloneRepositoryViewImpl> {
    }
}

