/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.edit;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.annotation.PostConstruct;
import org.guvnor.structure.client.editors.repository.common.CopyRepositoryUrlBtn;
import org.guvnor.structure.client.editors.repository.edit.RepositoryEditorPresenter;
import org.guvnor.structure.client.navigator.CommitNavigatorEntry;
import org.guvnor.structure.repositories.PublicURI;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.html.Paragraph;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.mvp.ParameterizedCommand;

public class RepositoryEditorView
extends Composite
implements RepositoryEditorPresenter.View {
    private static RepositoryEditorViewBinder uiBinder = (RepositoryEditorViewBinder)GWT.create(RepositoryEditorViewBinder.class);
    @UiField
    public Heading repoName;
    @UiField
    public Paragraph repoDesc;
    @UiField
    public TextBox gitDaemonURI;
    @UiField
    public CopyRepositoryUrlBtn myGitCopyButton;
    @UiField
    public Paragraph linksPanel;
    @UiField
    public FlowPanel history;
    @UiField
    public Button loadMore;
    private RepositoryEditorPresenter presenter;

    @PostConstruct
    public void init() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    public void init(RepositoryEditorPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setRepositoryInfo(String repositoryName, String owner, List<PublicURI> publicURIs, String description, List<VersionRecord> initialVersionList) {
        if (owner != null && !owner.isEmpty()) {
            this.repoName.setText(owner + " / " + repositoryName);
        } else {
            this.repoName.setText(repositoryName);
        }
        this.repoDesc.setText(description);
        int count = 0;
        if (publicURIs.size() > 0) {
            this.linksPanel.setText(CoreConstants.INSTANCE.AvailableProtocols());
        }
        for (final PublicURI publicURI : publicURIs) {
            if (count == 0) {
                this.gitDaemonURI.setText(publicURI.getURI());
            }
            String protocol = publicURI.getProtocol() == null ? "default" : publicURI.getProtocol();
            Button anchor = new Button(protocol);
            anchor.getElement().getStyle().setMarginLeft(5.0, Style.Unit.PX);
            anchor.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoryEditorView.this.gitDaemonURI.setText(publicURI.getURI());
                }
            });
            if (count != 0) {
                anchor.getElement().getStyle().setPaddingLeft(5.0, Style.Unit.PX);
            }
            this.linksPanel.add((Widget)anchor);
            ++count;
        }
        if (initialVersionList != null && !initialVersionList.isEmpty()) {
            this.loadContent(initialVersionList);
        } else {
            this.history.setVisible(false);
        }
        this.loadMore.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RepositoryEditorView.this.presenter.onLoadMoreHistory(RepositoryEditorView.this.history.getWidgetCount());
            }
        });
        String uriId = "uri-for-" + repositoryName;
        this.gitDaemonURI.getElement().setId(uriId);
        this.myGitCopyButton.init(false, uriId, this.gitDaemonURI.getText());
        RepositoryEditorView.glueCopy(this.myGitCopyButton.getElement());
    }

    @Override
    public void reloadHistory(List<VersionRecord> versionList) {
        this.loadContent(versionList);
        BusyPopup.close();
    }

    @Override
    public void addHistory(List<VersionRecord> versionList) {
        if (!versionList.isEmpty()) {
            this.loadContent(versionList);
        } else {
            this.loadMore.setEnabled(false);
        }
    }

    private void loadContent(List<VersionRecord> versionRecordList) {
        for (VersionRecord vr : versionRecordList) {
            this.history.add((Widget)new CommitNavigatorEntry(vr, new ParameterizedCommand<VersionRecord>(){

                public void execute(VersionRecord record) {
                    BusyPopup.showMessage((String)CoreConstants.INSTANCE.Reverting());
                    RepositoryEditorView.this.presenter.onRevert(record);
                }
            }));
        }
    }

    public static native void glueCopy(Element var0);

    static interface RepositoryEditorViewBinder
    extends UiBinder<Widget, RepositoryEditorView> {
    }
}

