/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.edit;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.structure.client.security.RepositoryController;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryServiceEditor;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;

@Dependent
@WorkbenchScreen(identifier="RepositoryEditor")
public class RepositoryEditorPresenter {
    private View view;
    private Caller<RepositoryService> repositoryService;
    private Caller<RepositoryServiceEditor> repositoryServiceEditor;
    private PlaceManager placeManager;
    private RepositoryController repositoryController;
    private String alias = null;
    private Path root = null;
    private PlaceRequest place;

    public RepositoryEditorPresenter() {
    }

    @Inject
    public RepositoryEditorPresenter(View view, Caller<RepositoryService> repositoryService, Caller<RepositoryServiceEditor> repositoryServiceEditor, PlaceManager placeManager, RepositoryController repositoryController) {
        this.view = view;
        this.repositoryService = repositoryService;
        this.repositoryServiceEditor = repositoryServiceEditor;
        this.placeManager = placeManager;
        this.repositoryController = repositoryController;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
        this.alias = (String)place.getParameters().get("alias");
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<RepositoryInfo>(){

            public void callback(RepositoryInfo repo) {
                RepositoryEditorPresenter.this.root = repo.getRoot();
                RepositoryEditorPresenter.this.view.setRepositoryInfo(repo.getAlias(), repo.getOwner(), !RepositoryEditorPresenter.this.repositoryController.canUpdateRepository(repo.getId()), repo.getPublicURIs(), CoreConstants.INSTANCE.Empty(), repo.getInitialVersionList());
            }
        })).getRepositoryInfo(this.alias);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return CoreConstants.INSTANCE.RepositoryEditor() + " [" + this.alias + "]";
    }

    @WorkbenchPartView
    public UberView<RepositoryEditorPresenter> getView() {
        return this.view;
    }

    void onLoadMoreHistory(int lastIndex) {
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<List<VersionRecord>>(){

            public void callback(List<VersionRecord> versionList) {
                RepositoryEditorPresenter.this.view.addHistory(versionList);
            }
        })).getRepositoryHistory(this.alias, lastIndex);
    }

    void onRevert(VersionRecord record) {
        this.onRevert(record, null);
    }

    void onRevert(VersionRecord record, String comment) {
        ((RepositoryServiceEditor)this.repositoryServiceEditor.call((RemoteCallback)new RemoteCallback<List<VersionRecord>>(){

            public void callback(List<VersionRecord> content) {
                RepositoryEditorPresenter.this.view.reloadHistory(content);
            }
        })).revertHistory(this.alias, this.root, comment, record);
    }

    public void onRepositoryRemovedEvent(@Observes RepositoryRemovedEvent event) {
        if (this.alias.equals(event.getRepository().getAlias())) {
            this.placeManager.closePlace(this.place);
        }
    }

    public static interface View
    extends UberView<RepositoryEditorPresenter> {
        public void setRepositoryInfo(String var1, String var2, boolean var3, List<PublicURI> var4, String var5, List<VersionRecord> var6);

        public void reloadHistory(List<VersionRecord> var1);

        public void addHistory(List<VersionRecord> var1);
    }
}

