/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitSearchService;
import org.guvnor.structure.security.OrganizationalUnitAction;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;

@ApplicationScoped
public class OrganizationalUnitTreeProvider
implements PermissionTreeProvider {
    private CommonConstants i18n = CommonConstants.INSTANCE;
    private PermissionManager permissionManager;
    private int rootNodePosition = 0;
    private Caller<OrganizationalUnitSearchService> searchService;

    public OrganizationalUnitTreeProvider() {
    }

    @Inject
    public OrganizationalUnitTreeProvider(PermissionManager permissionManager, Caller<OrganizationalUnitSearchService> searchService) {
        this.permissionManager = permissionManager;
        this.searchService = searchService;
    }

    public int getRootNodePosition() {
        return this.rootNodePosition;
    }

    public void setRootNodePosition(int rootNodePosition) {
        this.rootNodePosition = rootNodePosition;
    }

    public PermissionNode buildRootNode() {
        PermissionResourceNode rootNode = new PermissionResourceNode(this.i18n.OrganizationalUnitResource(), (PermissionTreeProvider)this);
        rootNode.setNodeName(this.i18n.OrganizationalUnitsNode());
        rootNode.setPositionInTree(this.rootNodePosition);
        rootNode.addPermission(this.newPermission(OrganizationalUnitAction.READ), this.i18n.OrganizationalUnitActionRead());
        rootNode.addPermission(this.newPermission((ResourceAction)OrganizationalUnitAction.UPDATE), this.i18n.OrganizationalUnitActionUpdate());
        rootNode.addPermission(this.newPermission((ResourceAction)OrganizationalUnitAction.DELETE), this.i18n.OrganizationalUnitActionDelete());
        rootNode.addPermission(this.newPermission((ResourceAction)OrganizationalUnitAction.CREATE), this.i18n.OrganizationalUnitActionCreate());
        return rootNode;
    }

    private Permission newPermission(ResourceAction action) {
        return this.permissionManager.createPermission((ResourceType)OrganizationalUnit.RESOURCE_TYPE, action, true);
    }

    private Permission newPermission(Resource resource, ResourceAction action) {
        return this.permissionManager.createPermission(resource, action, true);
    }

    public void loadChildren(PermissionNode parent, LoadOptions options, LoadCallback callback) {
        Collection resourceIds = options.getResourceIds();
        int maxNodes = options.getMaxNodes();
        if (this.searchService != null) {
            if (resourceIds != null) {
                ((OrganizationalUnitSearchService)this.searchService.call(orgUnits -> {
                    List<PermissionNode> children = this.buildPermissionNodes((Collection<OrganizationalUnit>)orgUnits);
                    callback.afterLoad(children);
                })).searchById(resourceIds);
            } else {
                String namePattern = options.getNodeNamePattern();
                ((OrganizationalUnitSearchService)this.searchService.call(orgUnits -> {
                    List<PermissionNode> children = this.buildPermissionNodes((Collection<OrganizationalUnit>)orgUnits);
                    callback.afterLoad(children);
                })).searchByName(namePattern, maxNodes, false);
            }
        } else {
            callback.afterLoad(Collections.emptyList());
        }
    }

    private List<PermissionNode> buildPermissionNodes(Collection<OrganizationalUnit> orgUnits) {
        ArrayList<PermissionNode> nodes = new ArrayList<PermissionNode>();
        for (OrganizationalUnit ou : orgUnits) {
            nodes.add(this.toPermissionNode(ou));
        }
        return nodes;
    }

    private PermissionNode toPermissionNode(OrganizationalUnit ou) {
        PermissionLeafNode node = new PermissionLeafNode();
        node.setNodeName(ou.getName());
        node.addPermission(this.newPermission((Resource)ou, OrganizationalUnitAction.READ), this.i18n.OrganizationalUnitActionRead());
        node.addPermission(this.newPermission((Resource)ou, (ResourceAction)OrganizationalUnitAction.UPDATE), this.i18n.OrganizationalUnitActionUpdate());
        node.addPermission(this.newPermission((Resource)ou, (ResourceAction)OrganizationalUnitAction.DELETE), this.i18n.OrganizationalUnitActionDelete());
        return node;
    }
}

