/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositorySearchService;
import org.guvnor.structure.security.RepositoryAction;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.Permission;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.client.authz.tree.LoadCallback;
import org.uberfire.security.client.authz.tree.LoadOptions;
import org.uberfire.security.client.authz.tree.PermissionNode;
import org.uberfire.security.client.authz.tree.PermissionTreeProvider;
import org.uberfire.security.client.authz.tree.impl.PermissionLeafNode;
import org.uberfire.security.client.authz.tree.impl.PermissionResourceNode;

@ApplicationScoped
public class RepositoryTreeProvider
implements PermissionTreeProvider {
    private PermissionManager permissionManager;
    private Caller<RepositorySearchService> searchService;
    private int rootNodePosition = 0;
    private CommonConstants i18n = CommonConstants.INSTANCE;

    public RepositoryTreeProvider() {
    }

    @Inject
    public RepositoryTreeProvider(PermissionManager permissionManager, Caller<RepositorySearchService> searchService) {
        this.permissionManager = permissionManager;
        this.searchService = searchService;
    }

    public int getRootNodePosition() {
        return this.rootNodePosition;
    }

    public void setRootNodePosition(int rootNodePosition) {
        this.rootNodePosition = rootNodePosition;
    }

    public PermissionNode buildRootNode() {
        PermissionResourceNode rootNode = new PermissionResourceNode(this.i18n.RepositoryResource(), (PermissionTreeProvider)this);
        rootNode.setNodeName(this.i18n.RepositoriesNode());
        rootNode.setNodeFullName(this.i18n.RepositoriesHelp());
        rootNode.setPositionInTree(this.rootNodePosition);
        Permission readPermission = this.newPermission(RepositoryAction.READ);
        Permission updatePermission = this.newPermission((ResourceAction)RepositoryAction.UPDATE);
        Permission deletePermission = this.newPermission((ResourceAction)RepositoryAction.DELETE);
        Permission createPermission = this.newPermission((ResourceAction)RepositoryAction.CREATE);
        rootNode.addPermission(readPermission, this.i18n.RepositoryActionRead());
        rootNode.addPermission(updatePermission, this.i18n.RepositoryActionUpdate());
        rootNode.addPermission(deletePermission, this.i18n.RepositoryActionDelete());
        rootNode.addPermission(createPermission, this.i18n.RepositoryActionCreate());
        rootNode.addDependencies(readPermission, new Permission[]{updatePermission, deletePermission});
        return rootNode;
    }

    private Permission newPermission(ResourceAction action) {
        return this.permissionManager.createPermission((ResourceType)Repository.RESOURCE_TYPE, action, true);
    }

    private Permission newPermission(Resource resource, ResourceAction action) {
        return this.permissionManager.createPermission(resource, action, true);
    }

    public void loadChildren(PermissionNode parent, LoadOptions options, LoadCallback callback) {
        Collection resourceIds = options.getResourceIds();
        int maxNodes = options.getMaxNodes();
        if (this.searchService != null) {
            if (resourceIds != null) {
                ((RepositorySearchService)this.searchService.call(repositories -> {
                    List<PermissionNode> children = this.buildPermissionNodes((Collection<Repository>)repositories);
                    callback.afterLoad(children);
                })).searchById(resourceIds);
            } else {
                String pattern = options.getNodeNamePattern();
                ((RepositorySearchService)this.searchService.call(repositories -> {
                    List<PermissionNode> children = this.buildPermissionNodes((Collection<Repository>)repositories);
                    callback.afterLoad(children);
                })).searchByAlias(pattern, maxNodes, false);
            }
        } else {
            callback.afterLoad(Collections.emptyList());
        }
    }

    private List<PermissionNode> buildPermissionNodes(Collection<Repository> repositories) {
        ArrayList<PermissionNode> nodes = new ArrayList<PermissionNode>();
        for (Repository p : repositories) {
            nodes.add(this.toPermissionNode(p));
        }
        return nodes;
    }

    private PermissionNode toPermissionNode(Repository r) {
        PermissionLeafNode node = new PermissionLeafNode();
        node.setNodeName(r.getAlias());
        Permission readPermission = this.newPermission((Resource)r, RepositoryAction.READ);
        Permission updatePermission = this.newPermission((Resource)r, (ResourceAction)RepositoryAction.UPDATE);
        Permission deletePermission = this.newPermission((Resource)r, (ResourceAction)RepositoryAction.DELETE);
        node.addPermission(readPermission, this.i18n.RepositoryActionRead());
        node.addPermission(updatePermission, this.i18n.RepositoryActionUpdate());
        node.addPermission(deletePermission, this.i18n.RepositoryActionDelete());
        node.addDependencies(readPermission, new Permission[]{updatePermission, deletePermission});
        return node;
    }
}

