/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.fileexplorer;

import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.core.client.tree.FSTreeItem;

class FileExplorerItem {
    private CommonConstants constants = CommonConstants.INSTANCE;
    private final FSTreeItem parent;

    FileExplorerItem(FSTreeItem treeItem) {
        this.parent = (FSTreeItem)PortablePreconditions.checkNotNull((String)"parent", (Object)treeItem);
    }

    public void addDirectory(Path child) {
        this.checkCleanupLoading();
        FSTreeItem newDirectory = this.parent.addItem(FSTreeItem.FSType.FOLDER, child.getFileName());
        newDirectory.addItem(FSTreeItem.FSType.LOADING, this.constants.Loading());
        newDirectory.setUserObject((Object)child);
    }

    public void addFile(Path child) {
        this.checkCleanupLoading();
        FSTreeItem newFile = this.parent.addItem(FSTreeItem.FSType.ITEM, child.getFileName());
        newFile.setUserObject((Object)child);
    }

    private void checkCleanupLoading() {
        if (this.parent.getChild(0) != null && ((FSTreeItem)this.parent.getChild(0)).getUserObject() == null) {
            ((FSTreeItem)this.parent.getChild(0)).remove();
        }
    }
}

