/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex;

import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.flex.FlexOperations;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.JavaPackage;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.ProjectMetadata;
import org.springframework.roo.project.ProjectOperations;
import org.springframework.roo.shell.CliAvailabilityIndicator;
import org.springframework.roo.shell.CliCommand;
import org.springframework.roo.shell.CliOption;
import org.springframework.roo.shell.CommandMarker;
import org.springframework.roo.support.logging.HandlerUtils;

@Component
@Service
public class FlexCommands
implements CommandMarker {
    private static Logger logger = HandlerUtils.getLogger(FlexCommands.class);
    @Reference
    private FlexOperations operations;
    @Reference
    private MetadataService metadataService;
    @Reference
    private ProjectOperations projectOperations;

    @CliAvailabilityIndicator(value={"flex setup"})
    public boolean isFlexAvailable() {
        return this.operations.isFlexAvailable();
    }

    @CliAvailabilityIndicator(value={"flex remoting scaffold", "flex remoting all"})
    public boolean isFlexConfigured() {
        return this.operations.isFlexConfigured();
    }

    @CliCommand(value={"flex setup"}, help="Install Spring BlazeDS configuration artifacts into your project")
    public void installFlex() {
        this.operations.installFlex();
    }

    @CliCommand(value={"flex remoting scaffold"}, help="Create a new scaffold Service (ie with full CRUD operations) exposed as a Flex Remoting Destination")
    public void newRemotingDestination(@CliOption(key={"name", ""}, mandatory=true, help="The path and name of the service object to be created") JavaType service, @CliOption(key={"entity"}, mandatory=false, optionContext="update,project", unspecifiedDefaultValue="*", help="The name of the entity object which the service exposes to the flex client") JavaType entity) {
        this.operations.createRemotingDestination(service, entity);
    }

    @CliCommand(value={"flex remoting all"}, help="Scaffold a Service for all entities without an existing Remoting Destination")
    public void generateAll(@CliOption(key={"package"}, mandatory=true, help="The package in which new services will be placed") JavaPackage javaPackage) {
        ProjectMetadata projectMetadata = (ProjectMetadata)this.metadataService.get(ProjectMetadata.getProjectIdentifier((String)this.projectOperations.getFocusedModuleName()));
        Validate.notNull((Object)projectMetadata, (String)"Could not obtain ProjectMetadata", (Object[])new Object[0]);
        if (!javaPackage.getFullyQualifiedPackageName().startsWith(this.projectOperations.getTopLevelPackage(this.projectOperations.getFocusedModuleName()).getFullyQualifiedPackageName())) {
            logger.warning("Your service was created outside of the project's top level package and is therefore not included in the preconfigured component scanning. Please adjust your component scanning manually in applicationContext.xml");
        }
        this.operations.generateAll(javaPackage);
    }

    protected void bindOperations(FlexOperations flexOperations) {
        this.operations = flexOperations;
    }

    protected void unbindOperations(FlexOperations flexOperations) {
        if (this.operations == flexOperations) {
            this.operations = null;
        }
    }

    protected void bindMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    protected void unbindMetadataService(MetadataService metadataService) {
        if (this.metadataService == metadataService) {
            this.metadataService = null;
        }
    }

    protected void bindProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }

    protected void unbindProjectOperations(ProjectOperations projectOperations) {
        if (this.projectOperations == projectOperations) {
            this.projectOperations = null;
        }
    }
}

