/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.xml.transform.Transformer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.flex.FlexOperations;
import org.gvnix.flex.FlexProjectMetadata;
import org.gvnix.flex.FlexScaffoldMetadata;
import org.gvnix.flex.RooFlexScaffold;
import org.gvnix.flex.addon.antlr.stringtemplate.StringTemplate;
import org.gvnix.flex.addon.antlr.stringtemplate.StringTemplateGroup;
import org.gvnix.flex.as.model.ActionScriptMappingUtils;
import org.gvnix.flex.as.model.ActionScriptType;
import org.gvnix.flex.entity.ActionScriptEntityMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.addon.jpa.activerecord.JpaActiveRecordMetadata;
import org.springframework.roo.addon.jpa.activerecord.RooJpaActiveRecord;
import org.springframework.roo.addon.web.mvc.controller.WebMvcOperations;
import org.springframework.roo.classpath.PhysicalTypeCategory;
import org.springframework.roo.classpath.PhysicalTypeIdentifier;
import org.springframework.roo.classpath.TypeLocationService;
import org.springframework.roo.classpath.TypeManagementService;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetailsBuilder;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadata;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadataBuilder;
import org.springframework.roo.classpath.details.annotations.ClassAttributeValue;
import org.springframework.roo.metadata.MetadataDependencyRegistry;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.JavaPackage;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.process.manager.FileManager;
import org.springframework.roo.process.manager.MutableFile;
import org.springframework.roo.project.Dependency;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;
import org.springframework.roo.project.PathResolver;
import org.springframework.roo.project.Plugin;
import org.springframework.roo.project.ProjectMetadata;
import org.springframework.roo.project.ProjectOperations;
import org.springframework.roo.project.ProjectType;
import org.springframework.roo.project.Property;
import org.springframework.roo.project.Repository;
import org.springframework.roo.support.osgi.UrlFindingUtils;
import org.springframework.roo.support.util.FileUtils;
import org.springframework.roo.support.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component
@Service
public class FlexOperationsImpl
implements FlexOperations {
    private static final String TEMPLATE_PATH = FlexOperationsImpl.class.getPackage().getName().replace(".", "/");
    @Reference
    private FileManager fileManager;
    @Reference
    private MetadataService metadataService;
    @Reference
    private ProjectOperations projectOperations;
    @Reference
    private WebMvcOperations webMvcOperations;
    @Reference
    private PathResolver pathResolver;
    @Reference
    private MetadataDependencyRegistry dependencyRegistry;
    @Reference
    private TypeLocationService typeLocationService;
    @Reference
    private TypeManagementService typeManagementService;
    private ComponentContext context;
    private StringTemplateGroup templateGroup;

    protected void activate(ComponentContext context) {
        this.context = context;
        this.templateGroup = new StringTemplateGroup("flexOperationsTemplateGroup");
    }

    @Override
    public void installFlex() {
        this.createServicesConfig();
        this.createFlexConfig();
        this.updateDependencies();
        this.configureFlexBuild();
        this.createScaffoldApp();
        this.createFlexCompilerConfig();
    }

    @Override
    public boolean isFlexAvailable() {
        return this.getPathResolver() != null && !this.isFlexConfigured();
    }

    @Override
    public boolean isFlexConfigured() {
        return this.metadataService.get(FlexProjectMetadata.getProjectIdentifier()) != null;
    }

    @Override
    public void createScaffoldApp() {
        this.metadataService.get(ProjectMetadata.getProjectIdentifier((String)this.projectOperations.getFocusedModuleName()));
        String scaffoldAppFileId = this.pathResolver.getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "src/main/flex/" + this.projectOperations.getProjectName(this.projectOperations.getFocusedModuleName()) + "_scaffold.mxml");
        String presentationPackage = this.projectOperations.getTopLevelPackage(this.projectOperations.getFocusedModuleName()) + ".presentation";
        StringTemplate scaffoldTemplate = this.templateGroup.getInstanceOf(TEMPLATE_PATH + "/appname_scaffold");
        scaffoldTemplate.setAttribute("presentationPackage", presentationPackage);
        scaffoldTemplate.setAttribute("amfRemotingUrl", "messagebroker/amf");
        this.fileManager.createOrUpdateTextFileIfRequired(scaffoldAppFileId, scaffoldTemplate.toString(), true);
        String htmlWrapperFileId = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), this.projectOperations.getProjectName(this.projectOperations.getFocusedModuleName()) + "_scaffold.html");
        StringTemplate htmlWrapperTemplate = this.templateGroup.getInstanceOf(TEMPLATE_PATH + "/appname_scaffold_html");
        htmlWrapperTemplate.setAttribute("projectName", this.projectOperations.getProjectName(this.projectOperations.getFocusedModuleName()));
        this.fileManager.createOrUpdateTextFileIfRequired(htmlWrapperFileId, htmlWrapperTemplate.toString(), true);
        this.copyDirectoryContents("htmlwrapper/*.*", this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), "/"));
        this.copyDirectoryContents("htmlwrapper/history/*.*", this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), "/history"));
        this.copyDirectoryContents("flashbuilder/html-template/*.*", this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "/html-template"));
        this.copyDirectoryContents("htmlwrapper/history/*.*", this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "/html-template/history"));
    }

    @Override
    public void createFlexCompilerConfig() {
        this.metadataService.get(ProjectMetadata.getProjectIdentifier((String)this.projectOperations.getFocusedModuleName()));
        String compilerConfigFileId = this.pathResolver.getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "src/main/flex/" + this.projectOperations.getProjectName(this.projectOperations.getFocusedModuleName()) + "_scaffold-config.xml");
        if (!this.fileManager.exists(compilerConfigFileId)) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                inputStream = FileUtils.getInputStream(this.getClass(), (String)"flex-compiler-config.xml");
                outputStream = this.fileManager.createFile(compilerConfigFileId).getOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (Exception e) {
                try {
                    throw new IllegalStateException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    @Override
    public void generateAll(JavaPackage javaPackage) {
        Set cids = this.typeLocationService.findClassesOrInterfaceDetailsWithAnnotation(new JavaType[]{new JavaType(RooJpaActiveRecord.class.getName())});
        for (ClassOrInterfaceTypeDetails cid : cids) {
            LogicalPath path;
            JavaType javaType;
            JpaActiveRecordMetadata entityMetadata;
            if (Modifier.isAbstract(cid.getModifier()) || (entityMetadata = (JpaActiveRecordMetadata)this.metadataService.get(JpaActiveRecordMetadata.createIdentifier((JavaType)(javaType = cid.getName()), (LogicalPath)(path = PhysicalTypeIdentifier.getPath((String)cid.getDeclaredByMetadataId()))))) == null || !entityMetadata.isValid()) continue;
            String dwnstrmFlexScaffMDataId = FlexScaffoldMetadata.createIdentifier(javaType, path);
            if (this.dependencyRegistry.getDownstream(entityMetadata.getId()).contains(dwnstrmFlexScaffMDataId)) continue;
            JavaType service = new JavaType(javaPackage.getFullyQualifiedPackageName() + "." + javaType.getSimpleTypeName() + "Service");
            this.createRemotingDestination(service, javaType);
        }
    }

    @Override
    public void createRemotingDestination(JavaType service, JavaType entity) {
        Validate.notNull((Object)service, (String)"Remoting Destination Java Type required", (Object[])new Object[0]);
        Validate.notNull((Object)entity, (String)"Entity Java Type required", (Object[])new Object[0]);
        String resourceIdentifier = this.typeLocationService.getPhysicalTypeCanonicalPath(service, LogicalPath.getInstance((Path)Path.SRC_MAIN_JAVA, (String)""));
        ArrayList<ClassAttributeValue> rooFlexScaffoldAttributes = new ArrayList<ClassAttributeValue>();
        rooFlexScaffoldAttributes.add(new ClassAttributeValue(new JavaSymbolName("entity"), entity));
        AnnotationMetadata atRooFlexScaffold = new AnnotationMetadataBuilder(new JavaType(RooFlexScaffold.class.getName()), rooFlexScaffoldAttributes).build();
        ArrayList remotingDestinationAttributes = new ArrayList();
        AnnotationMetadata atRemotingDestination = new AnnotationMetadataBuilder(new JavaType("org.springframework.flex.remoting.RemotingDestination"), remotingDestinationAttributes).build();
        ArrayList serviceAttributes = new ArrayList();
        AnnotationMetadata atService = new AnnotationMetadataBuilder(new JavaType("org.springframework.stereotype.Service"), serviceAttributes).build();
        String declaredByMetadataId = PhysicalTypeIdentifier.createIdentifier((JavaType)service, (LogicalPath)this.getPathResolver().getPath(resourceIdentifier));
        ClassOrInterfaceTypeDetailsBuilder typeBuilder = new ClassOrInterfaceTypeDetailsBuilder(declaredByMetadataId, 1, service, PhysicalTypeCategory.CLASS);
        typeBuilder.addAnnotation(atRooFlexScaffold);
        typeBuilder.addAnnotation(atRemotingDestination);
        typeBuilder.addAnnotation(atService);
        ClassOrInterfaceTypeDetails details = typeBuilder.build();
        this.typeManagementService.generateClassFile(details);
        ActionScriptType asType = ActionScriptMappingUtils.toActionScriptType(entity);
        this.metadataService.get(ActionScriptEntityMetadata.createTypeIdentifier(asType, "src/main/flex"));
    }

    private void createServicesConfig() {
        String servicesConfigFilename = "WEB-INF/flex/services-config.xml";
        if (this.fileManager.exists(this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), servicesConfigFilename))) {
            return;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = FileUtils.getInputStream(this.getClass(), (String)"services-config-template.xml");
            outputStream = this.fileManager.createFile(this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), servicesConfigFilename)).getOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Encountered an error during copying of resources for maven addon.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)outputStream);
        this.fileManager.scan();
    }

    private void createFlexConfig() {
        Document mvcAppCtx;
        String flexConfigFilename = "/WEB-INF/spring/flex-config.xml";
        if (!this.fileManager.exists(this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), flexConfigFilename))) {
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                inputStream = FileUtils.getInputStream(this.getClass(), (String)"flex-config.xml");
                outputStream = this.fileManager.createFile(this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), flexConfigFilename)).getOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (Exception e) {
                try {
                    throw new IllegalStateException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        String mvcContextPath = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), "/WEB-INF/spring/webmvc-config.xml");
        MutableFile mvcContextMutableFile = null;
        try {
            if (!this.fileManager.exists(mvcContextPath)) {
                this.webMvcOperations.installAllWebMvcArtifacts();
            }
            mvcContextMutableFile = this.fileManager.updateFile(mvcContextPath);
            mvcAppCtx = XmlUtils.getDocumentBuilder().parse(mvcContextMutableFile.getInputStream());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Element root = mvcAppCtx.getDocumentElement();
        if (null == XmlUtils.findFirstElement((String)"/beans/import[@resource='flex-config.xml']", (Node)root)) {
            Element importFlex = mvcAppCtx.createElement("import");
            importFlex.setAttribute("resource", "flex-config.xml");
            root.appendChild(importFlex);
            XmlUtils.writeXml((OutputStream)mvcContextMutableFile.getOutputStream(), (Document)mvcAppCtx);
        }
    }

    private void updateDependencies() {
        Document dependencyDoc;
        InputStream templateInputStream = FileUtils.getInputStream(this.getClass(), (String)"dependencies.xml");
        Validate.notNull((Object)templateInputStream, (String)"Could not acquire dependencies.xml file", (Object[])new Object[0]);
        try {
            dependencyDoc = XmlUtils.getDocumentBuilder().parse(templateInputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Element dependenciesElement = (Element)dependencyDoc.getFirstChild();
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        List flexDependencies = XmlUtils.findElements((String)"/dependencies/springFlex/dependency", (Element)dependenciesElement);
        for (Element dependency : flexDependencies) {
            dependencies.add(new Dependency(dependency));
        }
        this.projectOperations.addDependencies(this.projectOperations.getFocusedModuleName(), dependencies);
        this.projectOperations.addProperty(this.projectOperations.getFocusedModuleName(), new Property("flex.version", "4.1.0.16248"));
        this.fixBrokenFlexDependency();
        this.projectOperations.updateProjectType(this.projectOperations.getFocusedModuleName(), ProjectType.WAR);
    }

    private void fixBrokenFlexDependency() {
        Document pomDoc;
        String pomPath = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "pom.xml");
        try {
            pomDoc = XmlUtils.getDocumentBuilder().parse(this.fileManager.getInputStream(pomPath));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Element typeElement = XmlUtils.findFirstElement((String)"/project/dependencies/dependency[artifactId='flex-framework']/type", (Node)pomDoc.getDocumentElement());
        Validate.notNull((Object)typeElement, (String)"Could not find the flex-framework dependency type.", (Object[])new Object[0]);
        typeElement.setTextContent("pom");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlUtils.writeXml((Transformer)XmlUtils.createIndentingTransformer(), (OutputStream)byteArrayOutputStream, (Document)pomDoc);
        String pomContent = byteArrayOutputStream.toString();
        try {
            this.fileManager.createOrUpdateTextFileIfRequired(pomPath, pomContent, false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void fixBrokenFlexPlugin() {
        Document configurationTemplate;
        Document pomDoc;
        String pomPath = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "pom.xml");
        try {
            pomDoc = XmlUtils.getDocumentBuilder().parse(this.fileManager.getInputStream(pomPath));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Element pluginDependencyElement = XmlUtils.findFirstElement((String)"/project/build/plugins/plugin[artifactId='flexmojos-maven-plugin']/dependencies/dependency", (Node)pomDoc.getDocumentElement());
        Validate.notNull((Object)pluginDependencyElement, (String)"Could not find the flexmojos-maven-plugin's dependency element.", (Object[])new Object[0]);
        Element newTypeNode = pomDoc.createElement("type");
        newTypeNode.setTextContent("pom");
        pluginDependencyElement.appendChild(newTypeNode);
        Element pluginExecutionElement = XmlUtils.findFirstElement((String)"/project/build/plugins/plugin[artifactId='flexmojos-maven-plugin']/executions/execution", (Node)pomDoc.getDocumentElement());
        InputStream templateInputStream = FileUtils.getInputStream(this.getClass(), (String)"pluginsFix.xml");
        try {
            configurationTemplate = XmlUtils.getDocumentBuilder().parse(templateInputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Element configurationElement = XmlUtils.findFirstElement((String)"/configuration", (Node)configurationTemplate.getDocumentElement());
        Validate.notNull((Object)configurationElement, (String)"flexmojos-maven-plugin configuration did not parse as expected.", (Object[])new Object[0]);
        pluginExecutionElement.appendChild(pomDoc.importNode(configurationElement, true));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlUtils.writeXml((Transformer)XmlUtils.createIndentingTransformer(), (OutputStream)byteArrayOutputStream, (Document)pomDoc);
        String pomContent = byteArrayOutputStream.toString();
        try {
            this.fileManager.createOrUpdateTextFileIfRequired(pomPath, pomContent, false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void configureFlexBuild() {
        String actionScriptPropertiesFiledId;
        Document pluginDoc;
        this.metadataService.get(ProjectMetadata.getProjectIdentifier((String)this.projectOperations.getFocusedModuleName()));
        Repository externalRepository = new Repository("spring-external", "Spring External Repository", "http://maven.springframework.org/external");
        if (!this.projectOperations.getFocusedModule().isRepositoryRegistered(externalRepository)) {
            this.projectOperations.addRepository(this.projectOperations.getFocusedModuleName(), externalRepository);
        }
        Repository flexRepository = new Repository("flex", "Sonatype Flex Repo", "http://repository.sonatype.org/content/groups/flexgroup");
        if (!this.projectOperations.getFocusedModule().isRepositoryRegistered(flexRepository)) {
            this.projectOperations.addRepository(this.projectOperations.getFocusedModuleName(), flexRepository);
        }
        if (!this.projectOperations.getFocusedModule().isPluginRepositoryRegistered(flexRepository)) {
            this.projectOperations.addPluginRepository(this.projectOperations.getFocusedModuleName(), flexRepository);
        }
        Repository springFlexRepository = new Repository("spring-flex", "Spring Flex Repository", "https://github.com/SpringSource/spring-flex/raw/spring-flex-1.5.0.RELEASE/local-repo");
        if (!this.projectOperations.getFocusedModule().isRepositoryRegistered(springFlexRepository)) {
            this.projectOperations.addRepository(this.projectOperations.getFocusedModuleName(), springFlexRepository);
        }
        Repository gvNixRepository = new Repository("gvnix", "gvNIX Repository", "https://gvnix.googlecode.com/svn/repo");
        if (!this.projectOperations.getFocusedModule().isRepositoryRegistered(gvNixRepository)) {
            this.projectOperations.addRepository(this.projectOperations.getFocusedModuleName(), gvNixRepository);
        }
        InputStream templateInputStream = FileUtils.getInputStream(this.getClass(), (String)"plugins.xml");
        Validate.notNull((Object)templateInputStream, (String)"Could not acquire plugins.xml file", (Object[])new Object[0]);
        try {
            pluginDoc = XmlUtils.getDocumentBuilder().parse(templateInputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Element pluginsElement = (Element)pluginDoc.getFirstChild();
        List flexPlugins = XmlUtils.findElements((String)"/plugins/springFlex/plugin", (Element)pluginsElement);
        for (Element pluginElement : flexPlugins) {
            Plugin flexPlugin = new Plugin(pluginElement);
            if (this.projectOperations.getFocusedModule().isBuildPluginRegistered(flexPlugin)) {
                this.projectOperations.removeBuildPlugin(this.projectOperations.getFocusedModuleName(), flexPlugin);
            }
            this.projectOperations.addBuildPlugin(this.projectOperations.getFocusedModuleName(), flexPlugin);
        }
        this.fixBrokenFlexPlugin();
        String flexPropertiesFileId = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), ".flexProperties");
        if (!this.fileManager.exists(flexPropertiesFileId)) {
            StringTemplate flexPropertiesTemplate = this.templateGroup.getInstanceOf(TEMPLATE_PATH + "/flex_properties");
            flexPropertiesTemplate.setAttribute("projectName", this.projectOperations.getProjectName(this.projectOperations.getFocusedModuleName()));
            this.fileManager.createOrUpdateTextFileIfRequired(flexPropertiesFileId, flexPropertiesTemplate.toString(), true);
        }
        if (!this.fileManager.exists(actionScriptPropertiesFiledId = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), ".actionScriptProperties"))) {
            StringTemplate actionScriptPropertiesTemplate = this.templateGroup.getInstanceOf(TEMPLATE_PATH + "/actionscript_properties");
            actionScriptPropertiesTemplate.setAttribute("projectName", this.projectOperations.getProjectName(this.projectOperations.getFocusedModuleName()));
            actionScriptPropertiesTemplate.setAttribute("projectUUID", UUID.randomUUID());
            this.fileManager.createOrUpdateTextFileIfRequired(actionScriptPropertiesFiledId, actionScriptPropertiesTemplate.toString(), true);
        }
    }

    private PathResolver getPathResolver() {
        ProjectMetadata projectMetadata = (ProjectMetadata)this.metadataService.get(ProjectMetadata.getProjectIdentifier((String)this.projectOperations.getFocusedModuleName()));
        if (projectMetadata == null) {
            return null;
        }
        return this.projectOperations.getPathResolver();
    }

    private void copyDirectoryContents(String sourceAntPath, String targetDirectory) {
        StringUtils.isNotBlank((CharSequence)sourceAntPath);
        StringUtils.isNotBlank((CharSequence)targetDirectory);
        if (!targetDirectory.endsWith("/")) {
            targetDirectory = targetDirectory + "/";
        }
        if (!this.fileManager.exists(targetDirectory)) {
            this.fileManager.createDirectory(targetDirectory);
        }
        String path = FileUtils.getPath(this.getClass(), (String)sourceAntPath);
        Set urls = UrlFindingUtils.findMatchingClasspathResources((BundleContext)this.context.getBundleContext(), (String)path);
        Validate.notNull((Object)urls, (String)("Could not search bundles for resources for Ant Path '" + path + "'"), (Object[])new Object[0]);
        for (URL url : urls) {
            String fileName = url.getPath().substring(url.getPath().lastIndexOf("/") + 1);
            if (this.fileManager.exists(targetDirectory + fileName)) continue;
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                inputStream = url.openStream();
                outputStream = this.fileManager.createFile(targetDirectory + fileName).getOutputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (IOException e) {
                try {
                    throw new IllegalStateException("Encountered an error during copying of resources for Flex addon.", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    protected void bindFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    protected void unbindFileManager(FileManager fileManager) {
        if (this.fileManager == fileManager) {
            this.fileManager = null;
        }
    }

    protected void bindMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    protected void unbindMetadataService(MetadataService metadataService) {
        if (this.metadataService == metadataService) {
            this.metadataService = null;
        }
    }

    protected void bindProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }

    protected void unbindProjectOperations(ProjectOperations projectOperations) {
        if (this.projectOperations == projectOperations) {
            this.projectOperations = null;
        }
    }

    protected void bindWebMvcOperations(WebMvcOperations webMvcOperations) {
        this.webMvcOperations = webMvcOperations;
    }

    protected void unbindWebMvcOperations(WebMvcOperations webMvcOperations) {
        if (this.webMvcOperations == webMvcOperations) {
            this.webMvcOperations = null;
        }
    }

    protected void bindPathResolver(PathResolver pathResolver) {
        this.pathResolver = pathResolver;
    }

    protected void unbindPathResolver(PathResolver pathResolver) {
        if (this.pathResolver == pathResolver) {
            this.pathResolver = null;
        }
    }

    protected void bindDependencyRegistry(MetadataDependencyRegistry metadataDependencyRegistry) {
        this.dependencyRegistry = metadataDependencyRegistry;
    }

    protected void unbindDependencyRegistry(MetadataDependencyRegistry metadataDependencyRegistry) {
        if (this.dependencyRegistry == metadataDependencyRegistry) {
            this.dependencyRegistry = null;
        }
    }

    protected void bindTypeLocationService(TypeLocationService typeLocationService) {
        this.typeLocationService = typeLocationService;
    }

    protected void unbindTypeLocationService(TypeLocationService typeLocationService) {
        if (this.typeLocationService == typeLocationService) {
            this.typeLocationService = null;
        }
    }

    protected void bindTypeManagementService(TypeManagementService typeManagementService) {
        this.typeManagementService = typeManagementService;
    }

    protected void unbindTypeManagementService(TypeManagementService typeManagementService) {
        if (this.typeManagementService == typeManagementService) {
            this.typeManagementService = null;
        }
    }
}

