/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex;

import java.io.File;
import java.util.HashSet;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.flex.FlexProjectMetadata;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.file.monitor.DirectoryMonitoringRequest;
import org.springframework.roo.file.monitor.FileMonitorService;
import org.springframework.roo.file.monitor.MonitoringRequest;
import org.springframework.roo.file.monitor.NotifiableFileMonitorService;
import org.springframework.roo.file.monitor.event.FileOperation;
import org.springframework.roo.file.undo.CreateDirectory;
import org.springframework.roo.file.undo.FilenameResolver;
import org.springframework.roo.file.undo.UndoManager;
import org.springframework.roo.metadata.MetadataDependencyRegistry;
import org.springframework.roo.metadata.MetadataIdentificationUtils;
import org.springframework.roo.metadata.MetadataNotificationListener;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.PathResolver;
import org.springframework.roo.project.UndoableMonitoringRequest;

@Component
@Service
public class FlexProjectListener
implements MetadataNotificationListener {
    @Reference
    private FilenameResolver filenameResolver;
    @Reference
    private MetadataService metadataService;
    @Reference
    private MetadataDependencyRegistry metadataDependencyRegistry;
    @Reference
    private UndoManager undoManager;
    @Reference
    private NotifiableFileMonitorService fileMonitorService;
    private boolean pathsRegistered = false;

    protected void activate(ComponentContext context) {
        this.metadataDependencyRegistry.addNotificationListener((MetadataNotificationListener)this);
    }

    protected void deactivate(ComponentContext context) {
        this.metadataDependencyRegistry.removeNotificationListener((MetadataNotificationListener)this);
    }

    public void notify(String upstreamDependency, String downstreamDependency) {
        if (this.pathsRegistered) {
            return;
        }
        Validate.isTrue((boolean)MetadataIdentificationUtils.isValid((String)upstreamDependency), (String)("Upstream dependency is an invalid metadata identification string ('" + upstreamDependency + "')"), (Object[])new Object[0]);
        if (upstreamDependency.equals(FlexProjectMetadata.getProjectIdentifier())) {
            FlexProjectMetadata pmd = (FlexProjectMetadata)this.metadataService.get(upstreamDependency);
            if (pmd == null) {
                return;
            }
            PathResolver pathResolver = pmd.getPathResolver();
            Validate.notNull((Object)pathResolver, (String)("Path resolver could not be acquired from changed metadata '" + (Object)((Object)pmd) + "'"), (Object[])new Object[0]);
            HashSet<FileOperation> notifyOn = new HashSet<FileOperation>();
            notifyOn.add(FileOperation.MONITORING_START);
            notifyOn.add(FileOperation.MONITORING_FINISH);
            notifyOn.add(FileOperation.CREATED);
            notifyOn.add(FileOperation.RENAMED);
            notifyOn.add(FileOperation.UPDATED);
            notifyOn.add(FileOperation.DELETED);
            for (LogicalPath path : pathResolver.getPaths()) {
                if (path.isProjectRoot()) continue;
                String fileIdentifier = pathResolver.getRoot(path);
                File file = new File(fileIdentifier);
                Validate.isTrue((!file.exists() || file.exists() && file.isDirectory() ? 1 : 0) != 0, (String)("Path '" + fileIdentifier + "' must either not exist or be a directory"), (Object[])new Object[0]);
                if (!file.exists()) {
                    new CreateDirectory(this.undoManager, this.filenameResolver, file);
                }
                DirectoryMonitoringRequest request = new DirectoryMonitoringRequest(file, true, notifyOn);
                new UndoableMonitoringRequest(this.undoManager, (FileMonitorService)this.fileMonitorService, (MonitoringRequest)request, pmd.isValid());
            }
            this.pathsRegistered = pmd.isValid();
            this.fileMonitorService.scanAll();
        }
    }

    protected void bindFilenameResolver(FilenameResolver filenameResolver) {
        this.filenameResolver = filenameResolver;
    }

    protected void unbindFilenameResolver(FilenameResolver filenameResolver) {
        if (this.filenameResolver == filenameResolver) {
            this.filenameResolver = null;
        }
    }

    protected void bindMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    protected void unbindMetadataService(MetadataService metadataService) {
        if (this.metadataService == metadataService) {
            this.metadataService = null;
        }
    }

    protected void bindMetadataDependencyRegistry(MetadataDependencyRegistry metadataDependencyRegistry) {
        this.metadataDependencyRegistry = metadataDependencyRegistry;
    }

    protected void unbindMetadataDependencyRegistry(MetadataDependencyRegistry metadataDependencyRegistry) {
        if (this.metadataDependencyRegistry == metadataDependencyRegistry) {
            this.metadataDependencyRegistry = null;
        }
    }

    protected void bindUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    protected void unbindUndoManager(UndoManager undoManager) {
        if (this.undoManager == undoManager) {
            this.undoManager = null;
        }
    }

    protected void bindFileMonitorService(NotifiableFileMonitorService notifiableFileMonitorService) {
        this.fileMonitorService = notifiableFileMonitorService;
    }

    protected void unbindFileMonitorService(NotifiableFileMonitorService notifiableFileMonitorService) {
        if (this.fileMonitorService == notifiableFileMonitorService) {
            this.fileMonitorService = null;
        }
    }
}

