/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex;

import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.flex.FlexProjectMetadata;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.file.monitor.event.FileEvent;
import org.springframework.roo.file.monitor.event.FileEventListener;
import org.springframework.roo.file.monitor.event.FileOperation;
import org.springframework.roo.metadata.MetadataDependencyRegistry;
import org.springframework.roo.metadata.MetadataIdentificationUtils;
import org.springframework.roo.metadata.MetadataItem;
import org.springframework.roo.metadata.MetadataProvider;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.process.manager.FileManager;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;
import org.springframework.roo.project.PathResolver;
import org.springframework.roo.support.logging.HandlerUtils;

@Component
@Service
public class FlexProjectMetadataProvider
implements MetadataProvider,
FileEventListener {
    protected static final Logger LOGGER = HandlerUtils.getLogger(FlexProjectMetadataProvider.class);
    private BundleContext context;
    private static final String PROVIDES_TYPE = MetadataIdentificationUtils.create((String)MetadataIdentificationUtils.getMetadataClass((String)FlexProjectMetadata.getProjectIdentifier()));
    private MetadataService metadataService;
    private MetadataDependencyRegistry metadataDependencyRegistry;
    private FileManager fileManager;
    private PathResolver pathResolver;
    private String flexServicesConfigIndentifier;

    protected void activate(ComponentContext cContext) {
        this.context = cContext.getBundleContext();
    }

    private String getFlexServicesConfigIndentifier() {
        if (this.flexServicesConfigIndentifier == null) {
            this.flexServicesConfigIndentifier = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), "WEB-INF/flex/services-config.xml");
        }
        return this.flexServicesConfigIndentifier;
    }

    public MetadataItem get(String metadataIdentificationString) {
        Validate.isTrue((boolean)FlexProjectMetadata.getProjectIdentifier().equals(metadataIdentificationString), (String)("Unexpected metadata request '" + metadataIdentificationString + "' for this provider"), (Object[])new Object[0]);
        if (!this.getFileManager().exists(this.getFlexServicesConfigIndentifier())) {
            return null;
        }
        return new FlexProjectMetadata(this.getPathResolver());
    }

    public String getProvidesType() {
        return PROVIDES_TYPE;
    }

    public void onFileEvent(FileEvent fileEvent) {
        Validate.notNull((Object)fileEvent, (String)"File event required", (Object[])new Object[0]);
        if (fileEvent.getFileDetails().getCanonicalPath().equals(this.getFlexServicesConfigIndentifier())) {
            if (fileEvent.getOperation() == FileOperation.MONITORING_FINISH) {
                return;
            }
            this.getMetadataService().evictAndGet(FlexProjectMetadata.getProjectIdentifier());
            this.getMetadataDependencyRegistry().notifyDownstream(FlexProjectMetadata.getProjectIdentifier());
        }
    }

    public MetadataDependencyRegistry getMetadataDependencyRegistry() {
        if (this.metadataDependencyRegistry == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MetadataDependencyRegistry.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MetadataDependencyRegistry)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MetadataDependencyRegistry on FlexProjectMetadataProvider.");
                return null;
            }
        }
        return this.metadataDependencyRegistry;
    }

    public PathResolver getPathResolver() {
        if (this.pathResolver == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(PathResolver.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (PathResolver)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load PathResolver on FlexProjectMetadataProvider.");
                return null;
            }
        }
        return this.pathResolver;
    }

    public MetadataService getMetadataService() {
        if (this.metadataService == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MetadataService.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MetadataService)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MetadataService on FlexProjectMetadataProvider.");
                return null;
            }
        }
        return this.metadataService;
    }

    public FileManager getFileManager() {
        if (this.fileManager == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(FileManager.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (FileManager)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load FileManager on FlexProjectMetadataProvider.");
                return null;
            }
        }
        return this.fileManager;
    }
}

