/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex;

import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.gvnix.flex.FlexScaffoldAnnotationValues;
import org.springframework.roo.addon.jpa.activerecord.JpaActiveRecordMetadata;
import org.springframework.roo.addon.jpa.activerecord.JpaCrudAnnotationValues;
import org.springframework.roo.addon.web.mvc.controller.details.FinderMetadataDetails;
import org.springframework.roo.classpath.PhysicalTypeIdentifierNamingUtils;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.details.MethodMetadataBuilder;
import org.springframework.roo.classpath.details.annotations.AnnotatedJavaType;
import org.springframework.roo.classpath.itd.AbstractItdTypeDetailsProvidingMetadataItem;
import org.springframework.roo.classpath.itd.InvocableMemberBodyBuilder;
import org.springframework.roo.classpath.itd.ItdSourceFileComposer;
import org.springframework.roo.classpath.itd.MemberHoldingTypeDetailsMetadataItem;
import org.springframework.roo.classpath.persistence.PersistenceMemberLocator;
import org.springframework.roo.metadata.MetadataIdentificationUtils;
import org.springframework.roo.model.DataType;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.LogicalPath;

public class FlexScaffoldMetadata
extends AbstractItdTypeDetailsProvidingMetadataItem {
    private static final String PROVIDES_TYPE_STRING = FlexScaffoldMetadata.class.getName();
    private static final String PROVIDES_TYPE = MetadataIdentificationUtils.create((String)PROVIDES_TYPE_STRING);
    private JpaActiveRecordMetadata entityMetadata;
    private JavaType entity;
    private String entityReference;
    private PersistenceMemberLocator persistenceMemberLocator;

    public FlexScaffoldMetadata(String identifier, JavaType aspectName, PhysicalTypeMetadata governorPhysicalTypeMetadata, FlexScaffoldAnnotationValues annotationValues, JpaActiveRecordMetadata entityMetadata, Set<FinderMetadataDetails> dynamicFinderMethods, PersistenceMemberLocator persistenceMemberLocator) {
        super(identifier, aspectName, governorPhysicalTypeMetadata);
        Validate.isTrue((boolean)FlexScaffoldMetadata.isValid(identifier), (String)("Metadata identification string '" + identifier + "' does not appear to be a valid"), (Object[])new Object[0]);
        Validate.notNull((Object)entityMetadata, (String)"Entity metadata required", (Object[])new Object[0]);
        if (!this.isValid()) {
            return;
        }
        this.entityMetadata = entityMetadata;
        this.entity = annotationValues.getEntity();
        this.entityReference = StringUtils.uncapitalize((String)this.entity.getSimpleTypeName());
        this.persistenceMemberLocator = persistenceMemberLocator;
        this.builder.addMethod(this.getCreateMethod());
        this.builder.addMethod(this.getShowMethod());
        this.builder.addMethod(this.getListMethod());
        this.builder.addMethod(this.getListPagedMethod());
        this.builder.addMethod(this.getUpdateMethod());
        this.builder.addMethod(this.getRemoveMethod());
        this.itdTypeDetails = this.builder.build();
        new ItdSourceFileComposer(this.itdTypeDetails);
    }

    public static final String getMetadataIdentiferType() {
        return PROVIDES_TYPE;
    }

    public static final String createIdentifier(JavaType javaType, LogicalPath path) {
        return PhysicalTypeIdentifierNamingUtils.createIdentifier((String)PROVIDES_TYPE_STRING, (JavaType)javaType, (LogicalPath)path);
    }

    public static final JavaType getJavaType(String metadataIdentificationString) {
        return PhysicalTypeIdentifierNamingUtils.getJavaType((String)PROVIDES_TYPE_STRING, (String)metadataIdentificationString);
    }

    public JpaActiveRecordMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public JavaType getEntity() {
        return this.entity;
    }

    public String getEntityReference() {
        return this.entityReference;
    }

    public static final LogicalPath getPath(String metadataIdentificationString) {
        return PhysicalTypeIdentifierNamingUtils.getPath((String)PROVIDES_TYPE_STRING, (String)metadataIdentificationString);
    }

    public static boolean isValid(String metadataIdentificationString) {
        return PhysicalTypeIdentifierNamingUtils.isValid((String)PROVIDES_TYPE_STRING, (String)metadataIdentificationString);
    }

    private MethodMetadata getRemoveMethod() {
        JavaSymbolName methodName = new JavaSymbolName("remove");
        MethodMetadata method = this.methodExists(methodName);
        if (method != null) {
            return method;
        }
        FieldMetadata identifierField = (FieldMetadata)this.persistenceMemberLocator.getIdentifierFields(this.entity).get(0);
        ArrayList<AnnotatedJavaType> paramTypes = new ArrayList<AnnotatedJavaType>();
        paramTypes.add(new AnnotatedJavaType(identifierField.getFieldType(), new ArrayList()));
        ArrayList<JavaSymbolName> paramNames = new ArrayList<JavaSymbolName>();
        paramNames.add(new JavaSymbolName(identifierField.getFieldName().getSymbolName()));
        InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
        if (!identifierField.getFieldType().isPrimitive()) {
            bodyBuilder.appendFormalLine("if (" + identifierField.getFieldName().getSymbolName() + " == null) throw new IllegalArgumentException(\"An Identifier is required\");");
        }
        bodyBuilder.appendFormalLine(this.entity.getNameIncludingTypeParameters(false, this.builder.getImportRegistrationResolver()) + "." + this.entityMetadata.getFindMethod().getMethodName() + "(" + identifierField.getFieldName().getSymbolName() + ")." + new JpaCrudAnnotationValues((MemberHoldingTypeDetailsMetadataItem)this.entityMetadata).getRemoveMethod() + "();");
        return new MethodMetadataBuilder(this.getId(), 1, methodName, JavaType.VOID_PRIMITIVE, paramTypes, paramNames, bodyBuilder).build();
    }

    private MethodMetadata getListMethod() {
        JavaSymbolName methodName = new JavaSymbolName("list");
        MethodMetadata method = this.methodExists(methodName);
        if (method != null) {
            return method;
        }
        ArrayList<JavaType> typeParams = new ArrayList<JavaType>();
        typeParams.add(this.entity);
        JavaType returnType = new JavaType("java.util.List", 0, DataType.TYPE, null, typeParams);
        InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
        bodyBuilder.appendFormalLine("return " + this.entity.getNameIncludingTypeParameters(false, this.builder.getImportRegistrationResolver()) + "." + new JpaCrudAnnotationValues((MemberHoldingTypeDetailsMetadataItem)this.entityMetadata).getFindAllMethod().concat(this.entityMetadata.getPlural()) + "();");
        return new MethodMetadataBuilder(this.getId(), 1, methodName, returnType, null, null, bodyBuilder).build();
    }

    private MethodMetadata getListPagedMethod() {
        JavaSymbolName methodName = new JavaSymbolName("listPaged");
        MethodMetadata method = this.methodExists(methodName);
        if (method != null) {
            return method;
        }
        ArrayList<JavaType> typeParams = new ArrayList<JavaType>();
        typeParams.add(this.entity);
        JavaType returnType = new JavaType("java.util.List", 0, DataType.TYPE, null, typeParams);
        ArrayList<AnnotatedJavaType> paramTypes = new ArrayList<AnnotatedJavaType>();
        paramTypes.add(new AnnotatedJavaType(new JavaType("Integer"), new ArrayList()));
        paramTypes.add(new AnnotatedJavaType(new JavaType("Integer"), new ArrayList()));
        ArrayList<JavaSymbolName> paramNames = new ArrayList<JavaSymbolName>();
        paramNames.add(new JavaSymbolName("page"));
        paramNames.add(new JavaSymbolName("size"));
        InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
        bodyBuilder.appendFormalLine("if (page != null || size != null) {");
        bodyBuilder.indent();
        bodyBuilder.appendFormalLine("int sizeNo = size == null ? 10 : size.intValue();");
        bodyBuilder.appendFormalLine("return " + this.entity.getNameIncludingTypeParameters(false, this.builder.getImportRegistrationResolver()) + "." + new JpaCrudAnnotationValues((MemberHoldingTypeDetailsMetadataItem)this.entityMetadata).getFindEntriesMethod().concat(this.entityMetadata.getEntityName()).concat("Entries") + "(page == null ? 0 : (page.intValue() - 1) * sizeNo, sizeNo);");
        bodyBuilder.indentRemove();
        bodyBuilder.appendFormalLine("} else {");
        bodyBuilder.indent();
        bodyBuilder.appendFormalLine("return list();");
        bodyBuilder.indentRemove();
        bodyBuilder.appendFormalLine("}");
        return new MethodMetadataBuilder(this.getId(), 1, methodName, returnType, paramTypes, paramNames, bodyBuilder).build();
    }

    private MethodMetadata getShowMethod() {
        JavaSymbolName methodName = new JavaSymbolName("show");
        MethodMetadata method = this.methodExists(methodName);
        if (method != null) {
            return method;
        }
        FieldMetadata identifierField = (FieldMetadata)this.persistenceMemberLocator.getIdentifierFields(this.entity).get(0);
        ArrayList<AnnotatedJavaType> paramTypes = new ArrayList<AnnotatedJavaType>();
        paramTypes.add(new AnnotatedJavaType(identifierField.getFieldType(), new ArrayList()));
        ArrayList<JavaSymbolName> paramNames = new ArrayList<JavaSymbolName>();
        paramNames.add(new JavaSymbolName(identifierField.getFieldName().getSymbolName()));
        InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
        if (!identifierField.getFieldType().isPrimitive()) {
            bodyBuilder.appendFormalLine("if (" + identifierField.getFieldName().getSymbolName() + " == null) throw new IllegalArgumentException(\"An Identifier is required\");");
        }
        bodyBuilder.appendFormalLine("return " + this.entity.getNameIncludingTypeParameters(false, this.builder.getImportRegistrationResolver()) + "." + this.entityMetadata.getFindMethod().getMethodName() + "(" + identifierField.getFieldName().getSymbolName() + ");");
        return new MethodMetadataBuilder(this.getId(), 1, methodName, this.entity, paramTypes, paramNames, bodyBuilder).build();
    }

    private MethodMetadata getCreateMethod() {
        JavaSymbolName methodName = new JavaSymbolName("create");
        MethodMetadata method = this.methodExists(methodName);
        if (method != null) {
            return method;
        }
        ArrayList<AnnotatedJavaType> paramTypes = new ArrayList<AnnotatedJavaType>();
        paramTypes.add(new AnnotatedJavaType(this.entity, new ArrayList()));
        ArrayList<JavaSymbolName> paramNames = new ArrayList<JavaSymbolName>();
        paramNames.add(new JavaSymbolName(this.entityReference));
        InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
        bodyBuilder.appendFormalLine(this.entityReference + "." + new JpaCrudAnnotationValues((MemberHoldingTypeDetailsMetadataItem)this.entityMetadata).getPersistMethod() + "();");
        bodyBuilder.appendFormalLine("return " + this.entityReference + ";");
        return new MethodMetadataBuilder(this.getId(), 1, methodName, this.entity, paramTypes, paramNames, bodyBuilder).build();
    }

    private MethodMetadata getUpdateMethod() {
        JavaSymbolName methodName = new JavaSymbolName("update");
        MethodMetadata method = this.methodExists(methodName);
        if (method != null) {
            return method;
        }
        ArrayList<AnnotatedJavaType> paramTypes = new ArrayList<AnnotatedJavaType>();
        paramTypes.add(new AnnotatedJavaType(this.entity, new ArrayList()));
        ArrayList<JavaSymbolName> paramNames = new ArrayList<JavaSymbolName>();
        paramNames.add(new JavaSymbolName(this.entityReference));
        InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
        bodyBuilder.appendFormalLine("if (" + this.entityReference + " == null) throw new IllegalArgumentException(\"A " + this.entityReference + " is required\");");
        bodyBuilder.appendFormalLine(this.entityReference + "=" + this.entityReference + "." + new JpaCrudAnnotationValues((MemberHoldingTypeDetailsMetadataItem)this.entityMetadata).getMergeMethod() + "();");
        bodyBuilder.appendFormalLine("return " + this.entityReference + ";");
        return new MethodMetadataBuilder(this.getId(), 1, methodName, this.entity, paramTypes, paramNames, bodyBuilder).build();
    }

    private MethodMetadata methodExists(JavaSymbolName methodName) {
        for (MethodMetadata method : this.governorTypeDetails.getDeclaredMethods()) {
            if (!method.getMethodName().equals((Object)methodName)) continue;
            return method;
        }
        return null;
    }
}

