/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex;

import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.flex.FlexScaffoldAnnotationValues;
import org.gvnix.flex.FlexScaffoldMetadata;
import org.gvnix.flex.RooFlexScaffold;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.addon.jpa.activerecord.JpaActiveRecordMetadata;
import org.springframework.roo.addon.web.mvc.controller.details.WebMetadataService;
import org.springframework.roo.classpath.PhysicalTypeIdentifier;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.itd.AbstractItdMetadataProvider;
import org.springframework.roo.classpath.itd.ItdTypeDetailsProvidingMetadataItem;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;
import org.springframework.roo.support.logging.HandlerUtils;

@Component
@Service
public class FlexScaffoldMetadataProvider
extends AbstractItdMetadataProvider {
    private static final Logger LOGGER = HandlerUtils.getLogger(FlexScaffoldMetadataProvider.class);
    private WebMetadataService webMetadataService;

    protected void activate(ComponentContext cContext) {
        this.context = cContext.getBundleContext();
        this.getMetadataDependencyRegistry().registerDependency(PhysicalTypeIdentifier.getMetadataIdentiferType(), this.getProvidesType());
        this.addMetadataTrigger(new JavaType(RooFlexScaffold.class.getName()));
    }

    protected String createLocalIdentifier(JavaType javaType, LogicalPath path) {
        return FlexScaffoldMetadata.createIdentifier(javaType, path);
    }

    protected String getGovernorPhysicalTypeIdentifier(String metadataIdentificationString) {
        JavaType javaType = FlexScaffoldMetadata.getJavaType(metadataIdentificationString);
        LogicalPath path = FlexScaffoldMetadata.getPath(metadataIdentificationString);
        String physicalTypeIdentifier = PhysicalTypeIdentifier.createIdentifier((JavaType)javaType, (LogicalPath)path);
        return physicalTypeIdentifier;
    }

    protected ItdTypeDetailsProvidingMetadataItem getMetadata(String metadataIdentificationString, JavaType aspectName, PhysicalTypeMetadata governorPhysicalTypeMetadata, String itdFilename) {
        FlexScaffoldAnnotationValues annotationValues = new FlexScaffoldAnnotationValues(governorPhysicalTypeMetadata);
        if (!annotationValues.isAnnotationFound() || annotationValues.entity == null) {
            return null;
        }
        JavaType entityType = annotationValues.entity;
        Path path = Path.SRC_MAIN_JAVA;
        String entityMetadataKey = JpaActiveRecordMetadata.createIdentifier((JavaType)entityType, (LogicalPath)LogicalPath.getInstance((Path)path, (String)""));
        JpaActiveRecordMetadata entityMetadata = (JpaActiveRecordMetadata)this.getMetadataService().get(entityMetadataKey);
        if (entityMetadata == null || !entityMetadata.isValid()) {
            return null;
        }
        this.getMetadataDependencyRegistry().registerDependency(entityMetadataKey, metadataIdentificationString);
        PhysicalTypeMetadata entityPhysicalTypeMetadata = (PhysicalTypeMetadata)this.getMetadataService().get(PhysicalTypeIdentifier.createIdentifier((JavaType)entityType, (LogicalPath)LogicalPath.getInstance((Path)path, (String)"")));
        Validate.notNull((Object)entityPhysicalTypeMetadata, (String)("Unable to obtain physical type metdata for type " + entityType.getFullyQualifiedTypeName()), (Object[])new Object[0]);
        ClassOrInterfaceTypeDetails entityClassOrInterfaceDetails = (ClassOrInterfaceTypeDetails)entityPhysicalTypeMetadata.getMemberHoldingTypeDetails();
        MemberDetails entityMemberDetails = this.getMemberDetailsScanner().getMemberDetails(((Object)((Object)this)).getClass().getName(), entityClassOrInterfaceDetails);
        return new FlexScaffoldMetadata(metadataIdentificationString, aspectName, governorPhysicalTypeMetadata, annotationValues, entityMetadata, this.getWebMetadataService().getDynamicFinderMethodsAndFields(entityType, entityMemberDetails, metadataIdentificationString), this.getPersistenceMemberLocator());
    }

    public String getItdUniquenessFilenameSuffix() {
        return "Service";
    }

    public String getProvidesType() {
        return FlexScaffoldMetadata.getMetadataIdentiferType();
    }

    public WebMetadataService getWebMetadataService() {
        if (this.webMetadataService == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(WebMetadataService.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (WebMetadataService)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load WebMetadataService on FlexScaffoldMetadataProvider.");
                return null;
            }
        }
        return this.webMetadataService;
    }
}

