/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import org.gvnix.flex.addon.antlr.runtime.ParserRuleReturnScope;
import org.gvnix.flex.addon.antlr.runtime.RecognitionException;
import org.gvnix.flex.addon.antlr.runtime.TokenStream;
import org.gvnix.flex.addon.asdt.core.internal.antlr.AS3Parser;
import org.gvnix.flex.addon.metaas.ActionScriptFactory;
import org.gvnix.flex.addon.metaas.SyntaxException;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class AS3FragmentParser {
    public static LinkedListTree parseStatement(String statement) {
        LinkedListTree stmt;
        AS3Parser parser = ASTUtils.parse(statement + ";;");
        try {
            stmt = AS3FragmentParser.tree(parser.statement());
        }
        catch (RecognitionException e) {
            throw ASTUtils.buildSyntaxException(statement, parser, e);
        }
        return stmt;
    }

    public static LinkedListTree parseExprStatement(String expr) {
        AS3Parser parser = ASTUtils.parse(expr + ";");
        try {
            return AS3FragmentParser.tree(parser.expressionStatement());
        }
        catch (RecognitionException e) {
            throw ASTUtils.buildSyntaxException(expr, parser, e);
        }
    }

    public static LinkedListTree parseCondition(String expr) {
        AS3Parser parser = ASTUtils.parse("(" + expr + ")");
        try {
            return AS3FragmentParser.tree(parser.condition());
        }
        catch (RecognitionException e) {
            throw new SyntaxException("invalid condition " + ActionScriptFactory.str(expr), e);
        }
    }

    public static LinkedListTree parseExpr(String expr) {
        AS3Parser parser = ASTUtils.parse(expr + ")");
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.expression());
            AS3FragmentParser.ensureRemainingInputIs(parser.getTokenStream(), 79, expr);
            result.getStopToken().setNext(null);
            return result;
        }
        catch (RecognitionException e) {
            throw new SyntaxException("invalid expression " + ActionScriptFactory.str(expr), e);
        }
    }

    public static LinkedListTree parseExprList(String expr) {
        AS3Parser parser = ASTUtils.parse(expr + ")");
        try {
            return AS3FragmentParser.tree(parser.expressionList());
        }
        catch (RecognitionException e) {
            throw new SyntaxException("invalid expression-list " + ActionScriptFactory.str(expr), e);
        }
    }

    public static LinkedListTree tree(ParserRuleReturnScope returnScope) {
        return (LinkedListTree)returnScope.getTree();
    }

    public static LinkedListTree parseIdent(String value) {
        AS3Parser parser = ASTUtils.parse(value);
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.identifier());
            parser.endOfFile();
            return result;
        }
        catch (RecognitionException e) {
            throw new SyntaxException("invalid identifier " + ActionScriptFactory.str(value), e);
        }
    }

    public static LinkedListTree parseParameterDefault(String value) {
        LinkedListTree def;
        AS3Parser parser = ASTUtils.parse("=" + value);
        try {
            def = AS3FragmentParser.tree(parser.parameterDefault());
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e.getMessage());
        }
        return def;
    }

    public static LinkedListTree parseForInit(String expr) {
        AS3Parser parser = ASTUtils.parse(expr + ";");
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.forInit());
            AS3FragmentParser.ensureRemainingInputIs(parser.getTokenStream(), 61, expr);
            return result;
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public static LinkedListTree parseForCond(String expr) {
        AS3Parser parser = ASTUtils.parse(expr + ";");
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.forCond());
            AS3FragmentParser.ensureRemainingInputIs(parser.getTokenStream(), 61, expr);
            return result;
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public static LinkedListTree parseForIter(String expr) {
        AS3Parser parser = ASTUtils.parse(expr + ")");
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.forIter());
            AS3FragmentParser.ensureRemainingInputIs(parser.getTokenStream(), 79, expr);
            return result;
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public static LinkedListTree parseImport(String name) {
        AS3Parser parser = ASTUtils.parse("import " + name + ";");
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.importDefinition());
            parser.endOfFile();
            return result;
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public static LinkedListTree parseTypeSpec(String value) {
        AS3Parser parser = ASTUtils.parse(":" + value);
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.typeExpression());
            AS3FragmentParser.ensureNoMoreInput(parser.getTokenStream(), value);
            return result;
        }
        catch (RecognitionException e) {
            throw new SyntaxException("invalid type-spec " + ActionScriptFactory.str(value), e);
        }
    }

    private static void ensureNoMoreInput(TokenStream input, String value) {
        if (input.LA(1) != -1) {
            throw new SyntaxException("Unexpected tokens in input: " + value);
        }
    }

    private static void ensureRemainingInputIs(TokenStream input, int expectedTokenType, String value) {
        if (input.LA(1) != expectedTokenType) {
            throw new SyntaxException("Unexpected tokens in input: " + value);
        }
    }

    public static LinkedListTree parseForInVar(String expr) {
        AS3Parser parser = ASTUtils.parse(expr + " in");
        try {
            return AS3FragmentParser.tree(parser.forInClauseDecl());
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public static LinkedListTree parseForInIterated(String expr) {
        AS3Parser parser = ASTUtils.parse(expr + ")");
        try {
            return AS3FragmentParser.tree(parser.forInClauseTail());
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public static LinkedListTree parseVariableDeclarator(String assignment) {
        AS3Parser parser = ASTUtils.parse(assignment + ";");
        try {
            return AS3FragmentParser.tree(parser.variableDeclarator());
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public static LinkedListTree parseSimpleIdent(String value) {
        AS3Parser parser = ASTUtils.parse(value);
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.ident());
            parser.endOfFile();
            return result;
        }
        catch (RecognitionException e) {
            throw new SyntaxException("invalid identifier " + ActionScriptFactory.str(value), e);
        }
    }

    public static LinkedListTree parseXMLLiteral(String value) {
        AS3Parser parser = ASTUtils.parse(value + " ");
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.xmlLiteral());
            parser.endOfFile();
            return result;
        }
        catch (RecognitionException e) {
            throw ASTUtils.buildSyntaxException(value, parser, e);
        }
    }

    public static LinkedListTree parseRegexpLiteral(String value) {
        AS3Parser parser = ASTUtils.parse(value + " ");
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.regexpLiteral());
            parser.endOfFile();
            return result;
        }
        catch (RecognitionException e) {
            throw ASTUtils.buildSyntaxException(value, parser, e);
        }
    }

    public static LinkedListTree parseQualifiedIdent(String value) {
        AS3Parser parser = ASTUtils.parse(value);
        try {
            LinkedListTree result = AS3FragmentParser.tree(parser.qualifiedIdent());
            parser.endOfFile();
            return result;
        }
        catch (RecognitionException e) {
            throw new SyntaxException("invalid identifier " + ActionScriptFactory.str(value), e);
        }
    }
}

