/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import org.gvnix.flex.addon.metaas.SyntaxException;
import org.gvnix.flex.addon.metaas.dom.ASArg;
import org.gvnix.flex.addon.metaas.dom.ASMethod;
import org.gvnix.flex.addon.metaas.dom.DocComment;
import org.gvnix.flex.addon.metaas.dom.DocTag;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTASMethod;
import org.gvnix.flex.addon.metaas.impl.ASTDocComment;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTScriptElement;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.DocCommentUtils;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTASArg
extends ASTScriptElement
implements ASArg {
    public ASTASArg(LinkedListTree ast) {
        super(ast);
    }

    public String getName() {
        LinkedListTree name = ASTUtils.findChildByType(this.ast, 105);
        if (name == null) {
            if (this.isRest()) {
                return "...";
            }
            throw new IllegalStateException("No parameter name, and not a 'rest' parameter");
        }
        return name.getText();
    }

    public String getType() {
        LinkedListTree type = ASTUtils.findChildByType(this.ast, 18);
        if (type == null) {
            return null;
        }
        return ASTUtils.typeSpecText(type);
    }

    public void setType(String typeName) {
        if (this.isRest()) {
            throw new SyntaxException("type specification not allowed for 'rest' parameters");
        }
        LinkedListTree type = ASTUtils.findChildByType(this.ast, 18);
        if (typeName == null) {
            if (type != null) {
                this.ast.deleteChild(1);
            }
            return;
        }
        LinkedListTree newType = AS3FragmentParser.parseTypeSpec(typeName);
        if (type == null) {
            this.ast.addChildWithTokens(newType);
        } else {
            type.setChildWithTokens(0, newType.getFirstChild());
        }
    }

    public String toString() {
        String type = this.getType();
        if (type == null) {
            return this.getName();
        }
        return this.getName() + ":" + type;
    }

    public void setDefault(String value) {
        if (this.isRest()) {
            throw new SyntaxException("default value not allowed for 'rest' parameters");
        }
        ASTIterator i = new ASTIterator(this.ast);
        LinkedListTree assign = i.search(77);
        if (value == null) {
            if (assign != null) {
                i.remove();
            }
            return;
        }
        LinkedListTree def = AS3FragmentParser.parseParameterDefault(value);
        if (assign == null) {
            this.ast.addChildWithTokens(def);
        } else {
            assign.setChildWithTokens(0, def.getFirstChild());
        }
    }

    public String getDefaultString() {
        LinkedListTree assign = ASTUtils.findChildByType(this.ast, 77);
        if (assign == null) {
            return null;
        }
        return ASTUtils.stringifyNode(assign.getFirstChild());
    }

    public boolean isRest() {
        return this.ast.getFirstChild().getType() == 80;
    }

    public String getDescriptionString() {
        String name;
        DocComment doc = this.getMethod().getDocumentation();
        DocTag tag = DocCommentUtils.findParam(doc, name = this.getName());
        if (tag == null) {
            return null;
        }
        return tag.getBodyString().substring(name.length() + 1);
    }

    public void setDescription(String description) {
        String name;
        ASTDocComment doc = (ASTDocComment)this.getMethod().getDocumentation();
        DocTag tag = DocCommentUtils.findParam(doc, name = this.getName());
        if (tag == null) {
            doc.addParaTag("param", name + " " + description);
        } else {
            tag.setBody(name + " " + description);
        }
    }

    private ASMethod getMethod() {
        return new ASTASMethod(this.ast.getParent().getParent());
    }
}

