/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gvnix.flex.addon.metaas.dom.ASClassType;
import org.gvnix.flex.addon.metaas.dom.ASField;
import org.gvnix.flex.addon.metaas.dom.ASMethod;
import org.gvnix.flex.addon.metaas.dom.Visibility;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTASField;
import org.gvnix.flex.addon.metaas.impl.ASTASMethod;
import org.gvnix.flex.addon.metaas.impl.ASTASType;
import org.gvnix.flex.addon.metaas.impl.ASTBuilder;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.ModifierUtils;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTASClassType
extends ASTASType
implements ASClassType {
    private static final int EXTENDS_INDEX = 3;

    public ASTASClassType(LinkedListTree clazz) {
        super(clazz);
    }

    public ASMethod newMethod(String name, Visibility visibility, String returnType) {
        ASTASMethod method = ASTBuilder.newClassMethod(name, visibility, returnType);
        this.addMethod(method);
        return method;
    }

    public void addMethod(ASTASMethod method) {
        ASTUtils.addChildWithIndentation(this.findTypeBlock(), method.getAST());
    }

    private LinkedListTree findModifiers() {
        return ASTUtils.findChildByType(this.ast, 11);
    }

    public String getSuperclass() {
        LinkedListTree ext = ASTUtils.findChildByType(this.ast, 65);
        if (ext == null) {
            return null;
        }
        return ASTUtils.identText(ext.getFirstChild());
    }

    public boolean isDynamic() {
        return ModifierUtils.isDynamic(this.findModifiers());
    }

    public boolean isFinal() {
        return ModifierUtils.isFinal(this.findModifiers());
    }

    public void setSuperclass(String superclassName) {
        if (superclassName == null) {
            this.removeExtendsClause();
            return;
        }
        LinkedListTree ext = ASTUtils.findChildByType(this.ast, 65);
        LinkedListTree superIdent = AS3FragmentParser.parseIdent(superclassName);
        if (ext == null) {
            ext = ASTUtils.newAST(65, "extends");
            ext.appendToken(TokenBuilder.newSpace());
            LinkedListToken sp = TokenBuilder.newSpace();
            ext.getStartToken().beforeInsert(sp);
            ext.setStartToken(sp);
            this.ast.addChildWithTokens(3, ext);
            ext.addChildWithTokens(superIdent);
            ext.appendToken(TokenBuilder.newSpace());
        } else {
            ext.setChildWithTokens(0, superIdent);
        }
    }

    private void removeExtendsClause() {
        ASTIterator i = new ASTIterator(this.ast);
        while (i.hasNext()) {
            LinkedListTree node = i.next();
            if (node.getType() != 65) continue;
            i.remove();
            break;
        }
    }

    public List getImplementedInterfaces() {
        LinkedList<String> results = new LinkedList<String>();
        LinkedListTree impls = ASTUtils.findChildByType(this.ast, 67);
        if (impls != null) {
            ASTIterator i = new ASTIterator(impls);
            while (i.hasNext()) {
                results.add(ASTUtils.identText(i.next()));
            }
        }
        return Collections.unmodifiableList(results);
    }

    public void addImplementedInterface(String interfaceName) {
        LinkedListTree iface = AS3FragmentParser.parseIdent(interfaceName);
        LinkedListTree impls = ASTUtils.findChildByType(this.ast, 67);
        if (impls == null) {
            ASTIterator i = new ASTIterator(this.ast);
            i.find(5);
            impls = ASTUtils.newAST(67, "implements");
            i.insertBeforeCurrent(impls);
            LinkedListToken sp = TokenBuilder.newSpace();
            impls.getStartToken().beforeInsert(sp);
        } else {
            impls.appendToken(TokenBuilder.newComma());
        }
        impls.appendToken(TokenBuilder.newSpace());
        impls.addChildWithTokens(iface);
    }

    public void removeImplementedInterface(String interfaceName) {
        LinkedListTree impls = ASTUtils.findChildByType(this.ast, 67);
        int count = 0;
        ASTIterator i = new ASTIterator(impls);
        while (i.hasNext()) {
            LinkedListTree iface = i.next();
            String name = ASTUtils.identText(iface);
            if (name.equals(interfaceName)) {
                if (i.hasNext()) {
                    ASTUtils.removeTrailingWhitespaceAndComma(iface.getStopToken());
                } else if (count == 0) {
                    this.ast.deleteChild(this.ast.getIndexOfChild(impls));
                    break;
                }
                i.remove();
                if (!i.hasNext()) break;
                ++count;
                break;
            }
            ++count;
        }
    }

    public ASField newField(String name, Visibility visibility, String type) {
        ASTASField field = ASTBuilder.newField(name, visibility, type);
        this.addField(field);
        return field;
    }

    public void addField(ASTASField field) {
        ASTUtils.addChildWithIndentation(this.findTypeBlock(), field.getAST());
    }

    public ASField getField(String name) {
        ASTIterator i = this.blockIter();
        while (i.hasNext()) {
            ASTASField field;
            LinkedListTree member = i.next();
            if (member.getType() != 7 || !(field = new ASTASField(member)).getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public List getFields() {
        LinkedList<ASTASField> results = new LinkedList<ASTASField>();
        ASTIterator i = this.blockIter();
        while (i.hasNext()) {
            LinkedListTree member = i.next();
            if (member.getType() != 7) continue;
            results.add(new ASTASField(member));
        }
        return Collections.unmodifiableList(results);
    }

    public void removeField(String name) {
        ASTIterator i = this.blockIter();
        while (i.hasNext()) {
            ASTASField field;
            LinkedListTree member = i.next();
            if (member.getType() != 7 || !(field = new ASTASField(member)).getName().equals(name)) continue;
            i.remove();
            return;
        }
    }

    public void setDynamic(boolean value) {
        ModifierUtils.setDynamic(this.findModifiers(), value);
    }

    public void setFinal(boolean value) {
        ModifierUtils.setFinal(this.findModifiers(), value);
    }
}

