/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import org.gvnix.flex.addon.metaas.SyntaxException;
import org.gvnix.flex.addon.metaas.dom.ASField;
import org.gvnix.flex.addon.metaas.dom.Expression;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTASMember;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTScriptElement;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.ExpressionBuilder;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTASField
extends ASTASMember
implements ASField {
    private static int INDEX_DEF = 2;
    private static int INDEX_DECL = 3;

    public ASTASField(LinkedListTree ast) {
        super(ast);
    }

    public String getName() {
        return this.findDecl().getText();
    }

    public void setName(String name) {
        if (name.indexOf(46) != -1) {
            throw new SyntaxException("field name must not contain '.'");
        }
        this.findDecl().getToken().setText(name);
    }

    public void setInitializer(String expr) {
        if (expr == null) {
            this.removeInitializer();
        } else {
            this.setInitAST(AS3FragmentParser.parseExpr(expr));
        }
    }

    public void setInitializer(Expression expr) {
        if (expr == null) {
            this.removeInitializer();
        } else {
            this.setInitAST(ASTScriptElement.ast(expr));
        }
    }

    private void setInitAST(LinkedListTree exp) {
        LinkedListTree decl = this.findDecl();
        LinkedListTree init = ASTUtils.findChildByType(decl, 77);
        if (init == null) {
            init = ASTUtils.newAST(77, "=");
            decl.addChildWithTokens(init);
        } else {
            init.deleteChild(0);
        }
        init.addChildWithTokens(exp);
    }

    private void removeInitializer() {
        LinkedListTree decl = this.findDecl();
        ASTIterator i = new ASTIterator(decl);
        if (i.search(77) != null) {
            i.remove();
        }
    }

    public Expression getInitializer() {
        LinkedListTree decl = this.findDecl();
        LinkedListTree init = ASTUtils.findChildByType(decl, 77);
        if (init == null) {
            return null;
        }
        return ExpressionBuilder.build(init.getFirstChild());
    }

    public boolean isConst() {
        return this.ast.getChild(INDEX_DEF).getType() == 76;
    }

    public void setConst(boolean isConst) {
        if (this.isConst() == isConst) {
            return;
        }
        LinkedListToken node = isConst ? TokenBuilder.newConst() : TokenBuilder.newVar();
        this.ast.setChildWithTokens(INDEX_DEF, ASTUtils.newAST(node));
    }

    public String getType() {
        LinkedListTree decl = this.findDecl();
        LinkedListTree typeSpec = decl.getFirstChild();
        if (typeSpec == null) {
            return null;
        }
        return ASTUtils.typeSpecText(typeSpec);
    }

    private LinkedListTree findDecl() {
        return (LinkedListTree)this.ast.getChild(INDEX_DECL);
    }

    public void setType(String typeName) {
        LinkedListTree decl = this.findDecl();
        LinkedListTree typeSpec = decl.getFirstChild();
        if (typeSpec == null) {
            if (typeName != null) {
                decl.addChildWithTokens(AS3FragmentParser.parseTypeSpec(typeName));
            }
        } else if (typeName == null) {
            decl.deleteChild(0);
        } else {
            decl.setChildWithTokens(0, AS3FragmentParser.parseTypeSpec(typeName));
        }
    }
}

