/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import org.gvnix.flex.addon.metaas.dom.ASForStatement;
import org.gvnix.flex.addon.metaas.dom.Expression;
import org.gvnix.flex.addon.metaas.dom.ScriptElement;
import org.gvnix.flex.addon.metaas.dom.StatementContainer;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTASDeclarationStatement;
import org.gvnix.flex.addon.metaas.impl.ASTScriptElement;
import org.gvnix.flex.addon.metaas.impl.ASTStatementList;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.ContainerDelegate;
import org.gvnix.flex.addon.metaas.impl.ExpressionBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTASForStatement
extends ContainerDelegate
implements ASForStatement {
    private static final int INDEX_INIT = 0;
    private static final int INDEX_CONDITION = 1;
    private static final int INDEX_UPDATE = 2;
    private static final int INDEX_STATEMENT = 3;

    public ASTASForStatement(LinkedListTree ast) {
        super(ast);
    }

    public String getInitString() {
        if (!this.hasInit()) {
            return null;
        }
        return ASTUtils.stringifyNode(this.findInit());
    }

    public ScriptElement getInit() {
        if (!this.hasInit()) {
            return null;
        }
        LinkedListTree init = this.findInit().getFirstChild();
        switch (init.getType()) {
            case 75: 
            case 76: {
                return new ASTASDeclarationStatement(init);
            }
        }
        return ExpressionBuilder.build(init);
    }

    public String getConditionString() {
        if (!this.hasCondition()) {
            return null;
        }
        return ASTUtils.stringifyNode(this.findCondition().getFirstChild());
    }

    public Expression getCondition() {
        if (!this.hasCondition()) {
            return null;
        }
        return ExpressionBuilder.build(this.findCondition().getFirstChild());
    }

    public String getUpdateString() {
        if (!this.hasUpdate()) {
            return null;
        }
        return ASTUtils.stringifyNode(this.findUpdate().getFirstChild());
    }

    public Expression getUpdate() {
        if (!this.hasUpdate()) {
            return null;
        }
        return ExpressionBuilder.build(this.findUpdate().getFirstChild());
    }

    private boolean hasCondition() {
        return this.findCondition().getChildCount() > 0;
    }

    private boolean hasInit() {
        return this.findInit().getChildCount() > 0;
    }

    private boolean hasUpdate() {
        return this.findUpdate().getChildCount() > 0;
    }

    private LinkedListTree getChild(int index) {
        return (LinkedListTree)this.ast.getChild(index);
    }

    protected StatementContainer getStatementContainer() {
        return new ASTStatementList(this.getChild(3));
    }

    private LinkedListTree findInit() {
        return this.getChild(0);
    }

    private LinkedListTree findCondition() {
        return this.getChild(1);
    }

    private LinkedListTree findUpdate() {
        return this.getChild(2);
    }

    public void setCondition(String expr) {
        if (expr == null) {
            this.deleteAnyChild(this.findCondition());
        } else {
            LinkedListTree cond = AS3FragmentParser.parseForCond(expr);
            this.ast.setChildWithTokens(1, cond);
        }
    }

    public void setCondition(Expression expr) {
        LinkedListTree cond = this.findCondition();
        if (expr == null) {
            this.deleteAnyChild(cond);
        } else {
            ASTASForStatement.setFirstChild(cond, ASTScriptElement.ast(expr));
        }
    }

    public void setInit(String expr) {
        if (expr == null) {
            this.deleteAnyChild(this.findInit());
        } else {
            LinkedListTree init = AS3FragmentParser.parseForInit(expr);
            this.ast.setChildWithTokens(0, init);
        }
    }

    public void setUpdate(String expr) {
        if (expr == null) {
            this.deleteAnyChild(this.findUpdate());
        } else {
            LinkedListTree update = AS3FragmentParser.parseForIter(expr);
            this.ast.setChildWithTokens(2, update);
        }
    }

    public void setUpdate(Expression expr) {
        if (expr == null) {
            this.deleteAnyChild(this.findUpdate());
        } else {
            ASTASForStatement.setFirstChild(this.findUpdate(), ASTScriptElement.ast(expr));
        }
    }

    private void deleteAnyChild(LinkedListTree tree) {
        if (tree.getChildCount() > 0) {
            tree.deleteChild(0);
        }
    }

    private static void setFirstChild(LinkedListTree parent, LinkedListTree child) {
        if (parent.getChildCount() == 0) {
            parent.addChildWithTokens(child);
        } else {
            parent.setChildWithTokens(0, child);
        }
    }
}

