/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import org.gvnix.flex.addon.metaas.SyntaxException;
import org.gvnix.flex.addon.metaas.dom.ASBlock;
import org.gvnix.flex.addon.metaas.dom.ASIfStatement;
import org.gvnix.flex.addon.metaas.dom.Expression;
import org.gvnix.flex.addon.metaas.dom.Statement;
import org.gvnix.flex.addon.metaas.dom.StatementContainer;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTBuilder;
import org.gvnix.flex.addon.metaas.impl.ASTExpression;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTStatementList;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.ContainerDelegate;
import org.gvnix.flex.addon.metaas.impl.ExpressionBuilder;
import org.gvnix.flex.addon.metaas.impl.StatementBuilder;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTASIfStatement
extends ContainerDelegate
implements ASIfStatement {
    private static final int THEN_INDEX = 1;
    private static final int ELSE_INDEX = 2;

    public ASTASIfStatement(LinkedListTree ast) {
        super(ast);
        ASTUtils.assertAS3TokenTypeIs(82, ast.getType());
    }

    protected StatementContainer getStatementContainer() {
        LinkedListTree child = this.thenClause();
        if (19 != child.getType()) {
            throw new SyntaxException("statement is not a block");
        }
        return new ASTStatementList(child);
    }

    private LinkedListTree thenClause() {
        return (LinkedListTree)this.ast.getChild(1);
    }

    public Statement getThenStatement() {
        return StatementBuilder.build(this.thenClause());
    }

    public ASBlock getElse() {
        return this.elseBlock();
    }

    private LinkedListTree elseClause() {
        return (LinkedListTree)this.ast.getChild(2);
    }

    public ASBlock elseBlock() {
        LinkedListTree elseClause = this.elseClause();
        if (elseClause == null) {
            String indent = ASTUtils.findIndent(this.ast);
            elseClause = ASTUtils.newAST(83, "else");
            this.ast.appendToken(TokenBuilder.newSpace());
            this.ast.addChildWithTokens(elseClause);
            elseClause.appendToken(TokenBuilder.newSpace());
            LinkedListTree block = ASTBuilder.newBlock();
            elseClause.addChildWithTokens(block);
            ASTUtils.increaseIndentAfterFirstLine(block, indent);
            return new ASTStatementList(block);
        }
        Statement stmt = StatementBuilder.build(elseClause.getFirstChild());
        if (!(stmt instanceof ASBlock)) {
            throw new SyntaxException("Expected a block, got " + ASTUtils.tokenName(elseClause.getFirstChild()));
        }
        return (ASBlock)stmt;
    }

    public Statement getElseStatement() {
        LinkedListTree elseClause = this.elseClause();
        if (elseClause == null) {
            return null;
        }
        return StatementBuilder.build(elseClause.getFirstChild());
    }

    public void setThen(ASBlock block) {
        LinkedListTree theBlock = ((ASTStatementList)block).getAST();
        ASTIterator i = new ASTIterator(this.ast);
        i.next();
        i.next();
        i.replace(theBlock);
        String indent = ASTUtils.findIndent(this.ast);
        ASTUtils.increaseIndentAfterFirstLine(theBlock, indent);
    }

    public void setThenStatement(Statement then) {
        LinkedListTree thenAST = ((ASTStatementList)then).getAST();
        this.ast.setChildWithTokens(1, thenAST);
        if (19 == thenAST.getType()) {
            String indent = ASTUtils.findIndent(this.ast);
            ASTUtils.increaseIndentAfterFirstLine(thenAST, indent);
        }
    }

    private LinkedListTree condition() {
        return this.ast.getFirstChild();
    }

    public String getConditionString() {
        return ASTUtils.stringifyNode(this.condition().getFirstChild());
    }

    public void setCondition(String expr) {
        LinkedListTree cond = AS3FragmentParser.parseCondition(expr);
        this.ast.setChildWithTokens(0, cond);
    }

    public Expression getCondition() {
        return ExpressionBuilder.build(this.condition().getFirstChild());
    }

    public void setCondition(Expression expr) {
        LinkedListTree condExpr = ((ASTExpression)expr).getAST();
        this.condition().setChildWithTokens(0, condExpr);
    }
}

