/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gvnix.flex.addon.metaas.dom.ASInterfaceType;
import org.gvnix.flex.addon.metaas.dom.ASMethod;
import org.gvnix.flex.addon.metaas.dom.Visibility;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTASMethod;
import org.gvnix.flex.addon.metaas.impl.ASTASType;
import org.gvnix.flex.addon.metaas.impl.ASTBuilder;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTASInterfaceType
extends ASTASType
implements ASInterfaceType {
    private static final int EXTENDS_INDEX = 3;

    public ASTASInterfaceType(LinkedListTree ast) {
        super(ast);
    }

    public List getSuperInterfaces() {
        LinkedList<String> results = new LinkedList<String>();
        LinkedListTree impls = ASTUtils.findChildByType(this.ast, 65);
        if (impls != null) {
            ASTIterator i = new ASTIterator(impls);
            while (i.hasNext()) {
                results.add(ASTUtils.identText(i.next()));
            }
        }
        return Collections.unmodifiableList(results);
    }

    public void addSuperInterface(String interfaceName) {
        LinkedListTree iface = AS3FragmentParser.parseIdent(interfaceName);
        LinkedListTree ext = ASTUtils.findChildByType(this.ast, 65);
        if (ext == null) {
            ext = ASTUtils.newAST(65, "extends");
            ext.appendToken(TokenBuilder.newSpace());
            LinkedListToken sp = TokenBuilder.newSpace();
            ext.getStartToken().beforeInsert(sp);
            ext.setStartToken(sp);
            this.ast.addChildWithTokens(3, ext);
        } else {
            ext.appendToken(TokenBuilder.newComma());
        }
        ext.appendToken(TokenBuilder.newSpace());
        ext.addChildWithTokens(iface);
    }

    public void removeSuperInterface(String interfaceName) {
        LinkedListTree impls = ASTUtils.findChildByType(this.ast, 65);
        int count = 0;
        ASTIterator i = new ASTIterator(impls);
        while (i.hasNext()) {
            LinkedListTree iface = i.next();
            String name = ASTUtils.identText(iface);
            if (name.equals(interfaceName)) {
                if (i.hasNext()) {
                    ASTUtils.removeTrailingWhitespaceAndComma(iface.getStopToken());
                } else if (count == 0) {
                    this.ast.deleteChild(this.ast.getIndexOfChild(impls));
                    break;
                }
                i.remove();
                if (!i.hasNext()) break;
                ++count;
                break;
            }
            ++count;
        }
    }

    public ASMethod newMethod(String name, Visibility visibility, String returnType) {
        ASTASMethod meth = ASTBuilder.newInterfaceMethod(name, visibility, returnType);
        this.addMethod(meth);
        return meth;
    }

    public void addMethod(ASTASMethod meth) {
        ASTUtils.addChildWithIndentation(this.findTypeBlock(), meth.getAST());
    }
}

