/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.List;
import org.gvnix.flex.addon.metaas.SyntaxException;
import org.gvnix.flex.addon.metaas.dom.ASArg;
import org.gvnix.flex.addon.metaas.dom.ASBreakStatement;
import org.gvnix.flex.addon.metaas.dom.ASContinueStatement;
import org.gvnix.flex.addon.metaas.dom.ASDeclarationStatement;
import org.gvnix.flex.addon.metaas.dom.ASDefaultXMLNamespaceStatement;
import org.gvnix.flex.addon.metaas.dom.ASDoWhileStatement;
import org.gvnix.flex.addon.metaas.dom.ASExpressionStatement;
import org.gvnix.flex.addon.metaas.dom.ASForEachInStatement;
import org.gvnix.flex.addon.metaas.dom.ASForInStatement;
import org.gvnix.flex.addon.metaas.dom.ASForStatement;
import org.gvnix.flex.addon.metaas.dom.ASIfStatement;
import org.gvnix.flex.addon.metaas.dom.ASMethod;
import org.gvnix.flex.addon.metaas.dom.ASReturnStatement;
import org.gvnix.flex.addon.metaas.dom.ASSuperStatement;
import org.gvnix.flex.addon.metaas.dom.ASSwitchStatement;
import org.gvnix.flex.addon.metaas.dom.ASThrowStatement;
import org.gvnix.flex.addon.metaas.dom.ASTryStatement;
import org.gvnix.flex.addon.metaas.dom.ASWhileStatement;
import org.gvnix.flex.addon.metaas.dom.ASWithStatement;
import org.gvnix.flex.addon.metaas.dom.DocComment;
import org.gvnix.flex.addon.metaas.dom.DocTag;
import org.gvnix.flex.addon.metaas.dom.Expression;
import org.gvnix.flex.addon.metaas.dom.Statement;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTASMember;
import org.gvnix.flex.addon.metaas.impl.ASTFunctionCommon;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTStatementList;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTASMethod
extends ASTASMember
implements ASMethod {
    private ASTStatementList stmtList;
    private ASTFunctionCommon funcMixin;

    public ASTASMethod(LinkedListTree ast) {
        super(ast);
        LinkedListTree block = ASTUtils.findChildByType(ast, 19);
        if (block != null) {
            this.stmtList = new ASTStatementList(block);
        }
        this.funcMixin = new ASTFunctionCommon(ast);
    }

    public String getName() {
        ASTIterator i = new ASTIterator(this.ast);
        LinkedListTree name = i.find(105);
        return name.getText();
    }

    public void setName(String name) {
        if (name.indexOf(46) != -1) {
            throw new SyntaxException("Method name must not contain '.'");
        }
        if (name.indexOf(58) != -1) {
            throw new SyntaxException("Method name must not contain ':'");
        }
        ASTIterator i = new ASTIterator(this.ast);
        i.find(105);
        LinkedListTree newName = AS3FragmentParser.parseIdent(name).getFirstChild();
        i.replace(newName);
    }

    public List getArgs() {
        return this.funcMixin.getArgs();
    }

    public String getType() {
        return this.funcMixin.getType();
    }

    public void setType(String typeName) {
        this.funcMixin.setType(typeName);
    }

    public Statement addStmt(String statement) {
        return this.stmtList().addStmt(statement);
    }

    public ASExpressionStatement newExprStmt(String expr) {
        return this.stmtList().newExprStmt(expr);
    }

    public ASExpressionStatement newExprStmt(Expression expr) {
        return this.stmtList().newExprStmt(expr);
    }

    public ASArg addParam(String name, String type) {
        return this.funcMixin.addParam(name, type);
    }

    public ASArg addRestParam(String name) {
        return this.funcMixin.addRestParam(name);
    }

    public ASArg removeParam(String name) {
        return this.funcMixin.removeParam(name);
    }

    public void addComment(String text) {
        this.stmtList().addComment(text);
    }

    public ASMethod.AccessorRole getAccessorRole() {
        LinkedListTree decl = ASTUtils.findChildByType(this.ast, 13);
        LinkedListTree roleNode = decl.getFirstChild();
        if (roleNode == null) {
            return ASMethod.AccessorRole.NORMAL_METHOD;
        }
        switch (roleNode.getType()) {
            case 71: {
                return ASMethod.AccessorRole.GETTER;
            }
            case 72: {
                return ASMethod.AccessorRole.SETTER;
            }
        }
        throw new SyntaxException("expected GET or SET; got " + roleNode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAccessorRole(ASMethod.AccessorRole role) {
        LinkedListTree decl = ASTUtils.findChildByType(this.ast, 13);
        LinkedListTree roleNode = decl.getFirstChild();
        if (roleNode != null) {
            if (role == ASMethod.AccessorRole.NORMAL_METHOD) {
                decl.deleteChild(0);
                return;
            } else if (role == ASMethod.AccessorRole.GETTER) {
                roleNode.token.setType(71);
                roleNode.token.setText("get");
                return;
            } else {
                if (role != ASMethod.AccessorRole.SETTER) throw new IllegalArgumentException("bad role: " + role);
                roleNode.token.setType(72);
                roleNode.token.setText("set");
            }
            return;
        } else if (role == ASMethod.AccessorRole.GETTER) {
            LinkedListTree node = ASTUtils.newAST(71, "get");
            node.appendToken(TokenBuilder.newSpace());
            decl.addChildWithTokens(node);
            return;
        } else {
            if (role != ASMethod.AccessorRole.SETTER) return;
            LinkedListTree node = ASTUtils.newAST(72, "set");
            node.appendToken(TokenBuilder.newSpace());
            decl.addChildWithTokens(node);
        }
    }

    public ASIfStatement newIf(String condition) {
        return this.stmtList().newIf(condition);
    }

    public ASIfStatement newIf(Expression condition) {
        return this.stmtList().newIf(condition);
    }

    public ASForStatement newFor(String init, String condition, String update) {
        return this.stmtList().newFor(init, condition, update);
    }

    public ASForStatement newFor(Expression init, Expression condition, Expression update) {
        return this.stmtList().newFor(init, condition, update);
    }

    public ASForInStatement newForIn(String init, String list) {
        return this.stmtList().newForIn(init, list);
    }

    public ASForInStatement newForIn(Expression init, Expression list) {
        return this.stmtList().newForIn(init, list);
    }

    public ASForEachInStatement newForEachIn(String init, String list) {
        return this.stmtList().newForEachIn(init, list);
    }

    public ASForEachInStatement newForEachIn(Expression init, Expression list) {
        return this.stmtList().newForEachIn(init, list);
    }

    public ASWhileStatement newWhile(String condition) {
        return this.stmtList().newWhile(condition);
    }

    public ASWhileStatement newWhile(Expression condition) {
        return this.stmtList().newWhile(condition);
    }

    public ASDoWhileStatement newDoWhile(String condition) {
        return this.stmtList().newDoWhile(condition);
    }

    public ASDoWhileStatement newDoWhile(Expression condition) {
        return this.stmtList().newDoWhile(condition);
    }

    public ASSwitchStatement newSwitch(String condition) {
        return this.stmtList().newSwitch(condition);
    }

    public ASSwitchStatement newSwitch(Expression condition) {
        return this.stmtList().newSwitch(condition);
    }

    public ASWithStatement newWith(String expr) {
        return this.stmtList().newWith(expr);
    }

    public ASWithStatement newWith(Expression expr) {
        return this.stmtList().newWith(expr);
    }

    public ASDeclarationStatement newDeclaration(String assignment) {
        return this.stmtList().newDeclaration(assignment);
    }

    public ASDeclarationStatement newDeclaration(Expression assignment) {
        return this.stmtList().newDeclaration(assignment);
    }

    public ASReturnStatement newReturn(String expr) {
        return this.stmtList().newReturn(expr);
    }

    public ASReturnStatement newReturn(Expression expr) {
        return this.stmtList().newReturn(expr);
    }

    public ASReturnStatement newReturn() {
        return this.stmtList().newReturn();
    }

    public ASSuperStatement newSuper(List args) {
        return this.stmtList().newSuper(args);
    }

    public ASBreakStatement newBreak() {
        return this.stmtList().newBreak();
    }

    public ASTryStatement newTryCatch(String var, String type) {
        return this.stmtList().newTryCatch(var, type);
    }

    public ASTryStatement newTryFinally() {
        return this.stmtList().newTryFinally();
    }

    public ASContinueStatement newContinue() {
        return this.stmtList().newContinue();
    }

    public ASThrowStatement newThrow(Expression t) {
        return this.stmtList().newThrow(t);
    }

    public ASDefaultXMLNamespaceStatement newDefaultXMLNamespace(String namespace) {
        return this.stmtList().newDefaultXMLNamespace(namespace);
    }

    public boolean containsCode() {
        return this.stmtList().containsCode();
    }

    public List getStatementList() {
        return this.stmtList().getStatementList();
    }

    public String getReturnDescriptionString() {
        DocComment doc = this.getDocumentation();
        DocTag ret = doc.findFirstTag("return");
        if (ret == null) {
            return null;
        }
        return ret.getBodyString();
    }

    public void setReturnDescription(String description) {
        DocComment doc = this.getDocumentation();
        DocTag ret = doc.findFirstTag("return");
        if (ret == null) {
            if (description != null) {
                doc.addParaTag("return", description);
            }
        } else if (description == null) {
            doc.delete(ret);
        } else {
            ret.setBody(description);
        }
    }

    private ASTStatementList stmtList() {
        if (this.stmtList == null) {
            throw new SyntaxException("Interface methods don't have a body");
        }
        return this.stmtList;
    }
}

