/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gvnix.flex.addon.metaas.dom.ASObjectLiteral;
import org.gvnix.flex.addon.metaas.dom.Expression;
import org.gvnix.flex.addon.metaas.impl.ASTBuilder;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTLiteral;
import org.gvnix.flex.addon.metaas.impl.ASTScriptElement;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.ExpressionBuilder;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTASObjectLiteral
extends ASTLiteral
implements ASObjectLiteral {
    public ASTASObjectLiteral(LinkedListTree ast) {
        super(ast);
    }

    public List getFields() {
        ArrayList<ASTField> fields = new ArrayList<ASTField>();
        ASTIterator i = new ASTIterator(this.ast);
        while (i.hasNext()) {
            fields.add(this.buildField(i.next()));
        }
        return Collections.unmodifiableList(fields);
    }

    private ASTField buildField(LinkedListTree field) {
        ASTUtils.assertAS3TokenTypeIs(40, field.getType());
        return new ASTField(field);
    }

    public ASObjectLiteral.Field newField(String name, Expression value) {
        LinkedListTree field = ASTBuilder.newObjectField(name, ASTScriptElement.ast(value));
        String indent = ASTUtils.findIndent(this.ast) + "\t";
        ASTUtils.increaseIndent(field, indent);
        if (this.ast.getChildCount() > 0) {
            this.ast.appendToken(TokenBuilder.newComma());
        }
        this.ast.appendToken(TokenBuilder.newNewline());
        this.ast.addChildWithTokens(field);
        return new ASTField(field);
    }

    public static class ASTField
    implements ASObjectLiteral.Field {
        private LinkedListTree ast;

        public ASTField(LinkedListTree ast) {
            this.ast = ast;
        }

        public String getName() {
            return this.ast.getFirstChild().getText();
        }

        public Expression getValue() {
            return ExpressionBuilder.build(this.ast.getLastChild());
        }
    }
}

