/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.ArrayList;
import java.util.List;
import org.gvnix.flex.addon.metaas.dom.ASPackage;
import org.gvnix.flex.addon.metaas.dom.ASType;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTASClassType;
import org.gvnix.flex.addon.metaas.impl.ASTASInterfaceType;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTScriptElement;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTASPackage
extends ASTScriptElement
implements ASPackage {
    public ASTASPackage(LinkedListTree ast) {
        super(ast);
    }

    public String getName() {
        LinkedListTree first = this.ast.getFirstChild();
        if (first.getType() == 48) {
            return ASTUtils.identText(first);
        }
        return null;
    }

    public void setName(String name) {
        ASTIterator i = new ASTIterator(this.ast);
        LinkedListTree first = i.next();
        if (name == null && first.getType() == 48) {
            i.remove();
            return;
        }
        LinkedListTree newName = AS3FragmentParser.parseIdent(name);
        if (first.getType() == 48) {
            i.replace(newName);
        } else {
            i.insertBeforeCurrent(newName);
            newName.appendToken(TokenBuilder.newSpace());
        }
    }

    public void addImport(String name) {
        LinkedListTree imp = AS3FragmentParser.parseImport(name);
        int pos = this.findNextImportInsertionPoint();
        ASTUtils.addChildWithIndentation(this.getPkgBlockNode(), pos, imp);
    }

    private int findNextImportInsertionPoint() {
        ASTIterator i = this.getPkgBlockIter();
        int index = 0;
        while (i.search(62) != null) {
            index = i.getCurrentIndex() + 1;
        }
        return index;
    }

    public List findImports() {
        LinkedListTree imp;
        ASTIterator i = this.getPkgBlockIter();
        ArrayList<String> result = new ArrayList<String>();
        while ((imp = i.search(62)) != null) {
            result.add(this.importText(imp));
        }
        return result;
    }

    private String importText(LinkedListTree imp) {
        return ASTUtils.identStarText(imp.getFirstChild());
    }

    public boolean removeImport(String name) {
        LinkedListTree imp;
        ASTIterator i = this.getPkgBlockIter();
        while ((imp = i.search(62)) != null) {
            if (!this.importText(imp).equals(name)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public ASType getType() {
        LinkedListTree block = ASTUtils.findChildByType(this.ast, 19);
        LinkedListTree type = ASTUtils.findChildByType(block, 14);
        if (type != null) {
            return new ASTASClassType(type);
        }
        type = ASTUtils.findChildByType(block, 15);
        if (type != null) {
            return new ASTASInterfaceType(type);
        }
        return null;
    }

    private LinkedListTree getPkgBlockNode() {
        return ASTUtils.findChildByType(this.ast, 19);
    }

    private ASTIterator getPkgBlockIter() {
        return new ASTIterator(this.getPkgBlockNode());
    }
}

