/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import org.gvnix.flex.addon.metaas.SyntaxException;
import org.gvnix.flex.addon.metaas.dom.ASWhileStatement;
import org.gvnix.flex.addon.metaas.dom.Expression;
import org.gvnix.flex.addon.metaas.dom.Statement;
import org.gvnix.flex.addon.metaas.dom.StatementContainer;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTScriptElement;
import org.gvnix.flex.addon.metaas.impl.ASTStatementList;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.ContainerDelegate;
import org.gvnix.flex.addon.metaas.impl.ExpressionBuilder;
import org.gvnix.flex.addon.metaas.impl.StatementBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTASWhileStatement
extends ContainerDelegate
implements ASWhileStatement {
    private static final int INDEX_CONDITION = 0;
    private static final int INDEX_STATEMENT = 1;

    public ASTASWhileStatement(LinkedListTree ast) {
        super(ast);
        ASTUtils.assertAS3TokenTypeIs(98, ast.getType());
    }

    private LinkedListTree getChild(int index) {
        return (LinkedListTree)this.ast.getChild(index);
    }

    protected StatementContainer getStatementContainer() {
        LinkedListTree stmt = this.stmt();
        if (stmt.getType() != 19) {
            throw new SyntaxException("Loop body is not a block");
        }
        return new ASTStatementList(stmt);
    }

    private LinkedListTree stmt() {
        return this.getChild(1);
    }

    public String getConditionString() {
        return ASTUtils.stringifyNode(this.condition().getFirstChild());
    }

    public Expression getCondition() {
        return ExpressionBuilder.build(this.condition().getFirstChild());
    }

    public void setCondition(String expr) {
        LinkedListTree cond = AS3FragmentParser.parseCondition(expr);
        this.ast.setChildWithTokens(0, cond);
    }

    public void setCondition(Expression expr) {
        this.condition().setChildWithTokens(0, ASTScriptElement.ast(expr));
    }

    private LinkedListTree condition() {
        return this.ast.getFirstChild();
    }

    public Statement getBody() {
        return StatementBuilder.build(this.stmt());
    }
}

