/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvnix.flex.addon.metaas.ActionScriptFactory;
import org.gvnix.flex.addon.metaas.ActionScriptProject;
import org.gvnix.flex.addon.metaas.dom.ASCompilationUnit;
import org.gvnix.flex.addon.metaas.impl.AutoImporter;
import org.gvnix.flex.addon.metaas.impl.ResourceRoot;
import org.gvnix.flex.addon.metaas.impl.SWCResourceRoot;
import org.gvnix.flex.addon.metaas.impl.SourceFolderResourceRoot;

public class ASTActionScriptProject
implements ActionScriptProject {
    private List classpath = new ArrayList();
    private Map resourceRoots = new HashMap();
    private List compilationUnits = new ArrayList();
    private String outputLocation;
    private ActionScriptFactory fact;

    public ASTActionScriptProject(ActionScriptFactory fact) {
        this.fact = fact;
    }

    public void addClasspathEntry(String classpathEntry) {
        ResourceRoot root = this.resourceRootFor(classpathEntry);
        this.resourceRoots.put(classpathEntry, root);
        this.classpath.add(classpathEntry);
    }

    private ResourceRoot resourceRootFor(String classpathEntry) {
        File path = new File(classpathEntry);
        if (path.isDirectory()) {
            return new SourceFolderResourceRoot(path);
        }
        if (classpathEntry.endsWith(".swc")) {
            try {
                return new SWCResourceRoot(classpathEntry);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("Unknown resorce type: " + classpathEntry);
    }

    public Collection getResourceRoots() {
        return this.resourceRoots.values();
    }

    public void removeClasspathEntry(String classpathEntry) {
        this.classpath.remove(classpathEntry);
        this.resourceRoots.remove(classpathEntry);
    }

    public List getClasspathEntries() {
        return Collections.unmodifiableList(this.classpath);
    }

    public void addCompilationUnit(ASCompilationUnit cu) {
        this.compilationUnits.add(cu);
    }

    public void removeCompilationUnit(ASCompilationUnit cu) {
        this.compilationUnits.remove(cu);
    }

    public ASCompilationUnit newClass(String qualifiedClassName) {
        ASCompilationUnit cu = this.fact.newClass(qualifiedClassName);
        this.addCompilationUnit(cu);
        return cu;
    }

    public ASCompilationUnit newInterface(String qualifiedInterfaceName) {
        ASCompilationUnit cu = this.fact.newInterface(qualifiedInterfaceName);
        this.addCompilationUnit(cu);
        return cu;
    }

    public List getCompilationUnits() {
        return Collections.unmodifiableList(this.compilationUnits);
    }

    public String getOutputLocation() {
        return this.outputLocation;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public void writeAll() throws IOException {
        Iterator i = this.compilationUnits.iterator();
        while (i.hasNext()) {
            ASCompilationUnit cu = (ASCompilationUnit)i.next();
            this.write(this.outputLocation, cu);
        }
    }

    public void performAutoImport() {
        AutoImporter autoImporter = new AutoImporter();
        autoImporter.performAutoImport(this);
    }

    private void write(String destinationDir, ASCompilationUnit cu) throws IOException {
        String filename = ASTActionScriptProject.filenameFor(cu);
        File destFile = new File(destinationDir, filename);
        destFile.getParentFile().mkdirs();
        FileOutputStream os = new FileOutputStream(destFile);
        OutputStreamWriter out = new OutputStreamWriter(os);
        this.fact.newWriter().write(out, cu);
        out.close();
    }

    private static String filenameFor(ASCompilationUnit unit) {
        String pkg = unit.getPackageName();
        String name = pkg == null || pkg.equals("") ? unit.getType().getName() : unit.getPackageName() + "." + unit.getType().getName();
        return name.replace('.', File.separatorChar) + ".as";
    }
}

