/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.List;
import org.gvnix.flex.addon.metaas.ActionScriptFactory;
import org.gvnix.flex.addon.metaas.SyntaxException;
import org.gvnix.flex.addon.metaas.dom.ASAssignmentExpression;
import org.gvnix.flex.addon.metaas.dom.ASBinaryExpression;
import org.gvnix.flex.addon.metaas.dom.ASCompilationUnit;
import org.gvnix.flex.addon.metaas.dom.Expression;
import org.gvnix.flex.addon.metaas.dom.Visibility;
import org.gvnix.flex.addon.metaas.impl.AS3ASTCompilationUnit;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTASAssignmentExpression;
import org.gvnix.flex.addon.metaas.impl.ASTASBinaryExpression;
import org.gvnix.flex.addon.metaas.impl.ASTASField;
import org.gvnix.flex.addon.metaas.impl.ASTASMethod;
import org.gvnix.flex.addon.metaas.impl.ASTExpression;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.ArgumentUtils;
import org.gvnix.flex.addon.metaas.impl.ModifierUtils;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTBuilder {
    private ASTBuilder() {
    }

    public static LinkedListTree newExprStmt(LinkedListTree expr) {
        LinkedListTree exprStmt = ASTUtils.newImaginaryAST(23);
        exprStmt.addChildWithTokens(expr);
        exprStmt.appendToken(TokenBuilder.newSemi());
        return exprStmt;
    }

    public static AS3ASTCompilationUnit synthesizeClass(String qualifiedName) {
        LinkedListTree unit = ASTUtils.newImaginaryAST(4);
        LinkedListTree pkg = ASTUtils.newAST(58, "package");
        pkg.appendToken(TokenBuilder.newSpace());
        unit.addChildWithTokens(pkg);
        pkg.appendToken(TokenBuilder.newSpace());
        String packageName = ASTBuilder.packageNameFrom(qualifiedName);
        if (packageName != null) {
            pkg.addChildWithTokens(AS3FragmentParser.parseIdent(packageName));
        }
        LinkedListTree packageBlock = ASTBuilder.newBlock();
        pkg.addChildWithTokens(packageBlock);
        String className = ASTBuilder.typeNameFrom(qualifiedName);
        LinkedListTree clazz = ASTBuilder.synthesizeAS3Class(className);
        ASTUtils.addChildWithIndentation(packageBlock, clazz);
        return new AS3ASTCompilationUnit(unit);
    }

    public static ASCompilationUnit synthesizeInterface(String qualifiedName) {
        LinkedListTree unit = ASTUtils.newImaginaryAST(4);
        LinkedListTree pkg = ASTUtils.newAST(58, "package");
        unit.addChildWithTokens(pkg);
        pkg.appendToken(TokenBuilder.newSpace());
        String packageName = ASTBuilder.packageNameFrom(qualifiedName);
        if (packageName != null) {
            pkg.addChildWithTokens(AS3FragmentParser.parseIdent(packageName));
        }
        LinkedListTree packageBlock = ASTBuilder.newBlock();
        pkg.addChildWithTokens(packageBlock);
        LinkedListTree iface = ASTBuilder.synthesizeAS3Interface(qualifiedName);
        ASTUtils.addChildWithIndentation(packageBlock, iface);
        return new AS3ASTCompilationUnit(unit);
    }

    private static LinkedListTree synthesizeAS3Interface(String qualifiedName) {
        LinkedListTree iface = ASTUtils.newImaginaryAST(15);
        LinkedListTree modifiers = ASTUtils.newImaginaryAST(11);
        iface.addChildWithTokens(modifiers);
        modifiers.addChildWithTokens(ASTUtils.newAST(106, "public"));
        modifiers.appendToken(TokenBuilder.newSpace());
        iface.appendToken(TokenBuilder.newInterface());
        iface.appendToken(TokenBuilder.newSpace());
        iface.addChildWithTokens(ASTUtils.newAST(105, ASTBuilder.typeNameFrom(qualifiedName)));
        iface.appendToken(TokenBuilder.newSpace());
        iface.addChildWithTokens(ASTBuilder.newTypeBlock());
        LinkedListTree annos = ASTUtils.newPlaceholderAST(8);
        iface.addChildWithTokens(0, annos);
        return iface;
    }

    private static String typeNameFrom(String qualifiedName) {
        int p = qualifiedName.lastIndexOf(46);
        if (p == -1) {
            return qualifiedName;
        }
        return qualifiedName.substring(p + 1);
    }

    private static LinkedListTree synthesizeAS3Class(String className) {
        LinkedListTree clazz = ASTUtils.newImaginaryAST(14);
        LinkedListTree modifiers = ASTUtils.newImaginaryAST(11);
        clazz.addChildWithTokens(modifiers);
        LinkedListTree modPublic = ASTUtils.newAST(106, "public");
        modifiers.addChildWithTokens(modPublic);
        modifiers.appendToken(TokenBuilder.newSpace());
        clazz.appendToken(TokenBuilder.newClass());
        clazz.appendToken(TokenBuilder.newSpace());
        clazz.addChildWithTokens(ASTUtils.newAST(105, className));
        clazz.appendToken(TokenBuilder.newSpace());
        clazz.addChildWithTokens(ASTBuilder.newTypeBlock());
        LinkedListTree annos = ASTUtils.newPlaceholderAST(8);
        clazz.addChildWithTokens(0, annos);
        return clazz;
    }

    private static String packageNameFrom(String qualifiedName) {
        int p = qualifiedName.lastIndexOf(46);
        if (p == -1) {
            return null;
        }
        return qualifiedName.substring(0, p);
    }

    public static ASTASMethod newClassMethod(String name, Visibility visibility, String returnType) {
        LinkedListTree def = ASTUtils.newImaginaryAST(6);
        LinkedListTree annos = ASTUtils.newPlaceholderAST(8);
        def.addChildWithTokens(annos);
        def.addChildWithTokens(ModifierUtils.toModifiers(visibility));
        def.appendToken(TokenBuilder.newFunction());
        def.appendToken(TokenBuilder.newSpace());
        LinkedListTree acc = ASTUtils.newPlaceholderAST(13);
        def.addChildWithTokens(acc);
        LinkedListTree methName = ASTUtils.newAST(105, name);
        def.addChildWithTokens(methName);
        def.addChildWithTokens(ASTUtils.newParentheticAST(16, 78, "(", 79, ")"));
        if (returnType != null) {
            def.addChildWithTokens(AS3FragmentParser.parseTypeSpec(returnType));
        }
        def.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTBuilder.newBlock();
        def.addChildWithTokens(block);
        return new ASTASMethod(def);
    }

    public static ASTASField newField(String name, Visibility visibility, String type) {
        if (name.indexOf(46) != -1) {
            throw new SyntaxException("field name must not contain '.'");
        }
        LinkedListTree decl = ASTUtils.newImaginaryAST(7);
        LinkedListTree annos = ASTUtils.newPlaceholderAST(8);
        decl.addChildWithTokens(annos);
        decl.addChildWithTokens(ModifierUtils.toModifiers(visibility));
        decl.addChildWithTokens(ASTUtils.newAST(75, "var"));
        decl.appendToken(TokenBuilder.newSpace());
        LinkedListTree def = ASTUtils.newAST(105, name);
        decl.addChildWithTokens(def);
        if (type != null) {
            def.addChildWithTokens(AS3FragmentParser.parseTypeSpec(type));
        }
        decl.appendToken(TokenBuilder.newSemi());
        return new ASTASField(decl);
    }

    public static ASTASMethod newInterfaceMethod(String name, Visibility visibility, String returnType) {
        LinkedListTree def = ASTUtils.newImaginaryAST(6);
        LinkedListTree annos = ASTUtils.newPlaceholderAST(8);
        def.addChildWithTokens(annos);
        def.addChildWithTokens(ModifierUtils.toModifiers(visibility));
        def.appendToken(TokenBuilder.newFunction());
        def.appendToken(TokenBuilder.newSpace());
        LinkedListTree acc = ASTUtils.newPlaceholderAST(13);
        def.addChildWithTokens(acc);
        LinkedListTree methName = ASTUtils.newAST(105, name);
        def.addChildWithTokens(methName);
        def.addChildWithTokens(ASTUtils.newParentheticAST(16, 78, "(", 79, ")"));
        if (returnType != null) {
            def.addChildWithTokens(AS3FragmentParser.parseTypeSpec(returnType));
        }
        def.appendToken(TokenBuilder.newSemi());
        return new ASTASMethod(def);
    }

    public static LinkedListTree newBlock() {
        return ASTBuilder.newBlock(19);
    }

    public static LinkedListTree newTypeBlock() {
        return ASTBuilder.newBlock(5);
    }

    private static LinkedListTree newBlock(int type) {
        LinkedListTree ast = ASTUtils.newParentheticAST(type, 59, "{", 60, "}");
        LinkedListToken nl = TokenBuilder.newNewline();
        ast.getInitialInsertionAfter().afterInsert(nl);
        ast.setInitialInsertionAfter(nl);
        return ast;
    }

    public static LinkedListTree newMetadataTag(String name) {
        LinkedListTree ast = ASTUtils.newParentheticAST(9, 111, "[", 112, "]");
        ast.addChildWithTokens(ASTUtils.newAST(105, name));
        return ast;
    }

    private static LinkedListTree condition(LinkedListTree expr) {
        LinkedListTree cond = ASTUtils.newParentheticAST(21, 78, "(", 79, ")");
        cond.addChildWithTokens(expr);
        return cond;
    }

    public static LinkedListTree newIf(String condition) {
        return ASTBuilder.newIf(AS3FragmentParser.parseExpr(condition));
    }

    public static LinkedListTree newIf(LinkedListTree condition) {
        LinkedListTree ifStmt = ASTUtils.newAST(82, "if");
        ifStmt.appendToken(TokenBuilder.newSpace());
        ifStmt.addChildWithTokens(ASTBuilder.condition(condition));
        ifStmt.appendToken(TokenBuilder.newSpace());
        ifStmt.addChildWithTokens(ASTBuilder.newBlock());
        return ifStmt;
    }

    public static LinkedListTree newFor(String init, String condition, String iterate) {
        return ASTBuilder.newFor(init == null ? null : AS3FragmentParser.parseForInit(init), condition == null ? null : AS3FragmentParser.parseForCond(condition), iterate == null ? null : AS3FragmentParser.parseForIter(iterate));
    }

    public static LinkedListTree newFor(LinkedListTree init, LinkedListTree condition, LinkedListTree iterate) {
        LinkedListTree forStmt = ASTUtils.newAST(95, "for");
        forStmt.appendToken(TokenBuilder.newSpace());
        forStmt.appendToken(TokenBuilder.newLParen());
        if (init != null) {
            forStmt.addChildWithTokens(init);
        } else {
            LinkedListTree initStmt = ASTUtils.newPlaceholderAST(42);
            forStmt.addChildWithTokens(initStmt);
        }
        forStmt.appendToken(TokenBuilder.newSemi());
        forStmt.appendToken(TokenBuilder.newSpace());
        if (condition != null) {
            forStmt.addChildWithTokens(condition);
        } else {
            LinkedListTree condStmt = ASTUtils.newPlaceholderAST(43);
            forStmt.addChildWithTokens(condStmt);
        }
        forStmt.appendToken(TokenBuilder.newSemi());
        forStmt.appendToken(TokenBuilder.newSpace());
        if (iterate != null) {
            forStmt.addChildWithTokens(iterate);
        } else {
            LinkedListTree iterStmt = ASTUtils.newPlaceholderAST(44);
            forStmt.addChildWithTokens(iterStmt);
        }
        forStmt.appendToken(TokenBuilder.newRParen());
        return forStmt;
    }

    public static LinkedListTree newForIn(String declaration, String expression) {
        return ASTBuilder.newForIn(AS3FragmentParser.parseForInVar(declaration), AS3FragmentParser.parseExpr(expression));
    }

    public static LinkedListTree newForIn(LinkedListTree declaration, LinkedListTree expression) {
        LinkedListTree forStmt = ASTUtils.newAST(46, "for");
        forStmt.appendToken(TokenBuilder.newSpace());
        ASTBuilder.genForInSetup(forStmt, declaration, expression);
        return forStmt;
    }

    public static LinkedListTree newForEachIn(String declaration, String expression) {
        return ASTBuilder.newForEachIn(AS3FragmentParser.parseForInVar(declaration), AS3FragmentParser.parseExpr(expression));
    }

    public static LinkedListTree newForEachIn(LinkedListTree declaration, LinkedListTree expression) {
        LinkedListTree forStmt = ASTUtils.newAST(45, "for");
        forStmt.appendToken(TokenBuilder.newSpace());
        forStmt.appendToken(TokenBuilder.newEach());
        ASTBuilder.genForInSetup(forStmt, declaration, expression);
        return forStmt;
    }

    private static void genForInSetup(LinkedListTree forStmt, LinkedListTree declaration, LinkedListTree expression) {
        forStmt.appendToken(TokenBuilder.newLParen());
        forStmt.addChildWithTokens(declaration);
        forStmt.appendToken(TokenBuilder.newSpace());
        forStmt.appendToken(TokenBuilder.newIn());
        forStmt.appendToken(TokenBuilder.newSpace());
        forStmt.addChildWithTokens(expression);
        forStmt.appendToken(TokenBuilder.newRParen());
    }

    public static LinkedListTree newWhile(String condition) {
        return ASTBuilder.newWhile(AS3FragmentParser.parseExpr(condition));
    }

    public static LinkedListTree newWhile(LinkedListTree condition) {
        LinkedListTree whileStmt = ASTUtils.newAST(98, "while");
        whileStmt.appendToken(TokenBuilder.newSpace());
        whileStmt.addChildWithTokens(ASTBuilder.condition(condition));
        return whileStmt;
    }

    public static LinkedListTree newDoWhile(String condition) {
        return ASTBuilder.newDoWhile(AS3FragmentParser.parseExpr(condition));
    }

    public static LinkedListTree newDoWhile(LinkedListTree condition) {
        LinkedListTree doWhileStmt = ASTUtils.newAST(99, "do");
        doWhileStmt.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTBuilder.newBlock();
        doWhileStmt.addChildWithTokens(block);
        doWhileStmt.appendToken(TokenBuilder.newSpace());
        doWhileStmt.appendToken(TokenBuilder.newWhile());
        doWhileStmt.appendToken(TokenBuilder.newSpace());
        doWhileStmt.addChildWithTokens(ASTBuilder.condition(condition));
        doWhileStmt.appendToken(TokenBuilder.newSemi());
        return doWhileStmt;
    }

    public static LinkedListTree newSwitch(String condition) {
        return ASTBuilder.newSwitch(AS3FragmentParser.parseExpr(condition));
    }

    public static LinkedListTree newSwitch(LinkedListTree condition) {
        LinkedListTree switchStmt = ASTUtils.newAST(91, "switch");
        switchStmt.appendToken(TokenBuilder.newSpace());
        switchStmt.addChildWithTokens(ASTBuilder.condition(condition));
        switchStmt.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTBuilder.newBlock();
        switchStmt.addChildWithTokens(block);
        return switchStmt;
    }

    public static LinkedListTree newWith(String expr) {
        return ASTBuilder.newWith(AS3FragmentParser.parseExpr(expr));
    }

    public static LinkedListTree newWith(LinkedListTree expr) {
        LinkedListTree withStmt = ASTUtils.newAST(100, "with");
        withStmt.appendToken(TokenBuilder.newSpace());
        withStmt.addChildWithTokens(ASTBuilder.condition(expr));
        return withStmt;
    }

    public static LinkedListTree newDeclaration(String assignment) {
        return ASTBuilder.newDeclaration(AS3FragmentParser.parseVariableDeclarator(assignment));
    }

    public static LinkedListTree newDeclaration(LinkedListTree assignment) {
        LinkedListTree declStmt = ASTUtils.newAST(75, "var");
        declStmt.appendToken(TokenBuilder.newSpace());
        declStmt.addChildWithTokens(assignment);
        declStmt.appendToken(TokenBuilder.newSemi());
        return declStmt;
    }

    public static LinkedListTree newReturn(String expr) {
        return ASTBuilder.newReturn(expr == null ? null : AS3FragmentParser.parseExpr(expr));
    }

    public static LinkedListTree newReturn(LinkedListTree expr) {
        LinkedListTree returnStmt = ASTUtils.newAST(88, "return");
        if (expr != null) {
            returnStmt.appendToken(TokenBuilder.newSpace());
            returnStmt.addChildWithTokens(expr);
        }
        returnStmt.appendToken(TokenBuilder.newSemi());
        return returnStmt;
    }

    public static LinkedListTree newSuperStatement(List args) {
        LinkedListTree superStmt = ASTUtils.newAST(81, "super");
        LinkedListTree argumentsNode = ASTUtils.newParentheticAST(22, 78, "(", 79, ")");
        ArgumentUtils.overwriteArgsWithExpressionList(argumentsNode, args);
        superStmt.addChildWithTokens(argumentsNode);
        superStmt.appendToken(TokenBuilder.newSemi());
        return superStmt;
    }

    public static LinkedListTree newBreakStatement() {
        LinkedListTree breakStmt = ASTUtils.newAST(90, "break");
        breakStmt.appendToken(TokenBuilder.newSemi());
        return breakStmt;
    }

    public static LinkedListTree newTryStatement() {
        LinkedListTree tryStmt = ASTUtils.newAST(85, "try");
        tryStmt.appendToken(TokenBuilder.newSpace());
        tryStmt.addChildWithTokens(ASTBuilder.newBlock());
        return tryStmt;
    }

    public static LinkedListTree newCatchClause(String var, String type) {
        LinkedListTree tryStmt = ASTUtils.newAST(86, "catch");
        tryStmt.appendToken(TokenBuilder.newSpace());
        tryStmt.appendToken(TokenBuilder.newLParen());
        tryStmt.addChildWithTokens(AS3FragmentParser.parseSimpleIdent(var));
        if (type != null) {
            tryStmt.addChildWithTokens(AS3FragmentParser.parseTypeSpec(type));
        }
        tryStmt.appendToken(TokenBuilder.newRParen());
        tryStmt.appendToken(TokenBuilder.newSpace());
        tryStmt.addChildWithTokens(ASTBuilder.newBlock());
        return tryStmt;
    }

    public static LinkedListTree newFinallyClause() {
        LinkedListTree tryStmt = ASTUtils.newAST(87, "finally");
        tryStmt.appendToken(TokenBuilder.newSpace());
        tryStmt.addChildWithTokens(ASTBuilder.newBlock());
        return tryStmt;
    }

    public static LinkedListTree newContinueStatement() {
        LinkedListTree continueStmt = ASTUtils.newAST(89, "continue");
        continueStmt.appendToken(TokenBuilder.newSemi());
        return continueStmt;
    }

    public static ASBinaryExpression newBinaryExpression(LinkedListToken op, Expression left, Expression right) {
        LinkedListTree ast = ASTUtils.newAST(op);
        LinkedListTree leftExpr = ((ASTExpression)left).getAST();
        ASTBuilder.assertNoParent("left-hand expression", leftExpr);
        LinkedListTree rightExpr = ((ASTExpression)right).getAST();
        if (ASTBuilder.precidence(ast) < ASTBuilder.precidence(leftExpr)) {
            leftExpr = ASTBuilder.parenthise(leftExpr);
        }
        if (ASTBuilder.precidence(ast) < ASTBuilder.precidence(rightExpr)) {
            rightExpr = ASTBuilder.parenthise(rightExpr);
        }
        ast.addChild(leftExpr);
        ast.addChild(rightExpr);
        leftExpr.getStopToken().setNext(op);
        rightExpr.getStartToken().setPrev(op);
        ast.setStartToken(leftExpr.getStartToken());
        ast.setStopToken(rightExpr.getStopToken());
        ASTBuilder.spaceEitherSide(op);
        return new ASTASBinaryExpression(ast);
    }

    public static ASAssignmentExpression newAssignExpression(LinkedListToken op, Expression left, Expression right) {
        LinkedListTree ast = ASTUtils.newAST(op);
        LinkedListTree leftExpr = ((ASTExpression)left).getAST();
        ASTBuilder.assertNoParent("left-hand expression", leftExpr);
        LinkedListTree rightExpr = ((ASTExpression)right).getAST();
        if (ASTBuilder.precidence(ast) < ASTBuilder.precidence(leftExpr)) {
            leftExpr = ASTBuilder.parenthise(leftExpr);
        }
        if (ASTBuilder.precidence(ast) < ASTBuilder.precidence(rightExpr)) {
            rightExpr = ASTBuilder.parenthise(rightExpr);
        }
        ast.addChild(leftExpr);
        ast.addChild(rightExpr);
        leftExpr.getStopToken().setNext(op);
        rightExpr.getStartToken().setPrev(op);
        ast.setStartToken(leftExpr.getStartToken());
        ast.setStopToken(rightExpr.getStopToken());
        ASTBuilder.spaceEitherSide(op);
        return new ASTASAssignmentExpression(ast);
    }

    public static void assertNoParent(String astDescription, LinkedListTree ast) {
        if (ast.getParent() != null) {
            throw new SyntaxException(astDescription + " cannot be added to a second parent node");
        }
    }

    private static LinkedListTree parenthise(LinkedListTree expr) {
        LinkedListTree result = ASTUtils.newParentheticAST(24, 78, "(", 79, ")");
        result.addChildWithTokens(expr);
        return result;
    }

    private static int precidence(LinkedListTree ast) {
        switch (ast.getType()) {
            case 77: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: {
                return 13;
            }
            case 129: {
                return 12;
            }
            case 130: {
                return 11;
            }
            case 131: {
                return 10;
            }
            case 132: {
                return 9;
            }
            case 133: {
                return 8;
            }
            case 134: {
                return 7;
            }
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                return 6;
            }
            case 97: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: {
                return 5;
            }
            case 146: 
            case 147: 
            case 148: {
                return 4;
            }
            case 149: 
            case 150: {
                return 3;
            }
            case 103: 
            case 151: 
            case 152: {
                return 2;
            }
        }
        return 1;
    }

    public static LinkedListTree newFieldAccessExpression(LinkedListTree target, LinkedListTree name) {
        LinkedListToken op = TokenBuilder.newDot();
        LinkedListTree ast = ASTUtils.newAST(op);
        ASTBuilder.assertNoParent("target expression", target);
        ast.addChild(target);
        ast.addChild(name);
        target.getStopToken().setNext(op);
        name.getStartToken().setPrev(op);
        ast.setStartToken(target.getStartToken());
        ast.setStopToken(name.getStopToken());
        return ast;
    }

    public static LinkedListTree newConditionalExpression(LinkedListTree conditionExpr, LinkedListTree thenExpr, LinkedListTree elseExpr) {
        LinkedListToken op = TokenBuilder.newQuestion();
        LinkedListToken colon = TokenBuilder.newColon();
        LinkedListTree ast = ASTUtils.newAST(op);
        ast.addChild(conditionExpr);
        conditionExpr.getStopToken().setNext(op);
        ast.addChild(thenExpr);
        thenExpr.getStartToken().setPrev(op);
        thenExpr.getStopToken().setNext(colon);
        ast.addChild(elseExpr);
        elseExpr.getStartToken().setPrev(colon);
        ast.setStartToken(conditionExpr.getStartToken());
        ast.setStopToken(elseExpr.getStopToken());
        ASTBuilder.spaceEitherSide(op);
        ASTBuilder.spaceEitherSide(colon);
        return ast;
    }

    private static void spaceEitherSide(LinkedListToken token) {
        token.beforeInsert(TokenBuilder.newSpace());
        token.afterInsert(TokenBuilder.newSpace());
    }

    public static LinkedListTree newFunctionExpression() {
        LinkedListTree def = ASTUtils.newImaginaryAST(41);
        def.appendToken(TokenBuilder.newFunction());
        def.appendToken(TokenBuilder.newSpace());
        def.addChildWithTokens(ASTUtils.newParentheticAST(16, 78, "(", 79, ")"));
        def.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTBuilder.newBlock();
        def.addChildWithTokens(block);
        return def;
    }

    public static LinkedListTree newArrayLiteral() {
        LinkedListTree lit = ASTUtils.newParentheticAST(38, 111, "[", 112, "]");
        return lit;
    }

    public static LinkedListTree newObjectLiteral() {
        LinkedListTree lit = ASTBuilder.newBlock(39);
        return lit;
    }

    public static LinkedListTree newObjectField(String name, LinkedListTree value) {
        LinkedListTree field = ASTUtils.newImaginaryAST(40);
        field.addChildWithTokens(AS3FragmentParser.parseSimpleIdent(name));
        field.appendToken(TokenBuilder.newColon());
        field.appendToken(TokenBuilder.newSpace());
        field.addChildWithTokens(value);
        return field;
    }

    public static LinkedListTree newThrowStatement(LinkedListTree ast) {
        LinkedListTree thrw = ASTUtils.newAST(84, "throw");
        thrw.appendToken(TokenBuilder.newSpace());
        thrw.addChildWithTokens(ast);
        thrw.appendToken(TokenBuilder.newSemi());
        return thrw;
    }

    public static LinkedListTree newDescendantExpression(LinkedListTree target, LinkedListTree selector) {
        LinkedListToken op = TokenBuilder.newE4XDescendant();
        LinkedListTree ast = ASTUtils.newAST(op);
        ASTBuilder.assertNoParent("left-hand expression", target);
        if (ASTBuilder.precidence(ast) < ASTBuilder.precidence(target)) {
            target = ASTBuilder.parenthise(target);
        }
        if (ASTBuilder.precidence(ast) < ASTBuilder.precidence(selector)) {
            selector = ASTBuilder.parenthise(selector);
        }
        ast.addChild(target);
        ast.addChild(selector);
        target.getStopToken().setNext(op);
        selector.getStartToken().setPrev(op);
        ast.setStartToken(target.getStartToken());
        ast.setStopToken(selector.getStopToken());
        return ast;
    }

    public static LinkedListTree newFilterExpression(LinkedListTree target, LinkedListTree selector) {
        LinkedListTree ast = ASTUtils.newImaginaryAST(53);
        ASTBuilder.assertNoParent("target expression", target);
        ASTBuilder.assertNoParent("query expression", target);
        ast.addChildWithTokens(target);
        ast.appendToken(TokenBuilder.newDot());
        ast.appendToken(TokenBuilder.newLParen());
        ast.addChildWithTokens(selector);
        ast.appendToken(TokenBuilder.newRParen());
        return ast;
    }

    public static LinkedListTree newStarAttribute() {
        LinkedListTree ast = ASTUtils.newImaginaryAST(55);
        ast.appendToken(TokenBuilder.newAt());
        ast.appendToken(TokenBuilder.newStar());
        return ast;
    }

    public static LinkedListTree newPropertyAttribute(String propertyName) {
        LinkedListTree ast = ASTUtils.newImaginaryAST(54);
        ast.appendToken(TokenBuilder.newAt());
        LinkedListTree prop = AS3FragmentParser.parseQualifiedIdent(propertyName);
        ast.addChildWithTokens(prop);
        return ast;
    }

    public static LinkedListTree newExpressionAttribute(LinkedListTree expr) {
        LinkedListTree ast = ASTUtils.newImaginaryAST(56);
        ast.appendToken(TokenBuilder.newAt());
        ast.appendToken(TokenBuilder.newLBrack());
        ast.addChildWithTokens(expr);
        ast.appendToken(TokenBuilder.newRBrack());
        return ast;
    }

    public static LinkedListTree newString(String value) {
        return ASTUtils.newAST(69, ActionScriptFactory.str(value));
    }

    public static LinkedListTree newDefaultXMLNamespace(LinkedListTree namespace) {
        LinkedListTree ast = ASTUtils.newImaginaryAST(50);
        ast.appendToken(TokenBuilder.newDefault());
        ast.appendToken(TokenBuilder.newSpace());
        ast.appendToken(TokenBuilder.newXml());
        ast.appendToken(TokenBuilder.newSpace());
        ast.appendToken(TokenBuilder.newNamespace());
        ast.appendToken(TokenBuilder.newSpace());
        ast.appendToken(TokenBuilder.newAssign());
        ast.appendToken(TokenBuilder.newSpace());
        ast.addChildWithTokens(namespace);
        ast.appendToken(TokenBuilder.newSemi());
        return ast;
    }
}

