/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.gvnix.flex.addon.metaas.dom.DocComment;
import org.gvnix.flex.addon.metaas.dom.DocTag;
import org.gvnix.flex.addon.metaas.impl.ASTDocTag;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTScriptElement;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.DocCommentUtils;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTDocComment
extends ASTScriptElement
implements DocComment {
    private LinkedListTree javadoc;

    public ASTDocComment(LinkedListTree ast) {
        super(ast);
        this.javadoc = DocCommentUtils.buildJavadoc(ast);
    }

    public String getDescriptionString() {
        return DocCommentUtils.getDescriptionString(this.ast);
    }

    public void setDescriptionString(String description) {
        DocCommentUtils.setDescriptionString(this.ast, description);
    }

    public Iterator findTags(String name) {
        LinkedListTree para;
        if (this.javadoc == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        String tagname = ASTDocComment.tagName(name);
        LinkedList<ASTDocTag> tags = new LinkedList<ASTDocTag>();
        ASTIterator i = new ASTIterator(this.javadoc);
        while ((para = i.search(7)) != null) {
            LinkedListTree tag = para.getFirstChild();
            if (!tag.getText().equals(tagname)) continue;
            tags.add(new ASTDocTag(this, para));
        }
        return tags.iterator();
    }

    private static String tagName(String name) {
        return "@" + name;
    }

    public DocTag findFirstTag(String name) {
        LinkedListTree para;
        if (this.javadoc == null) {
            return null;
        }
        String tagname = ASTDocComment.tagName(name);
        ASTIterator i = new ASTIterator(this.javadoc);
        while ((para = i.search(7)) != null) {
            LinkedListTree tag = para.getFirstChild();
            if (!tag.getText().equals(tagname)) continue;
            return new ASTDocTag(this, para);
        }
        return null;
    }

    public void delete(DocTag tag) {
        LinkedListTree tagAST = ((ASTDocTag)tag).getAST();
        int index = this.javadoc.getIndexOfChild(tagAST);
        this.javadoc.deleteChild(index);
        this.commitModifiedAST();
    }

    public void addParaTag(String name, String body) {
        DocCommentUtils.assertValidContent(body);
        String newline = DocCommentUtils.getNewlineText(this.ast, this.javadoc);
        body = body.replaceAll("\n", newline);
        String tagname = ASTDocComment.tagName(name);
        if (this.javadoc == null) {
            DocCommentUtils.setDocComment(this.ast, "\n " + tagname + " " + body + "\n");
            this.javadoc = DocCommentUtils.buildJavadoc(this.ast);
        } else {
            LinkedListTree lastChild = this.javadoc.getLastChild();
            LinkedListTree para = DocCommentUtils.parseParaTag(tagname + " " + body);
            this.javadoc.addChildWithTokens(para);
            LinkedListTree trainingNL = null;
            int lastChildLast = lastChild.getChildCount() - 1;
            lastChild.addChildWithTokens(ASTUtils.newAST(9, newline));
            if (lastChild.getChild(lastChildLast).getType() == 9) {
                trainingNL = (LinkedListTree)lastChild.deleteChild(lastChildLast);
            }
            if (trainingNL != null) {
                para.addChildWithTokens(trainingNL);
            }
            this.commitModifiedAST();
        }
    }

    public void commitModifiedAST() {
        LinkedListToken doc = DocCommentUtils.findDocCommentToken(this.ast);
        doc.setText("/**" + ASTUtils.stringifyNode(this.javadoc) + "*/");
    }
}

