/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import org.gvnix.flex.addon.metaas.dom.DocTag;
import org.gvnix.flex.addon.metaas.impl.ASTDocComment;
import org.gvnix.flex.addon.metaas.impl.DocCommentUtils;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTDocTag
implements DocTag {
    private ASTDocComment comment;
    private LinkedListTree ast;

    public ASTDocTag(ASTDocComment comment, LinkedListTree ast) {
        this.comment = comment;
        this.ast = ast;
    }

    public LinkedListTree getAST() {
        return this.ast;
    }

    public String getBodyString() {
        StringBuffer result = new StringBuffer();
        for (LinkedListToken tok = this.ast.getStartToken().getNext(); tok != null && tok.getType() != -1; tok = tok.getNext()) {
            result.append(ASTDocTag.stringify(tok));
            if (tok == this.ast.getStopToken()) break;
        }
        return result.toString();
    }

    private static String stringify(LinkedListToken tok) {
        switch (tok.getType()) {
            case 9: {
                return "\n";
            }
        }
        return tok.getText();
    }

    public void setBody(String text) {
        int lastIndex = this.ast.getChildCount() - 1;
        String indentNL = DocCommentUtils.findNewline(this.ast);
        LinkedListTree trailingNL = null;
        if (lastIndex >= 0 && this.ast.getChild(lastIndex).getType() == 9) {
            trailingNL = (LinkedListTree)this.ast.getChild(lastIndex);
        }
        LinkedListTree tag = DocCommentUtils.parseParaTag(this.ast.getFirstChild().getText() + " " + text);
        this.replaceNLs(tag, indentNL);
        if (trailingNL != null) {
            tag.addChildWithTokens(trailingNL);
        }
        LinkedListTree parent = this.ast.getParent();
        int pos = parent.getIndexOfChild(this.ast);
        parent.setChildWithTokens(pos, tag);
        this.comment.commitModifiedAST();
    }

    private void replaceNLs(LinkedListTree tree, String indentNL) {
        for (LinkedListToken tok = tree.getStartToken().getNext(); tok != null && tok.getType() != -1; tok = tok.getNext()) {
            if (tok.getType() == 9) {
                tok.setText(indentNL);
            }
            if (tok == tree.getStopToken()) break;
        }
    }

    public String getName() {
        return this.ast.getStartToken().getText().substring(1);
    }

    public void setName(String name) {
        this.ast.getStartToken().setText("@" + name);
        this.comment.commitModifiedAST();
    }
}

