/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gvnix.flex.addon.metaas.dom.ASArg;
import org.gvnix.flex.addon.metaas.dom.FunctionCommon;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTASArg;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTFunctionCommon
implements FunctionCommon {
    public static final String ELLIPSIS = "...";
    public LinkedListTree ast;

    public ASTFunctionCommon(LinkedListTree ast) {
        this.ast = ast;
    }

    public List getArgs() {
        LinkedList<ASTASArg> results = new LinkedList<ASTASArg>();
        LinkedListTree params = ASTUtils.findChildByType(this.ast, 16);
        ASTIterator i = new ASTIterator(params);
        while (i.hasNext()) {
            results.add(new ASTASArg(i.next()));
        }
        return Collections.unmodifiableList(results);
    }

    public String getType() {
        LinkedListTree typeSpec = ASTUtils.findChildByType(this.ast, 18);
        if (typeSpec == null) {
            return null;
        }
        return ASTUtils.typeSpecText(typeSpec);
    }

    public void setType(String typeName) {
        LinkedListTree type = ASTUtils.findChildByType(this.ast, 18);
        if (typeName == null) {
            if (type != null) {
                this.ast.deleteChild(this.ast.getIndexOfChild(type));
            }
            return;
        }
        LinkedListTree newType = AS3FragmentParser.parseTypeSpec(typeName);
        if (type == null) {
            this.ast.addChildWithTokens(this.ast.getChildCount() - 1, newType);
        } else {
            type.setChildWithTokens(0, newType.getFirstChild());
        }
    }

    private LinkedListTree findParams() {
        return ASTUtils.findChildByType(this.ast, 16);
    }

    public ASArg addParam(String name, String type) {
        LinkedListTree param = ASTUtils.newAST(17);
        param.addChildWithTokens(ASTUtils.newAST(105, name));
        if (type != null) {
            param.addChildWithTokens(AS3FragmentParser.parseTypeSpec(type));
        }
        return this.param(param);
    }

    private ASArg param(LinkedListTree param) {
        LinkedListTree params = this.findParams();
        if (params.getChildCount() > 0) {
            params.appendToken(TokenBuilder.newComma());
            params.appendToken(TokenBuilder.newSpace());
        }
        params.addChildWithTokens(param);
        return new ASTASArg(param);
    }

    public ASArg addRestParam(String name) {
        if (ELLIPSIS.equals(name)) {
            return this.addAnonRestParam();
        }
        return this.addNamedRestParam(name);
    }

    private ASArg addAnonRestParam() {
        LinkedListTree param = ASTUtils.newAST(17);
        param.addChildWithTokens(ASTUtils.newAST(80, ELLIPSIS));
        return this.param(param);
    }

    private ASArg addNamedRestParam(String name) {
        LinkedListTree param = ASTUtils.newAST(17);
        param.addChildWithTokens(ASTUtils.newAST(80, ELLIPSIS));
        param.addChildWithTokens(ASTUtils.newAST(105, name));
        return this.param(param);
    }

    public ASArg removeParam(String name) {
        LinkedListTree params = ASTUtils.findChildByType(this.ast, 16);
        int count = 0;
        ASTIterator i = new ASTIterator(params);
        while (i.hasNext()) {
            LinkedListTree ast = i.next();
            ASTASArg arg = new ASTASArg(ast);
            if (arg.getName().equals(name)) {
                if (i.hasNext()) {
                    ASTUtils.removeTrailingWhitespaceAndComma(ast.getStopToken());
                } else if (count > 0) {
                    ASTUtils.removePreceedingWhitespaceAndComma(ast.getStartToken());
                }
                i.remove();
                return arg;
            }
            ++count;
        }
        return null;
    }
}

