/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.NoSuchElementException;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTIterator {
    private LinkedListTree parent;
    private int index = -1;

    public ASTIterator(LinkedListTree parent) {
        if (parent == null) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.parent = parent;
    }

    public boolean hasNext() {
        return this.index < this.parent.getChildCount() - 1;
    }

    public LinkedListTree next(int tokenType) {
        if (!this.hasNext()) {
            throw new IllegalStateException("expected " + ASTUtils.tokenName(tokenType) + " but reached last child");
        }
        if (this.parent.getChild(this.index + 1).getType() != tokenType) {
            throw new IllegalStateException("expected " + ASTUtils.tokenName(tokenType) + " but got " + this.parent.getChild(this.index + 1));
        }
        return this.next();
    }

    public LinkedListTree next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        return (LinkedListTree)this.parent.getChild(this.index);
    }

    public void remove() {
        this.parent.deleteChild(this.index);
        --this.index;
    }

    public void replace(LinkedListTree replacement) {
        this.parent.setChildWithTokens(this.index, replacement);
    }

    public LinkedListTree search(int tokenType) {
        while (this.hasNext()) {
            LinkedListTree ast = this.next();
            if (ast.getType() != tokenType) continue;
            return ast;
        }
        return null;
    }

    public LinkedListTree find(int tokenType) {
        LinkedListTree result = this.search(tokenType);
        if (result != null) {
            return result;
        }
        throw new IllegalStateException("expected " + ASTUtils.tokenName(tokenType) + " but not found");
    }

    public void insertBeforeCurrent(LinkedListTree insert) {
        this.parent.addChildWithTokens(this.index, insert);
    }

    public int getCurrentIndex() {
        return this.index;
    }
}

