/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gvnix.flex.addon.metaas.dom.ASBlock;
import org.gvnix.flex.addon.metaas.dom.ASBreakStatement;
import org.gvnix.flex.addon.metaas.dom.ASContinueStatement;
import org.gvnix.flex.addon.metaas.dom.ASDeclarationStatement;
import org.gvnix.flex.addon.metaas.dom.ASDefaultXMLNamespaceStatement;
import org.gvnix.flex.addon.metaas.dom.ASDoWhileStatement;
import org.gvnix.flex.addon.metaas.dom.ASExpressionStatement;
import org.gvnix.flex.addon.metaas.dom.ASForEachInStatement;
import org.gvnix.flex.addon.metaas.dom.ASForInStatement;
import org.gvnix.flex.addon.metaas.dom.ASForStatement;
import org.gvnix.flex.addon.metaas.dom.ASIfStatement;
import org.gvnix.flex.addon.metaas.dom.ASReturnStatement;
import org.gvnix.flex.addon.metaas.dom.ASSuperStatement;
import org.gvnix.flex.addon.metaas.dom.ASSwitchStatement;
import org.gvnix.flex.addon.metaas.dom.ASThrowStatement;
import org.gvnix.flex.addon.metaas.dom.ASTryStatement;
import org.gvnix.flex.addon.metaas.dom.ASWhileStatement;
import org.gvnix.flex.addon.metaas.dom.ASWithStatement;
import org.gvnix.flex.addon.metaas.dom.Expression;
import org.gvnix.flex.addon.metaas.dom.Statement;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASTASBreakStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASContinueStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASDeclarationStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASDefaultXMLNamespaceStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASDoWhileStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASExpressionStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASForEachInStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASForInStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASForStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASIfStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASReturnStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASSuperStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASSwitchStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASThrowStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASTryStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASWhileStatement;
import org.gvnix.flex.addon.metaas.impl.ASTASWithStatement;
import org.gvnix.flex.addon.metaas.impl.ASTBuilder;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTScriptElement;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.StatementBuilder;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class ASTStatementList
extends ASTScriptElement
implements ASBlock {
    public ASTStatementList(LinkedListTree ast) {
        super(ast);
        this.assertBlockAST(ast);
    }

    private void assertBlockAST(LinkedListTree ast) {
        switch (ast.getType()) {
            case 19: 
            case 47: {
                break;
            }
            default: {
                throw new IllegalArgumentException("statement is not a block: " + ASTUtils.tokenName(ast));
            }
        }
    }

    public Statement addStmt(String statement) {
        LinkedListTree stmt = AS3FragmentParser.parseStatement(statement);
        stmt.getStopToken().setNext(null);
        this.addStatement(stmt);
        return StatementBuilder.build(stmt);
    }

    public ASExpressionStatement newExprStmt(String expr) {
        LinkedListTree stmt = AS3FragmentParser.parseExprStatement(expr);
        this.addStatement(stmt);
        return new ASTASExpressionStatement(stmt);
    }

    public ASExpressionStatement newExprStmt(Expression expr) {
        LinkedListTree stmt = ASTBuilder.newExprStmt(ASTScriptElement.ast(expr));
        this.addStatement(stmt);
        return new ASTASExpressionStatement(stmt);
    }

    public void addComment(String text) {
        LinkedListToken comment = TokenBuilder.newSLComment("//" + text);
        String indent = this.findIndentForComment();
        this.ast.appendToken(TokenBuilder.newNewline());
        this.ast.appendToken(TokenBuilder.newWhiteSpace(indent));
        this.ast.appendToken(comment);
    }

    private String findIndentForComment() {
        LinkedListTree last = this.ast.getLastChild();
        String indent = last == null ? "\t" + ASTUtils.findIndent(this.ast) : ASTUtils.findIndent(last);
        return indent;
    }

    public ASIfStatement newIf(String condition) {
        LinkedListTree ifStmt = ASTBuilder.newIf(condition);
        this.addStatement(ifStmt);
        return new ASTASIfStatement(ifStmt);
    }

    public ASIfStatement newIf(Expression condition) {
        LinkedListTree ifStmt = ASTBuilder.newIf(ASTScriptElement.ast(condition));
        this.addStatement(ifStmt);
        return new ASTASIfStatement(ifStmt);
    }

    public ASForStatement newFor(String init, String condition, String iterate) {
        LinkedListTree forStmt = ASTBuilder.newFor(init, condition, iterate);
        ASTStatementList.appendBlock(forStmt);
        this.addStatement(forStmt);
        return new ASTASForStatement(forStmt);
    }

    public ASForStatement newFor(Expression init, Expression condition, Expression iterate) {
        LinkedListTree forStmt = ASTBuilder.newFor(ASTScriptElement.ast(init), ASTScriptElement.ast(condition), ASTScriptElement.ast(iterate));
        ASTStatementList.appendBlock(forStmt);
        this.addStatement(forStmt);
        return new ASTASForStatement(forStmt);
    }

    public ASForInStatement newForIn(String declaration, String expression) {
        LinkedListTree forStmt = ASTBuilder.newForIn(declaration, expression);
        ASTStatementList.appendBlock(forStmt);
        this.addStatement(forStmt);
        return new ASTASForInStatement(forStmt);
    }

    public ASForInStatement newForIn(Expression declaration, Expression expression) {
        LinkedListTree forStmt = ASTBuilder.newForIn(ASTScriptElement.ast(declaration), ASTScriptElement.ast(expression));
        ASTStatementList.appendBlock(forStmt);
        this.addStatement(forStmt);
        return new ASTASForInStatement(forStmt);
    }

    public ASForEachInStatement newForEachIn(String declaration, String expression) {
        LinkedListTree forStmt = ASTBuilder.newForEachIn(declaration, expression);
        ASTStatementList.appendBlock(forStmt);
        this.addStatement(forStmt);
        return new ASTASForEachInStatement(forStmt);
    }

    public ASForEachInStatement newForEachIn(Expression declaration, Expression expression) {
        LinkedListTree forStmt = ASTBuilder.newForEachIn(ASTScriptElement.ast(declaration), ASTScriptElement.ast(expression));
        ASTStatementList.appendBlock(forStmt);
        this.addStatement(forStmt);
        return new ASTASForEachInStatement(forStmt);
    }

    public ASWhileStatement newWhile(String condition) {
        LinkedListTree whileStmt = ASTBuilder.newWhile(condition);
        ASTStatementList.appendBlock(whileStmt);
        this.addStatement(whileStmt);
        return new ASTASWhileStatement(whileStmt);
    }

    public ASWhileStatement newWhile(Expression condition) {
        LinkedListTree whileStmt = ASTBuilder.newWhile(ASTScriptElement.ast(condition));
        ASTStatementList.appendBlock(whileStmt);
        this.addStatement(whileStmt);
        return new ASTASWhileStatement(whileStmt);
    }

    public ASDoWhileStatement newDoWhile(String condition) {
        LinkedListTree doWhileStmt = ASTBuilder.newDoWhile(condition);
        this.addStatement(doWhileStmt);
        return new ASTASDoWhileStatement(doWhileStmt);
    }

    public ASDoWhileStatement newDoWhile(Expression condition) {
        LinkedListTree doWhileStmt = ASTBuilder.newDoWhile(ASTScriptElement.ast(condition));
        this.addStatement(doWhileStmt);
        return new ASTASDoWhileStatement(doWhileStmt);
    }

    public ASSwitchStatement newSwitch(String condition) {
        LinkedListTree switchStmt = ASTBuilder.newSwitch(condition);
        this.addStatement(switchStmt);
        return new ASTASSwitchStatement(switchStmt);
    }

    public ASSwitchStatement newSwitch(Expression condition) {
        LinkedListTree switchStmt = ASTBuilder.newSwitch(ASTScriptElement.ast(condition));
        this.addStatement(switchStmt);
        return new ASTASSwitchStatement(switchStmt);
    }

    public ASWithStatement newWith(String expr) {
        LinkedListTree withStmt = ASTBuilder.newWith(expr);
        ASTStatementList.appendBlock(withStmt);
        this.addStatement(withStmt);
        return new ASTASWithStatement(withStmt);
    }

    public ASWithStatement newWith(Expression expr) {
        LinkedListTree withStmt = ASTBuilder.newWith(ASTScriptElement.ast(expr));
        ASTStatementList.appendBlock(withStmt);
        this.addStatement(withStmt);
        return new ASTASWithStatement(withStmt);
    }

    public ASDeclarationStatement newDeclaration(String assignment) {
        LinkedListTree declStmt = ASTBuilder.newDeclaration(assignment);
        this.addStatement(declStmt);
        return new ASTASDeclarationStatement(declStmt);
    }

    public ASDeclarationStatement newDeclaration(Expression assignment) {
        LinkedListTree declStmt = ASTBuilder.newDeclaration(ASTScriptElement.ast(assignment));
        this.addStatement(declStmt);
        return new ASTASDeclarationStatement(declStmt);
    }

    public ASReturnStatement newReturn(String expr) {
        LinkedListTree returnStmt = ASTBuilder.newReturn(expr);
        this.addStatement(returnStmt);
        return new ASTASReturnStatement(returnStmt);
    }

    public ASReturnStatement newReturn(Expression expr) {
        LinkedListTree returnStmt = ASTBuilder.newReturn(ASTScriptElement.ast(expr));
        this.addStatement(returnStmt);
        return new ASTASReturnStatement(returnStmt);
    }

    public ASReturnStatement newReturn() {
        LinkedListTree returnStmt = ASTBuilder.newReturn((String)null);
        this.addStatement(returnStmt);
        return new ASTASReturnStatement(returnStmt);
    }

    public ASSuperStatement newSuper(List args) {
        LinkedListTree superStmt = ASTBuilder.newSuperStatement(args);
        this.addStatement(superStmt);
        return new ASTASSuperStatement(superStmt);
    }

    public ASBreakStatement newBreak() {
        LinkedListTree breakStmt = ASTBuilder.newBreakStatement();
        this.addStatement(breakStmt);
        return new ASTASBreakStatement(breakStmt);
    }

    public ASTryStatement newTryCatch(String var, String type) {
        LinkedListTree tryStmt = ASTBuilder.newTryStatement();
        tryStmt.appendToken(TokenBuilder.newSpace());
        tryStmt.addChildWithTokens(ASTBuilder.newCatchClause(var, type));
        this.addStatement(tryStmt);
        return new ASTASTryStatement(tryStmt);
    }

    public ASTryStatement newTryFinally() {
        LinkedListTree tryStmt = ASTBuilder.newTryStatement();
        tryStmt.appendToken(TokenBuilder.newSpace());
        tryStmt.addChildWithTokens(ASTBuilder.newFinallyClause());
        this.addStatement(tryStmt);
        return new ASTASTryStatement(tryStmt);
    }

    public ASContinueStatement newContinue() {
        LinkedListTree breakStmt = ASTBuilder.newContinueStatement();
        this.addStatement(breakStmt);
        return new ASTASContinueStatement(breakStmt);
    }

    public ASThrowStatement newThrow(Expression t) {
        LinkedListTree throwStmt = ASTBuilder.newThrowStatement(ASTScriptElement.ast(t));
        this.addStatement(throwStmt);
        return new ASTASThrowStatement(throwStmt);
    }

    public ASDefaultXMLNamespaceStatement newDefaultXMLNamespace(String namespace) {
        LinkedListTree nsStmt = ASTBuilder.newDefaultXMLNamespace(ASTBuilder.newString(namespace));
        this.addStatement(nsStmt);
        return new ASTASDefaultXMLNamespaceStatement(nsStmt);
    }

    private void addStatement(LinkedListTree stmt) {
        ASTUtils.addChildWithIndentation(this.ast, stmt);
    }

    public boolean containsCode() {
        return this.ast.getFirstChild() != null;
    }

    public LinkedListTree getAST() {
        return this.ast;
    }

    private static LinkedListTree appendBlock(LinkedListTree ast) {
        ast.appendToken(TokenBuilder.newSpace());
        LinkedListTree block = ASTBuilder.newBlock();
        ast.addChildWithTokens(block);
        return block;
    }

    private static LinkedListTree findBlock(LinkedListTree ast) {
        return (LinkedListTree)ast.getFirstChildWithType(19);
    }

    public List getStatementList() {
        ArrayList<Statement> result = new ArrayList<Statement>();
        ASTIterator i = new ASTIterator(this.ast);
        while (i.hasNext()) {
            result.add(StatementBuilder.build(i.next()));
        }
        return Collections.unmodifiableList(result);
    }
}

