/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.gvnix.flex.addon.antlr.runtime.ANTLRReaderStream;
import org.gvnix.flex.addon.antlr.runtime.MismatchedTokenException;
import org.gvnix.flex.addon.antlr.runtime.NoViableAltException;
import org.gvnix.flex.addon.antlr.runtime.RecognitionException;
import org.gvnix.flex.addon.asdt.core.internal.antlr.AS3Lexer;
import org.gvnix.flex.addon.asdt.core.internal.antlr.AS3Parser;
import org.gvnix.flex.addon.metaas.ActionScriptFactory;
import org.gvnix.flex.addon.metaas.SyntaxException;
import org.gvnix.flex.addon.metaas.dom.Expression;
import org.gvnix.flex.addon.metaas.impl.ASTExpression;
import org.gvnix.flex.addon.metaas.impl.DocCommentUtils;
import org.gvnix.flex.addon.metaas.impl.ParentheticListUpdateDelegate;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.BasicListUpdateDelegate;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTokenSource;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTokenStream;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTreeAdaptor;
import org.gvnix.flex.addon.metaas.impl.antlr.TreeTokenListUpdateDelegate;

public class ASTUtils {
    public static final LinkedListTreeAdaptor TREE_ADAPTOR = new LinkedListTreeAdaptor();

    public static String identText(LinkedListTree ast) {
        if (ast.getType() != 48) {
            throw new IllegalArgumentException("expected IDENTIFIER, but token was a " + ASTUtils.tokenName(ast));
        }
        return ASTUtils.stringifyIdentAux((LinkedListTree)ast.getChild(0));
    }

    private static String stringifyIdentAux(LinkedListTree ast) {
        StringBuffer result = new StringBuffer();
        if (ast.getType() == 104) {
            result.append(ast.getFirstChild());
            result.append("::");
            result.append(ast.getLastChild());
        } else if (ast.getType() == 27 || ast.getType() == 110) {
            result.append(ASTUtils.stringifyIdentAux(ast.getFirstChild()));
            result.append(".");
            result.append(ASTUtils.stringifyIdentAux(ast.getLastChild()));
        } else {
            result.append(ast.getText());
        }
        return result.toString();
    }

    public static String qualifiedIdentText(LinkedListTree ast) {
        if (ast.getType() == 104) {
            return ast.getFirstChild() + "::" + ast.getLastChild();
        }
        return ast.getText();
    }

    public static String identStarText(LinkedListTree ast) {
        if (ast.getType() != 49) {
            throw new IllegalArgumentException("expected IDENTIFIER_STAR, but token was a " + ASTUtils.tokenName(ast));
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < ast.getChildCount(); ++i) {
            LinkedListTree part = (LinkedListTree)ast.getChild(i);
            if (result.length() > 0) {
                result.append(".");
            }
            result.append(part.getText());
        }
        return result.toString();
    }

    public static String typeSpecText(LinkedListTree ast) {
        if (ast.getType() != 18) {
            throw new IllegalArgumentException("expected TYPE_SPEC, but token was a " + ASTUtils.tokenName(ast));
        }
        LinkedListTree type = ast.getFirstChild();
        if (type.getType() == 48) {
            return ASTUtils.identText(type);
        }
        return type.getText();
    }

    public static String tokenName(LinkedListTree ast) {
        return ASTUtils.tokenName(ast.getType());
    }

    public static String tokenName(int type) {
        if (type == -1) {
            return "<EOF>";
        }
        return AS3Parser.tokenNames[type];
    }

    public static LinkedListTree findChildByType(LinkedListTree ast, int type) {
        return (LinkedListTree)ast.getFirstChildWithType(type);
    }

    public static AS3Parser parse(String text) {
        return ASTUtils.parse(new StringReader(text));
    }

    public static AS3Parser parse(Reader in) {
        ANTLRReaderStream cs;
        try {
            cs = new ANTLRReaderStream(in);
        }
        catch (IOException e) {
            throw new SyntaxException(e);
        }
        AS3Lexer lexer = new AS3Lexer(cs);
        LinkedListTokenSource linker = new LinkedListTokenSource(lexer);
        LinkedListTokenStream tokenStream = new LinkedListTokenStream(linker);
        AS3Parser parser = new AS3Parser(tokenStream);
        parser.setInput(lexer, cs);
        parser.setTreeAdaptor(TREE_ADAPTOR);
        return parser;
    }

    public static SyntaxException buildSyntaxException(String statement, AS3Parser parser, RecognitionException e) {
        String msg;
        if (e instanceof NoViableAltException) {
            NoViableAltException ex = (NoViableAltException)e;
            msg = "Unexpected token " + ASTUtils.tokenName(parser, ex.getUnexpectedType());
            if (statement != null) {
                msg = msg + " in " + ActionScriptFactory.str(statement);
            }
        } else if (e instanceof MismatchedTokenException) {
            MismatchedTokenException ex = (MismatchedTokenException)e;
            msg = "Unexpected token " + ASTUtils.tokenName(parser, ex.getUnexpectedType()) + " (expecting " + ASTUtils.tokenName(parser, ex.expecting) + ")";
            if (statement != null) {
                msg = msg + " in " + ActionScriptFactory.str(statement);
            }
        } else {
            msg = statement == null ? "" : "Problem parsing " + ActionScriptFactory.str(statement);
        }
        msg = msg + " at line " + e.line;
        return new SyntaxException(msg, e);
    }

    private static String tokenName(AS3Parser parser, int type) {
        if (type == -1) {
            return "<end-of-file>";
        }
        return parser.getTokenNames()[type];
    }

    public static LinkedListTree newAST(int type) {
        return ASTUtils.newImaginaryAST(type);
    }

    public static LinkedListTree newImaginaryAST(int type) {
        return (LinkedListTree)TREE_ADAPTOR.create(type, ASTUtils.tokenName(type));
    }

    public static LinkedListTree newPlaceholderAST(int type) {
        LinkedListTree node = ASTUtils.newImaginaryAST(type);
        LinkedListToken placeholder = TokenBuilder.newPlaceholder(node);
        return node;
    }

    public static LinkedListTree newAST(int type, String text) {
        LinkedListToken tok = TokenBuilder.newToken(type, text);
        LinkedListTree ast = (LinkedListTree)TREE_ADAPTOR.create(tok);
        return ast;
    }

    public static LinkedListTree newAST(LinkedListToken tok) {
        return (LinkedListTree)TREE_ADAPTOR.create(tok);
    }

    public static LinkedListTree newParentheticAST(int type, int startType, String startText, int endType, String endText) {
        LinkedListTree ast = ASTUtils.newImaginaryAST(type);
        LinkedListToken start = TokenBuilder.newToken(startType, startText);
        ast.setStartToken(start);
        LinkedListToken stop = TokenBuilder.newToken(endType, endText);
        ast.setStopToken(stop);
        start.setNext(stop);
        ast.setInitialInsertionAfter(start);
        return ast;
    }

    public static void increaseIndent(LinkedListTree node, String indent) {
        LinkedListToken newStart = ASTUtils.increaseIndentAt(node.getStartToken(), indent);
        node.setStartToken(newStart);
        ASTUtils.increaseIndentAfterFirstLine(node, indent);
    }

    public static void increaseIndentAfterFirstLine(LinkedListTree node, String indent) {
        block4: for (LinkedListToken tok = node.getStartToken(); tok != node.getStopToken(); tok = tok.getNext()) {
            switch (tok.getType()) {
                case 176: {
                    tok = ASTUtils.increaseIndentAt(tok.getNext(), indent);
                    continue block4;
                }
                case 179: {
                    DocCommentUtils.increaseCommentIndent(tok, indent);
                }
            }
        }
    }

    private static LinkedListToken increaseIndentAt(LinkedListToken tok, String indentStr) {
        if (tok.getType() == 175) {
            tok.setText(indentStr + tok.getText());
            return tok;
        }
        LinkedListToken indent = TokenBuilder.newWhiteSpace(indentStr);
        tok.beforeInsert(indent);
        return indent;
    }

    public static String findIndent(LinkedListTree node) {
        LinkedListToken tok = node.getStartToken();
        if (tok == null) {
            return ASTUtils.findIndent(node.getParent());
        }
        while ((tok.getType() == 176 || tok.getType() == 175) && tok.getNext() != null) {
            tok = tok.getNext();
        }
        while (tok.getPrev() != null && tok.getType() != 176) {
            tok = tok.getPrev();
        }
        if (tok.getType() == 175) {
            return tok.getText();
        }
        if (tok.getType() != 176) {
            return "";
        }
        LinkedListToken startOfLine = tok.getNext();
        if (startOfLine.getType() == 175) {
            return startOfLine.getText();
        }
        return "";
    }

    public static void addChildWithIndentation(LinkedListTree ast, LinkedListTree stmt) {
        LinkedListTree last = ast.getLastChild();
        String indent = last == null ? "\t" + ASTUtils.findIndent(ast) : ASTUtils.findIndent(last);
        ASTUtils.increaseIndent(stmt, indent);
        stmt.addToken(0, TokenBuilder.newNewline());
        ast.addChildWithTokens(stmt);
    }

    public static void addChildWithIndentation(LinkedListTree ast, int index, LinkedListTree stmt) {
        LinkedListTree last = (LinkedListTree)ast.getChild(index);
        String indent = last == null ? "\t" + ASTUtils.findIndent(ast) : ASTUtils.findIndent(last);
        ASTUtils.increaseIndent(stmt, indent);
        stmt.addToken(0, TokenBuilder.newNewline());
        ast.addChildWithTokens(index, stmt);
    }

    public static String decodeStringLiteral(String str) {
        StringBuffer result = new StringBuffer();
        char[] s = str.toCharArray();
        int end = s.length - 1;
        if (s[0] != '\"' && s[0] != '\'') {
            throw new SyntaxException("Invalid delimiter at position 0: " + s[0]);
        }
        char delimiter = s[0];
        block8: for (int i = 1; i < end; ++i) {
            char c = s[i];
            switch (c) {
                case '\\': {
                    c = s[++i];
                    switch (c) {
                        case 'n': {
                            result.append('\n');
                            continue block8;
                        }
                        case 't': {
                            result.append('\t');
                            continue block8;
                        }
                        case '\\': {
                            result.append('\\');
                            continue block8;
                        }
                    }
                    result.append(c);
                    continue block8;
                }
                default: {
                    result.append(c);
                }
            }
        }
        if (s[end] != delimiter) {
            throw new SyntaxException("End delimiter doesn't match " + delimiter + " at position " + end);
        }
        return result.toString();
    }

    public static LinkedListToken newStringLiteral(String constant) {
        return new LinkedListToken(69, ActionScriptFactory.str(constant));
    }

    public static void removeTrailingWhitespaceAndComma(LinkedListToken stopToken) {
        for (LinkedListToken tok = stopToken.getNext(); tok != null; tok = tok.getNext()) {
            if (tok.getChannel() != 99) {
                if (tok.getType() == 66) {
                    tok.delete();
                    break;
                }
                throw new SyntaxException("Unexpected token: " + tok);
            }
            tok.delete();
        }
    }

    public static void removePreceedingWhitespaceAndComma(LinkedListToken startToken) {
        for (LinkedListToken tok = startToken.getPrev(); tok != null; tok = tok.getPrev()) {
            if (tok.getChannel() != 99) {
                if (tok.getType() == 66) {
                    tok.delete();
                    break;
                }
                throw new SyntaxException("Unexpected token: " + tok);
            }
            LinkedListToken del = tok;
            tok = tok.getNext();
            del.delete();
        }
    }

    public static void assertAS3TokenTypeIs(int expected, int actual) {
        if (expected != actual) {
            throw new SyntaxException("Expected " + ASTUtils.tokenName(expected) + ", got " + ASTUtils.tokenName(actual));
        }
    }

    public static void assertAS3TokenTypeIs(String msg, int expected, int actual) {
        if (expected != actual) {
            throw new SyntaxException(msg + " Expected " + ASTUtils.tokenName(expected) + ", got " + ASTUtils.tokenName(actual));
        }
    }

    public static String stringifyNode(LinkedListTree ast) {
        StringBuffer result = new StringBuffer();
        for (LinkedListToken tok = ast.getStartToken(); tok != null && tok.getType() != -1; tok = tok.getNext()) {
            result.append(tok.getText());
            if (tok == ast.getStopToken()) break;
        }
        return result.toString();
    }

    public static void deleteAllChildren(LinkedListTree ast) {
        while (ast.getChildCount() > 0) {
            ast.deleteChild(0);
        }
    }

    public static LinkedListTree ast(Expression expr) {
        return ((ASTExpression)expr).getAST();
    }

    static {
        TREE_ADAPTOR.setFactory(new LinkedListTreeAdaptor.Factory(){
            private BasicListUpdateDelegate basicDelegate = new BasicListUpdateDelegate();
            private ParentheticListUpdateDelegate blockDelegate = new ParentheticListUpdateDelegate(59, 60);
            private ParentheticListUpdateDelegate metadataTagDelegate = new ParentheticListUpdateDelegate(111, 112);
            private ParentheticListUpdateDelegate paramsDelegate = new ParentheticListUpdateDelegate(78, 79);

            public TreeTokenListUpdateDelegate create(LinkedListTree payload) {
                if (payload.isNil()) {
                    return this.basicDelegate;
                }
                switch (payload.getType()) {
                    case 5: 
                    case 19: 
                    case 39: {
                        return this.blockDelegate;
                    }
                    case 9: 
                    case 38: {
                        return this.metadataTagDelegate;
                    }
                    case 10: 
                    case 16: 
                    case 21: 
                    case 22: 
                    case 24: {
                        return this.paramsDelegate;
                    }
                }
                return this.basicDelegate;
            }
        });
    }
}

