/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.Iterator;
import org.gvnix.flex.addon.metaas.ActionScriptProject;
import org.gvnix.flex.addon.metaas.dom.ASClassType;
import org.gvnix.flex.addon.metaas.dom.ASCompilationUnit;
import org.gvnix.flex.addon.metaas.dom.ASField;
import org.gvnix.flex.addon.metaas.dom.ASInterfaceType;
import org.gvnix.flex.addon.metaas.dom.ASMember;
import org.gvnix.flex.addon.metaas.dom.ASMethod;
import org.gvnix.flex.addon.metaas.dom.ASPackage;
import org.gvnix.flex.addon.metaas.dom.ASType;
import org.gvnix.flex.addon.metaas.impl.ASTASCompilationUnit;
import org.gvnix.flex.addon.metaas.impl.ASVisitor;

public class ASWalker {
    private ASVisitor visitor;

    public ASWalker(ASVisitor visitor) {
        this.visitor = visitor;
    }

    public void walk(ActionScriptProject project) {
        this.visitor.visit(project);
        Iterator i = project.getCompilationUnits().iterator();
        while (i.hasNext()) {
            ASTASCompilationUnit cu = (ASTASCompilationUnit)i.next();
            this.walk(cu);
        }
    }

    public void walk(ASCompilationUnit cu) {
        this.visitor.visit(cu);
        this.walk(cu.getPackage());
    }

    public void walk(ASPackage pkg) {
        this.visitor.visit(pkg);
        this.walk(pkg.getType());
    }

    public void walk(ASType type) {
        this.visitor.visit(type);
        if (type instanceof ASClassType) {
            this.walk((ASClassType)type);
        }
        if (type instanceof ASInterfaceType) {
            this.walk((ASInterfaceType)type);
        }
    }

    public void walk(ASClassType clazz) {
        this.visitor.visit(clazz);
        Iterator i = clazz.getMethods().iterator();
        while (i.hasNext()) {
            ASMethod method = (ASMethod)i.next();
            this.walk((ASMember)method);
            this.walk(method);
        }
        i = clazz.getFields().iterator();
        while (i.hasNext()) {
            ASField field = (ASField)i.next();
            this.walk((ASMember)field);
            this.walk(field);
        }
    }

    public void walk(ASInterfaceType iface) {
        this.visitor.visit(iface);
        Iterator i = iface.getMethods().iterator();
        while (i.hasNext()) {
            ASMethod method = (ASMethod)i.next();
            this.walk((ASMember)method);
            this.walk(method);
        }
    }

    public void walk(ASMember member) {
        this.visitor.visit(member);
    }

    public void walk(ASMethod method) {
        this.visitor.visit(method);
    }

    public void walk(ASField field) {
        this.visitor.visit(field);
    }
}

