/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.HashMap;
import java.util.Map;
import org.gvnix.flex.addon.antlr.runtime.Token;
import org.gvnix.flex.addon.metaas.dom.ASAssignmentExpression;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;

public class AssignmentOperatorMap {
    private static final Map OPERATORS_BY_TYPE = new HashMap();
    private static final Map TYPES_BY_OPERATOR = new HashMap();

    private static void mapOp(int type, String text, ASAssignmentExpression.Op operator) {
        OPERATORS_BY_TYPE.put(new Integer(type), operator);
        TYPES_BY_OPERATOR.put(operator, new LinkedListToken(type, text));
    }

    public static ASAssignmentExpression.Op opFromType(int type) {
        ASAssignmentExpression.Op op = (ASAssignmentExpression.Op)OPERATORS_BY_TYPE.get(new Integer(type));
        if (op == null) {
            throw new IllegalArgumentException("No operator for token-type " + ASTUtils.tokenName(type));
        }
        return op;
    }

    public static void initialiseFromOp(ASAssignmentExpression.Op operator, Token tok) {
        LinkedListToken type = (LinkedListToken)TYPES_BY_OPERATOR.get(operator);
        if (type == null) {
            throw new IllegalArgumentException("No operator for Op " + operator);
        }
        tok.setType(type.getType());
        tok.setText(type.getText());
    }

    static {
        AssignmentOperatorMap.mapOp(119, "+=", ASAssignmentExpression.Op.ADD_ASSIGN);
        AssignmentOperatorMap.mapOp(77, "=", ASAssignmentExpression.Op.ASSIGN);
        AssignmentOperatorMap.mapOp(124, "&=", ASAssignmentExpression.Op.BITAND_ASSIGN);
        AssignmentOperatorMap.mapOp(126, "|=", ASAssignmentExpression.Op.BITOR_ASSIGN);
        AssignmentOperatorMap.mapOp(125, "^=", ASAssignmentExpression.Op.BITXOR_ASSIGN);
        AssignmentOperatorMap.mapOp(117, "/=", ASAssignmentExpression.Op.DIV_ASSIGN);
        AssignmentOperatorMap.mapOp(118, "%=", ASAssignmentExpression.Op.MOD_ASSIGN);
        AssignmentOperatorMap.mapOp(116, "*=", ASAssignmentExpression.Op.MUL_ASSIGN);
        AssignmentOperatorMap.mapOp(121, "<<=", ASAssignmentExpression.Op.SL_ASSIGN);
        AssignmentOperatorMap.mapOp(122, ">>=", ASAssignmentExpression.Op.SR_ASSIGN);
        AssignmentOperatorMap.mapOp(123, ">>=", ASAssignmentExpression.Op.SRU_ASSIGN);
        AssignmentOperatorMap.mapOp(120, "-=", ASAssignmentExpression.Op.SUB_ASSIGN);
    }
}

