/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gvnix.flex.addon.metaas.dom.ASArg;
import org.gvnix.flex.addon.metaas.dom.ASClassType;
import org.gvnix.flex.addon.metaas.dom.ASInterfaceType;
import org.gvnix.flex.addon.metaas.dom.ASMember;
import org.gvnix.flex.addon.metaas.dom.ASMethod;
import org.gvnix.flex.addon.metaas.dom.ASPackage;
import org.gvnix.flex.addon.metaas.dom.ASType;
import org.gvnix.flex.addon.metaas.impl.AS3FragmentParser;
import org.gvnix.flex.addon.metaas.impl.ASQName;
import org.gvnix.flex.addon.metaas.impl.ASTASMethod;
import org.gvnix.flex.addon.metaas.impl.ASTActionScriptProject;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.ASVisitor;
import org.gvnix.flex.addon.metaas.impl.ASWalker;
import org.gvnix.flex.addon.metaas.impl.ResourceRoot;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class AutoImporter {
    private List visibleQNames = new ArrayList();
    private Set possiblyAmbigLocalNames = new HashSet();

    public void performAutoImport(ASTActionScriptProject project) {
        this.loadAccessableLanguageElements(project);
        this.processSources(project);
    }

    private void loadAccessableLanguageElements(ASTActionScriptProject project) {
        final HashSet<String> seenLocalNames = new HashSet<String>();
        ASVisitor.Null visitor = new ASVisitor.Null(){

            public void visit(ASPackage pkg) {
                ASType type = pkg.getType();
                ASQName name = new ASQName(pkg.getName(), type.getName());
                AutoImporter.this.visibleQNames.add(name);
                if (seenLocalNames.contains(name.getLocalName())) {
                    AutoImporter.this.possiblyAmbigLocalNames.add(name.getLocalName());
                } else {
                    seenLocalNames.add(name.getLocalName());
                }
            }
        };
        new ASWalker(visitor).walk(project);
        Iterator i = project.getResourceRoots().iterator();
        while (i.hasNext()) {
            ResourceRoot resourceRoot = (ResourceRoot)i.next();
            Iterator j = resourceRoot.getDefinitionQNames().iterator();
            while (j.hasNext()) {
                ASQName name = (ASQName)j.next();
                this.visibleQNames.add(name);
                if (seenLocalNames.contains(name.getLocalName())) {
                    this.possiblyAmbigLocalNames.add(name.getLocalName());
                    continue;
                }
                seenLocalNames.add(name.getLocalName());
            }
        }
    }

    private void processSources(ASTActionScriptProject project) {
        new ASWalker(new ImportSourceProcessor()).walk(project);
    }

    private class ImportSourceProcessor
    extends ASVisitor.Null {
        private String currentPackageName;
        private ASQName currentTypeName;
        private ASPackage currentPackage;
        private Set currentPackageImports = new HashSet();
        private ASType currentType;

        private ImportSourceProcessor() {
        }

        public void visit(ASPackage pkg) {
            this.currentPackage = pkg;
            this.currentPackageName = pkg.getName();
            this.inspectImports(pkg);
        }

        private void inspectImports(ASPackage pkg) {
            this.currentPackageImports.clear();
            List imports = pkg.findImports();
            Iterator i = imports.iterator();
            while (i.hasNext()) {
                ASQName imp = new ASQName((String)i.next());
                if (imp.getLocalName().equals("*")) {
                    this.importNamesFromPackage(imp.getPackagePrefix());
                    continue;
                }
                this.currentPackageImports.add(imp);
            }
        }

        private void importNamesFromPackage(String packagePrefix) {
            Iterator i = AutoImporter.this.visibleQNames.iterator();
            while (i.hasNext()) {
                ASQName name = (ASQName)i.next();
                if (!packagePrefix.equals(name.getPackagePrefix())) continue;
                this.currentPackageImports.add(name);
            }
        }

        public void visit(ASType type) {
            this.currentTypeName = new ASQName(this.currentPackageName, type.getName());
            this.currentType = type;
        }

        public void visit(ASClassType clazz) {
            String superClassName = clazz.getSuperclass();
            String processed = this.processTypeName(superClassName);
            if (processed != null) {
                clazz.setSuperclass(processed);
            }
            List interfaceNames = clazz.getImplementedInterfaces();
            Iterator i = interfaceNames.iterator();
            while (i.hasNext()) {
                String interfaceName = (String)i.next();
                processed = this.processTypeName(interfaceName);
                if (processed == null) continue;
                clazz.removeImplementedInterface(interfaceName);
                clazz.addImplementedInterface(processed);
            }
        }

        public void visit(ASInterfaceType iface) {
            List interfaceNames = iface.getSuperInterfaces();
            Iterator i = interfaceNames.iterator();
            while (i.hasNext()) {
                String interfaceName = (String)i.next();
                String processed = this.processTypeName(interfaceName);
                if (processed == null) continue;
                iface.removeSuperInterface(interfaceName);
                iface.addSuperInterface(processed);
            }
        }

        public void visit(ASMember member) {
            String processedName = this.processTypeName(member.getType());
            if (processedName != null) {
                member.setType(processedName);
            }
        }

        private String processTypeName(String typeName) {
            ASQName qname;
            if (typeName != null && (qname = new ASQName(typeName)).isQualified() && AutoImporter.this.visibleQNames.contains(qname)) {
                if (this.importRequired(qname)) {
                    this.addImport(qname);
                }
                if (!AutoImporter.this.possiblyAmbigLocalNames.contains(qname.getLocalName())) {
                    return qname.getLocalName();
                }
            }
            return null;
        }

        private boolean importRequired(ASQName qname) {
            if (this.currentPackageName != null && this.currentPackageName.equals(qname.getPackagePrefix())) {
                return false;
            }
            return !this.currentPackageImports.contains(qname);
        }

        private void addImport(ASQName qname) {
            this.currentPackage.addImport(qname.toString());
            this.currentPackageImports.add(qname);
        }

        public void visit(ASMethod method) {
            this.processAllArgs(method);
            if (this.currentType instanceof ASClassType) {
                this.processBody(method);
            }
        }

        private void processAllArgs(ASMethod method) {
            List args = method.getArgs();
            Iterator i = args.iterator();
            while (i.hasNext()) {
                this.processArg((ASArg)i.next());
            }
        }

        private void processArg(ASArg arg) {
            String processedName = this.processTypeName(arg.getType());
            if (processedName != null) {
                arg.setType(processedName);
            }
        }

        private void processBody(ASMethod method) {
            LinkedListTree ast = ((ASTASMethod)method).getAST();
            LinkedListTree body = (LinkedListTree)ast.getFirstChildWithType(19);
            this.processTreeForImports(body);
        }

        private void processTreeForImports(LinkedListTree ast) {
            if (this.processNodeForImports(ast)) {
                for (int i = 0; i < ast.getChildCount(); ++i) {
                    LinkedListTree child = (LinkedListTree)ast.getChild(i);
                    this.processTreeForImports(child);
                }
            }
        }

        private boolean processNodeForImports(LinkedListTree ast) {
            switch (ast.getType()) {
                case 18: {
                    this.processTypeSpecForImports(ast);
                    return false;
                }
                case 48: {
                    this.processIdentifierForImports(ast);
                    return false;
                }
                case 27: {
                    this.processPropertyOrIdentifierForImports(ast);
                    return false;
                }
            }
            return true;
        }

        private void processTypeSpecForImports(LinkedListTree ast) {
            String typeName = ASTUtils.typeSpecText(ast);
            String processedName = this.processTypeName(typeName);
            if (processedName != null) {
                LinkedListTree newTypeSpec = AS3FragmentParser.parseTypeSpec(processedName);
                ast.setChildWithTokens(0, newTypeSpec.getFirstChild());
            }
        }

        private void processIdentifierForImports(LinkedListTree ast) {
            System.out.println(ASTUtils.identText(ast));
        }

        private ASQName processPropertyOrIdentifierForImports(LinkedListTree ast) {
            LinkedListTree target = ast.getFirstChild();
            LinkedListTree name = ast.getLastChild();
            if (name.getType() != 105) {
                return null;
            }
            ASQName qname = null;
            if (target.getType() == 27) {
                ASQName tmp = this.processPropertyOrIdentifierForImports(target);
                if (tmp != null) {
                    qname = new ASQName(tmp.toString(), name.getText());
                }
            } else if (target.getType() == 105) {
                qname = new ASQName(target.getText(), name.getText());
            }
            if (qname == null) {
                ast.token.setType(28);
            } else {
                String processedName = this.processTypeName(qname.toString());
                if (processedName != null) {
                    int myIndex = ast.getParent().getIndexOfChild(ast);
                    ast.getParent().setChildWithTokens(myIndex, ASTUtils.newAST(105, processedName));
                    qname = null;
                }
            }
            return qname;
        }
    }
}

