/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.HashMap;
import java.util.Map;
import org.gvnix.flex.addon.antlr.runtime.Token;
import org.gvnix.flex.addon.metaas.dom.ASBinaryExpression;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;

public class BinaryOperatorMap {
    private static final Map OPERATORS_BY_TYPE = new HashMap();
    private static final Map TYPES_BY_OPERATOR = new HashMap();

    private static void mapOp(int type, String text, ASBinaryExpression.Op operator) {
        OPERATORS_BY_TYPE.put(new Integer(type), operator);
        TYPES_BY_OPERATOR.put(operator, new LinkedListToken(type, text));
    }

    public static ASBinaryExpression.Op opFromType(int type) {
        ASBinaryExpression.Op op = (ASBinaryExpression.Op)OPERATORS_BY_TYPE.get(new Integer(type));
        if (op == null) {
            throw new IllegalArgumentException("No operator for token-type " + ASTUtils.tokenName(type));
        }
        return op;
    }

    public static void initialiseFromOp(ASBinaryExpression.Op operator, Token tok) {
        LinkedListToken type = (LinkedListToken)TYPES_BY_OPERATOR.get(operator);
        if (type == null) {
            throw new IllegalArgumentException("No operator for Op " + operator);
        }
        tok.setType(type.getType());
        tok.setText(type.getText());
    }

    static {
        BinaryOperatorMap.mapOp(149, "+", ASBinaryExpression.Op.ADD);
        BinaryOperatorMap.mapOp(131, "&&", ASBinaryExpression.Op.AND);
        BinaryOperatorMap.mapOp(134, "&", ASBinaryExpression.Op.BITAND);
        BinaryOperatorMap.mapOp(132, "|", ASBinaryExpression.Op.BITOR);
        BinaryOperatorMap.mapOp(133, "^", ASBinaryExpression.Op.BITXOR);
        BinaryOperatorMap.mapOp(151, "/", ASBinaryExpression.Op.DIV);
        BinaryOperatorMap.mapOp(138, "==", ASBinaryExpression.Op.EQ);
        BinaryOperatorMap.mapOp(142, ">=", ASBinaryExpression.Op.GE);
        BinaryOperatorMap.mapOp(140, ">", ASBinaryExpression.Op.GT);
        BinaryOperatorMap.mapOp(141, "<=", ASBinaryExpression.Op.LE);
        BinaryOperatorMap.mapOp(139, "<", ASBinaryExpression.Op.LT);
        BinaryOperatorMap.mapOp(152, "%", ASBinaryExpression.Op.MOD);
        BinaryOperatorMap.mapOp(31, "*", ASBinaryExpression.Op.MUL);
        BinaryOperatorMap.mapOp(137, "!=", ASBinaryExpression.Op.NE);
        BinaryOperatorMap.mapOp(130, "||", ASBinaryExpression.Op.OR);
        BinaryOperatorMap.mapOp(146, "<<", ASBinaryExpression.Op.SL);
        BinaryOperatorMap.mapOp(147, ">>", ASBinaryExpression.Op.SR);
        BinaryOperatorMap.mapOp(148, ">>>", ASBinaryExpression.Op.SRU);
        BinaryOperatorMap.mapOp(150, "-", ASBinaryExpression.Op.SUB);
    }
}

