/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.gvnix.flex.addon.antlr.runtime.ANTLRReaderStream;
import org.gvnix.flex.addon.antlr.runtime.MismatchedTokenException;
import org.gvnix.flex.addon.antlr.runtime.RecognitionException;
import org.gvnix.flex.addon.metaas.ActionScriptFactory;
import org.gvnix.flex.addon.metaas.SyntaxException;
import org.gvnix.flex.addon.metaas.dom.DocComment;
import org.gvnix.flex.addon.metaas.dom.DocTag;
import org.gvnix.flex.addon.metaas.impl.ASTDocComment;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTokenSource;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTokenStream;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTreeAdaptor;
import org.gvnix.flex.addon.metaas.impl.parser.javadoc.JavadocLexer;
import org.gvnix.flex.addon.metaas.impl.parser.javadoc.JavadocParser;

class DocCommentUtils {
    private static final LinkedListTreeAdaptor TREE_ADAPTOR = new LinkedListTreeAdaptor();

    private DocCommentUtils() {
    }

    public static String getDocComment(LinkedListTree node) {
        LinkedListToken tok = DocCommentUtils.findDocCommentToken(node);
        if (tok == null) {
            return null;
        }
        return DocCommentUtils.commentToString(tok);
    }

    public static LinkedListToken findDocCommentToken(LinkedListTree node) {
        LinkedListToken tok = node.getStartToken();
        if (tok == null) {
            return null;
        }
        block7: while (true) {
            switch (tok.getType()) {
                case 175: 
                case 176: 
                case 178: 
                case 179: {
                    tok = tok.getNext();
                    continue block7;
                }
            }
            break;
        }
        block8: for (tok = tok.getPrev(); tok != null; tok = tok.getPrev()) {
            switch (tok.getType()) {
                case 175: 
                case 176: {
                    continue block8;
                }
                case 179: {
                    if (tok.getText().startsWith("/**")) {
                        return tok;
                    }
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static String commentToString(LinkedListToken tok) {
        return tok.getText().replaceFirst("\\A/\\*+", "").replaceFirst("(?:(?<=[\n\r])[ \t]+)?\\*+/\\Z", "").replaceAll("([\n\r])\\s*\\*", "$1");
    }

    public static void setDocComment(LinkedListTree node, String text) {
        LinkedListToken tok = DocCommentUtils.findDocCommentToken(node);
        if (text == null) {
            if (tok != null) {
                LinkedListToken next = tok.getNext();
                LinkedListToken prev = tok.getPrev();
                tok.delete();
                if (next.getType() == 176) {
                    next.getNext();
                }
                if (prev.getType() == 175) {
                    prev.getPrev();
                }
            }
            return;
        }
        DocCommentUtils.assertValidContent(text);
        String indent = ASTUtils.findIndent(node);
        text = "/**" + text.replaceAll("(\n|\r\n|\r)", "$1" + indent + " *");
        if (!text.endsWith("*")) {
            text = text + "*";
        }
        text = text + "/";
        if (tok == null) {
            LinkedListToken comment = TokenBuilder.newMLComment(text);
            DocCommentUtils.insertDocComment(node, indent, comment);
        } else {
            tok.setText(text);
        }
    }

    private static void insertDocComment(LinkedListTree node, String indent, LinkedListToken comment) {
        LinkedListToken nl = TokenBuilder.newNewline();
        DocCommentUtils.findTokenToInsertCommentBefore(node).beforeInsert(comment);
        comment.afterInsert(nl);
        if (indent.length() > 0) {
            LinkedListToken indentTok = TokenBuilder.newWhiteSpace(indent);
            nl.afterInsert(indentTok);
        }
    }

    private static LinkedListToken findTokenToInsertCommentBefore(LinkedListTree node) {
        LinkedListToken tok = node.getStartToken();
        block3: while (true) {
            switch (tok.getType()) {
                case 175: 
                case 176: {
                    tok = tok.getNext();
                    continue block3;
                }
            }
            break;
        }
        return tok;
    }

    public static void assertValidContent(String text) {
        int pos = text.indexOf("*/");
        if (pos != -1) {
            throw new SyntaxException("End-on-comment marker found at position " + pos);
        }
    }

    public static void increaseCommentIndent(LinkedListToken tok, String indent) {
        tok.setText(tok.getText().replaceAll("(\n|\r\n|\r)", "$1" + indent));
    }

    public static String getDescriptionString(LinkedListTree ast) {
        LinkedListTree javadoc = DocCommentUtils.buildJavadoc(ast);
        if (javadoc == null) {
            return null;
        }
        LinkedListTree desc = javadoc.getFirstChild();
        return DocCommentUtils.stringify(desc);
    }

    public static LinkedListTree buildJavadoc(LinkedListTree ast) {
        LinkedListToken doc = DocCommentUtils.findDocCommentToken(ast);
        if (doc == null) {
            return null;
        }
        String body = DocCommentUtils.getCommentBody(doc);
        LinkedListTree javadoc = DocCommentUtils.parse(body);
        return javadoc;
    }

    private static String getCommentBody(LinkedListToken doc) {
        String text = doc.getText();
        return text.substring(3, text.length() - 2);
    }

    private static String stringify(LinkedListTree ast) {
        StringBuffer result = new StringBuffer();
        for (LinkedListToken tok = ast.getStartToken(); tok != null && tok.getType() != -1; tok = tok.getNext()) {
            result.append(DocCommentUtils.stringify(tok));
            if (tok == ast.getStopToken()) break;
        }
        return result.toString();
    }

    private static String stringify(LinkedListToken tok) {
        switch (tok.getType()) {
            case 9: {
                return "\n";
            }
        }
        return tok.getText();
    }

    public static void setDescriptionString(LinkedListTree ast, String description) {
        LinkedListToken doc = DocCommentUtils.findDocCommentToken(ast);
        LinkedListTree javadoc = null;
        LinkedListTree desc = null;
        if (doc != null) {
            javadoc = DocCommentUtils.parse(DocCommentUtils.getCommentBody(doc));
            DocCommentUtils.trimEOF(javadoc);
            desc = javadoc.getFirstChild();
        }
        if (description == null) {
            if (desc != null) {
                ASTUtils.deleteAllChildren(desc);
                doc.setText("/**" + ASTUtils.stringifyNode(javadoc) + "*/");
            }
            return;
        }
        DocCommentUtils.assertValidContent(description);
        String newline = DocCommentUtils.getNewlineText(ast, javadoc);
        if (!description.startsWith("\n")) {
            description = "\n" + description;
        }
        description = description.replaceAll("\n", newline);
        LinkedListTree newDesc = DocCommentUtils.parseDescription(description);
        if (doc == null) {
            String indent = ASTUtils.findIndent(ast);
            doc = TokenBuilder.newMLComment("/**" + ASTUtils.stringifyNode(newDesc) + "\n" + indent + " */");
            DocCommentUtils.insertDocComment(ast, indent, doc);
        } else {
            newDesc.appendToken(new LinkedListToken(9, newline));
            javadoc.setChildWithTokens(0, newDesc);
            doc.setText("/**" + ASTUtils.stringifyNode(javadoc) + "*/");
        }
    }

    public static String getNewlineText(LinkedListTree ast, LinkedListTree javadoc) {
        String newline = null;
        if (javadoc != null) {
            newline = DocCommentUtils.findNewline(javadoc);
        }
        if (newline == null) {
            newline = "\n" + ASTUtils.findIndent(ast) + " * ";
        }
        return newline;
    }

    public static String findNewline(LinkedListTree javadoc) {
        LinkedListToken tok = javadoc.getStopToken();
        if (tok.getType() == 9) {
            tok = tok.getPrev();
        }
        while (tok != null) {
            if (tok.getType() == 9) {
                return tok.getText();
            }
            tok = tok.getPrev();
        }
        return null;
    }

    private static LinkedListTree parseDescription(String description) {
        try {
            JavadocParser parser = DocCommentUtils.parserOn(description);
            LinkedListTree desc = (LinkedListTree)parser.description().getTree();
            LinkedListToken after = (LinkedListToken)parser.getTokenStream().LT(1);
            if (!DocCommentUtils.isEOF(after)) {
                throw new SyntaxException("trailing content after description: " + ActionScriptFactory.str(after.getText()));
            }
            DocCommentUtils.trimEOF(desc);
            return desc;
        }
        catch (IOException e) {
            throw new SyntaxException(e);
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    private static boolean isEOF(LinkedListToken after) {
        return after.getType() == -1;
    }

    private static void trimEOF(LinkedListTree desc) {
        LinkedListTree lastChild = desc.getLastChild();
        if (lastChild != null) {
            DocCommentUtils.trimEOF(lastChild);
        }
        while (DocCommentUtils.isEOF(desc.getStopToken())) {
            LinkedListToken stop = desc.getStopToken();
            LinkedListToken prev = stop.getPrev();
            desc.setStopToken(prev);
            stop.delete();
        }
    }

    private static LinkedListTree parse(String body) {
        try {
            JavadocParser parser = DocCommentUtils.parserOn(body);
            LinkedListTree result = (LinkedListTree)parser.comment_body().getTree();
            DocCommentUtils.trimEOF(result);
            return result;
        }
        catch (IOException e) {
            throw new SyntaxException(e);
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    public static LinkedListTree parseParaTag(String text) {
        try {
            JavadocParser parser = DocCommentUtils.parserOn(text);
            LinkedListTree result = (LinkedListTree)parser.paragraph_tag().getTree();
            DocCommentUtils.trimEOF(result);
            return result;
        }
        catch (IOException e) {
            throw new SyntaxException(e);
        }
        catch (MismatchedTokenException e) {
            throw new SyntaxException("Expexted " + JavadocParser.tokenNames[e.expecting] + " but found " + JavadocParser.tokenNames[e.getUnexpectedType()], e);
        }
        catch (RecognitionException e) {
            throw new SyntaxException(e);
        }
    }

    private static JavadocParser parserOn(String text) throws IOException {
        StringReader in = new StringReader(text);
        ANTLRReaderStream cs = new ANTLRReaderStream(in);
        JavadocLexer lexer = new JavadocLexer(cs);
        LinkedListTokenSource source = new LinkedListTokenSource(lexer);
        LinkedListTokenStream stream = new LinkedListTokenStream(source);
        JavadocParser parser = new JavadocParser(stream);
        parser.setTreeAdaptor(TREE_ADAPTOR);
        return parser;
    }

    public static ASTDocComment createDocComment(LinkedListTree ast) {
        return new ASTDocComment(ast);
    }

    public static DocTag findParam(DocComment doc, String name) {
        Iterator params = doc.findTags("param");
        Pattern p = Pattern.compile("\\s*\\Q" + name + "\\E\\b");
        while (params.hasNext()) {
            DocTag param = (DocTag)params.next();
            if (!p.matcher(param.getBodyString()).lookingAt()) continue;
            return param;
        }
        return null;
    }
}

